/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.util.ByteUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class FechamentoEmpacotamentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private Button buttonInicioDesenvolvimento;
    @FXML
    private Label labelPacoteSelecionado;
    private PlanejamentoEntity planejamento;
    private File pacoteSelecionado;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.atualizaCombo();
        Platform.runLater(() -> {
            try {
                this.clearLog();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        });
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                byte[] streamArquivo;
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                FechamentoEmpacotamentoController.this.desabilitaComponentes();
                FechamentoEmpacotamentoController.this.planejamento = (PlanejamentoEntity)FechamentoEmpacotamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                String nomeArquivoOriginal = FechamentoEmpacotamentoController.this.pacoteSelecionado == null ? null : FechamentoEmpacotamentoController.this.pacoteSelecionado.getName();
                byte[] byArray = streamArquivo = FechamentoEmpacotamentoController.this.pacoteSelecionado == null ? null : ByteUtils.toByteArray((File)FechamentoEmpacotamentoController.this.pacoteSelecionado);
                if (FechamentoEmpacotamentoController.this.planejamento == null) {
                    throw new EmpacotamentoException("Selecione a BRANCH");
                }
                if (!FechamentoEmpacotamentoController.this.planejamento.getSistemaEntity().isProcessoAutomatico()) {
                    RemoteFactory.getInstance().getProcessamento().validacaoFechamentoEmpacotamento(FechamentoEmpacotamentoController.this.planejamento.getId(), nomeArquivoOriginal, streamArquivo);
                    if (FechamentoEmpacotamentoController.this.planejamento.getSistemaEntity().getTecnologia().pacoteObrigatorio() && (nomeArquivoOriginal == null || streamArquivo == null)) {
                        throw new EmpacotamentoException("Selecione o pacote para publica\u00e7\u00e3o");
                    }
                }
                FechamentoEmpacotamentoController.this.startProcessLog();
                Platform.runLater(() -> FechamentoEmpacotamentoController.this.clearLog());
                FechamentoEmpacotamentoController.this.criaTaskAtualizacaoLabel();
                FechamentoEmpacotamentoController.this.getEmpacotamentoSvn().fechaEmpacotamento();
                List log = RemoteFactory.getInstance().getProcessamento().geraLogFechamentoEmpacotamento(FechamentoEmpacotamentoController.this.planejamento.getId());
                RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosFechamentoEmpacotamentoSemChamadaJenkins(FechamentoEmpacotamentoController.this.getConfiguracaoSingleton().getLogin(), FechamentoEmpacotamentoController.this.planejamento.getId(), nomeArquivoOriginal, streamArquivo);
                Platform.runLater(() -> FechamentoEmpacotamentoController.this.updateLogWebView(log.stream().collect(Collectors.joining("\n"))));
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    FechamentoEmpacotamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(FechamentoEmpacotamentoController.this.anchorPane, this.getException().getMessage());
                    FechamentoEmpacotamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    FechamentoEmpacotamentoController.this.endProcessLog();
                    String mensagem = "Processamento Conclu\u00eddo com Sucesso";
                    MensagemView.getInstancia().mostraSucesso(FechamentoEmpacotamentoController.this.anchorPane, mensagem);
                    FechamentoEmpacotamentoController.this.habilitaComponentes();
                    FechamentoEmpacotamentoController.this.atualizaCombo();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    public void selecionarPacoteAction(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Resource File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Pacote JAVA", new String[]{"*.war", "*.jar", "*.ear"}), new FileChooser.ExtensionFilter("Pacote Delphi", new String[]{"*.exe", "*.rar", "*.zip", "*.tar"}), new FileChooser.ExtensionFilter("Todos Arquivos", new String[]{"*.*"})});
        this.pacoteSelecionado = fileChooser.showOpenDialog((Window)this.getStage());
        if (this.pacoteSelecionado != null) {
            this.labelPacoteSelecionado.setText(this.pacoteSelecionado.getAbsolutePath());
        }
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getSelectionModel().clearSelection();
        this.comboBoxPlanejamento.getItems().clear();
        this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaFechamentoEmpacotamento(this.getConfiguracaoSingleton().getLogin()).stream().sorted(OrdenacaoLista.planejamentoComparator).collect(Collectors.toList()));
        this.comboBoxPlanejamento.setValue(null);
    }
}

