/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.svn.BibliotecaSvn;
import br.com.dsfnet.gpd.client.svn.EmpacotamentoSvn;
import br.com.dsfnet.gpd.client.svn.VersionamentoSvn;
import br.com.dsfnet.gpd.client.util.Utils;
import br.com.dsfnet.gpd.fx.fachada.DesenvolvimentoClientFachada;
import br.com.dsfnet.gpd.fx.util.ConfiguracaoSingleton;
import br.com.dsfnet.gpd.fx.util.ConsumoRestSingleton;
import br.com.dsfnet.gpd.fx.util.Estilo;
import br.com.dsfnet.gpd.fx.view.Aplicacao;
import br.com.dsfnet.gpd.fx.view.ImagemFx;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ResolutionMonitorUtils;
import br.com.jarch.util.SleepUtils;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.BuilderFactory;
import javafx.util.Duration;

public abstract class BaseFxml
implements Initializable {
    @Inject
    private FXMLLoader fxmlLoader;
    @FXML
    protected AnchorPane anchorPane;
    @FXML
    protected WebView textAreaLog;
    @FXML
    protected ScrollPane scrollLog;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private Stage stage;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    private boolean splashView;
    private boolean loginView;
    private boolean splashOrLoginView;
    private String ultimaMensagem = "";
    private boolean processingLog;
    private static final Map<String, Stage> mapaStage = new HashMap<String, Stage>();
    private static final Map<String, String> mapaChamador = new HashMap<String, String>();

    public void initialize(URL url, ResourceBundle rb) {
    }

    public Stage getStage() {
        return this.stage;
    }

    public void processarTeclasAtalho(AnchorPane anchorPane, KeyEvent event) {
        double scaleX = anchorPane.getScaleX();
        double scaleY = anchorPane.getScaleY();
        double posicaoX = anchorPane.getScaleX();
        double posicaoY = anchorPane.getScaleX();
        if (event.isControlDown() && event.getCode() == KeyCode.SUBTRACT) {
            anchorPane.setScaleX(scaleX -= 0.1);
            anchorPane.setScaleY(scaleY -= 0.1);
            anchorPane.setPrefSize(1024.0 * anchorPane.getScaleX(), 620.0 * anchorPane.getScaleY());
            this.stage.setWidth(anchorPane.getPrefWidth());
            this.stage.setHeight(anchorPane.getPrefHeight());
        } else if (event.isControlDown() && event.getCode() == KeyCode.ADD) {
            anchorPane.setScaleX(scaleX += 0.1);
            anchorPane.setScaleY(scaleY += 0.1);
            anchorPane.setPrefSize(1024.0 * anchorPane.getScaleX(), 620.0 * anchorPane.getScaleY());
            this.stage.setWidth(anchorPane.getPrefWidth());
            this.stage.setHeight(anchorPane.getPrefHeight());
        } else if (event.isControlDown() && event.getCode() == KeyCode.MULTIPLY) {
            this.stage.setOpacity(this.stage.getOpacity() + 0.01);
        } else if (event.isControlDown() && event.getCode() == KeyCode.DIVIDE) {
            this.stage.setOpacity(this.stage.getOpacity() - 0.01);
        } else if (event.isControlDown() && event.isShiftDown() && event.getCode() == KeyCode.UP) {
            anchorPane.setLayoutY(posicaoY -= 10.0);
        } else if (event.isControlDown() && event.isShiftDown() && event.getCode() == KeyCode.LEFT) {
            anchorPane.setLayoutX(posicaoX -= 10.0);
        } else if (event.isControlDown() && event.isShiftDown() && event.getCode() == KeyCode.DOWN) {
            anchorPane.setLayoutY(posicaoY += 10.0);
        } else if (event.isControlDown() && event.isShiftDown() && event.getCode() == KeyCode.RIGHT) {
            anchorPane.setLayoutX(posicaoX += 10.0);
        } else if (event.isControlDown() && event.getCode() == KeyCode.UP) {
            anchorPane.setLayoutY(posicaoY -= 1.0);
        } else if (event.isControlDown() && event.getCode() == KeyCode.LEFT) {
            anchorPane.setLayoutX(posicaoX -= 1.0);
        } else if (event.isControlDown() && event.getCode() == KeyCode.DOWN) {
            anchorPane.setLayoutY(posicaoY += 1.0);
        } else if (event.isControlDown() && event.getCode() == KeyCode.RIGHT) {
            anchorPane.setLayoutX(posicaoX += 1.0);
        }
    }

    public void mostraTela(BaseFxml baseFxmlChamando) {
        LogUtils.start();
        if (baseFxmlChamando != null) {
            mapaChamador.put(this.getClass().getSimpleName(), baseFxmlChamando.getClass().getSimpleName());
            this.stage = mapaStage.get(baseFxmlChamando.getClass().getSimpleName());
            this.stage.close();
        }
        String nomeStage = this.getClass().getSimpleName();
        this.stage = mapaStage.get(nomeStage);
        if (this.stage != null) {
            if (this.stage.getOnShown() != null) {
                this.stage.getOnShown().handle(null);
            }
            this.showStage();
            return;
        }
        LogUtils.generate((String)("### CRIANDO " + this.getClass().getSimpleName() + " ####"));
        String arquivoFxml = "/view/" + this.getClass().getSimpleName().replace("Controller", "View").replace(".", "/") + ".fxml";
        this.splashView = arquivoFxml.contains("SplashView");
        this.loginView = arquivoFxml.contains("LoginView");
        this.splashOrLoginView = this.splashView || this.loginView;
        this.configuraStage();
        try {
            InputStream fxml = this.getClass().getResourceAsStream(arquivoFxml);
            this.fxmlLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
            this.fxmlLoader.setLocation(this.getClass().getResource(arquivoFxml));
            Parent root = (Parent)this.fxmlLoader.load(fxml);
            Scene scene = new Scene(root);
            this.stage.setScene(scene);
            Initializable initializable = (Initializable)this.fxmlLoader.getController();
            scene.getStylesheets().add((Object)new Estilo().getAplicacao());
            root.setOnKeyReleased(ke -> {
                if (!AnchorPane.class.isAssignableFrom(root.getClass())) {
                    return;
                }
                ((BaseFxml)initializable).processarTeclasAtalho((AnchorPane)root, (KeyEvent)ke);
            });
            root.setOnMousePressed(event -> {
                this.mouseDragOffsetX = event.getSceneX();
                this.mouseDragOffsetY = event.getSceneY();
            });
            root.setOnMouseDragged(event -> {
                if (!event.isControlDown()) {
                    return;
                }
                this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
                this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
            });
            mapaStage.put(nomeStage, this.stage);
            if (arquivoFxml.contains("LoginView")) {
                this.stage.initModality(Modality.WINDOW_MODAL);
                this.stage.setAlwaysOnTop(true);
            }
            this.showStage();
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }

    private void showStage() {
        this.stage.show();
        this.stage.toFront();
    }

    private void configuraStage() {
        if (this.stage == null) {
            this.stage = this.splashOrLoginView ? new Stage(StageStyle.TRANSPARENT) : new Stage(StageStyle.DECORATED);
        }
        this.stage.getIcons().add((Object)ImagemFx.getInstancia().getImgIcone());
        this.stage.setTitle("GPD - Desktop - Vers\u00e3o 25.10.2.1237");
        this.stage.sizeToScene();
        if (this.splashView) {
            this.stage.setResizable(false);
        } else if (this.loginView) {
            this.stage.setResizable(false);
            this.stage.setWidth(1100.0);
            this.stage.setHeight(600.0);
        } else {
            float width = ResolutionMonitorUtils.width((float)1366.0f);
            float height = ResolutionMonitorUtils.width((float)768.0f);
            this.stage.setWidth((double)width);
            this.stage.setHeight((double)height);
            if (width == 1366.0f || height == 768.0f) {
                this.stage.setMaximized(true);
            }
        }
    }

    protected void encerrarMinimizar(MouseEvent mouseEvent) {
        Aplicacao.getInstancia().encerrar();
    }

    protected void criaTaskAtualizacaoLabel() {
        this.outputStream.reset();
        Task<Void> task = new Task<Void>(){

            protected Void call() {
                while (BaseFxml.this.isProcessingLog()) {
                    Platform.runLater(() -> {
                        String lastMessage = BaseFxml.this.getLastLogMessage();
                        if (!BaseFxml.this.ultimaMensagem.equals(lastMessage)) {
                            this.updateMessage(lastMessage.replace("\n", ""));
                            String logCompleto = BaseFxml.this.outputStream.toString();
                            logCompleto = Utils.ajustaLog((String)logCompleto);
                            BaseFxml.this.updateLogWebView(logCompleto);
                            if (BaseFxml.this.scrollLog != null) {
                                BaseFxml.this.scrollLog.setVvalue(1.0);
                            }
                            BaseFxml.this.ultimaMensagem = lastMessage;
                        }
                    });
                    SleepUtils.pauseMilliSeconds((int)50);
                }
                return null;
            }
        };
        Thread t = new Thread((Runnable)task);
        t.setDaemon(true);
        t.start();
    }

    protected void startProcessLog() {
        this.processingLog = true;
    }

    protected void endProcessLog() {
        this.processingLog = false;
    }

    protected boolean isProcessingLog() {
        return this.processingLog;
    }

    public String getLastLogMessage() {
        String log = this.outputStream.toString();
        while (log.endsWith("\n")) {
            log = log.substring(0, log.length() - 1);
        }
        int pos = log.lastIndexOf("\n");
        if (pos < 0) {
            return this.outputStream.toString();
        }
        return log.substring(pos);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected void clearLog() {
        this.setLog("");
    }

    protected void setLog(String ansiText) {
        this.updateLogWebView(ansiText);
    }

    protected void appendLog(String ansiText) {
        this.ultimaMensagem = this.ultimaMensagem + ansiText;
        this.updateLogWebView(this.ultimaMensagem);
    }

    protected void updateLogWebView(String ansiText) {
        if (this.textAreaLog == null) {
            return;
        }
        String html = this.buildHtmlFromAnsi(ansiText);
        WebEngine engine = this.textAreaLog.getEngine();
        Platform.runLater(() -> {
            engine.loadContent(html, "text/html");
            engine.getLoadWorker().stateProperty().addListener((obs, oldState, newState) -> {
                if (newState == Worker.State.SUCCEEDED) {
                    try {
                        engine.executeScript("(() => {  const el = document.getElementById('content');  if (!el) return;  el.scrollTop = el.scrollHeight;  window.scrollTo(0, document.body.scrollHeight);})();");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        });
    }

    private String buildHtmlFromAnsi(String input) {
        String currentColor;
        String s = input == null ? "" : input;
        String escaped = this.escapeHtml(s);
        String DEFAULT_COLOR = "#E5E5E5";
        StringBuilder out = new StringBuilder();
        StringBuilder segment = new StringBuilder();
        String segmentColor = currentColor = "#E5E5E5";
        int i = 0;
        while (i < escaped.length()) {
            char c = escaped.charAt(i);
            if (c == '\u001b' && i + 1 < escaped.length() && escaped.charAt(i + 1) == '[') {
                int mPos;
                if (segment.length() > 0) {
                    out.append("<span style=\"color:").append(segmentColor).append("\">").append((CharSequence)segment).append("</span>");
                    segment.setLength(0);
                }
                if ((mPos = escaped.indexOf(109, i + 2)) > 0) {
                    String seq = escaped.substring(i + 2, mPos);
                    segmentColor = currentColor = this.applySgrToColor(seq, currentColor);
                    i = mPos + 1;
                    continue;
                }
            }
            if (!"#E5E5E5".equals(currentColor) && c == '[') {
                int close;
                if (segment.length() > 0) {
                    out.append("<span style=\"color:").append(segmentColor).append("\">").append((CharSequence)segment).append("</span>");
                    segment.setLength(0);
                }
                if ((close = escaped.indexOf(93, i + 1)) > i + 1) {
                    boolean knownLevel;
                    String inner = escaped.substring(i + 1, close);
                    String innerNoAnsi = inner.replaceAll("\n", "").replaceAll("\\u001B\\[[0-9;]*m", "");
                    String innerPlain = innerNoAnsi.replaceAll("[^A-Za-z]", "").toUpperCase();
                    boolean bl = knownLevel = innerPlain.equals("INFO") || innerPlain.equals("WARN") || innerPlain.equals("ERROR") || innerPlain.equals("DEBUG") || innerPlain.equals("TRACE");
                    if (knownLevel) {
                        out.append("<span style=\"color:").append("#E5E5E5").append("\">[</span>");
                        if (!innerNoAnsi.isEmpty()) {
                            out.append("<span style=\"color:").append(currentColor).append("\">").append(innerNoAnsi).append("</span>");
                        }
                        out.append("<span style=\"color:").append("#E5E5E5").append("\">]</span>");
                        segmentColor = currentColor = "#E5E5E5";
                        i = close + 1;
                        continue;
                    }
                }
            }
            if (!segmentColor.equals(currentColor)) {
                if (segment.length() > 0) {
                    out.append("<span style=\"color:").append(segmentColor).append("\">").append((CharSequence)segment).append("</span>");
                    segment.setLength(0);
                }
                segmentColor = currentColor;
            }
            segment.append(c);
            ++i;
        }
        if (segment.length() > 0) {
            out.append("<span style=\"color:").append(segmentColor).append("\">").append((CharSequence)segment).append("</span>");
        }
        String header = "<!DOCTYPE html>\n<html lang=\"pt-br\">\n  <head>\n    <meta charset=\"UTF-8\">\n    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <style>\n      :root {\n        --term-bg: #0c0c0c;\n        --term-fg: #e5e5e5;\n        --term-subtle: #9aa0a6;\n        --term-green: #98c379;\n        --term-blue: #61afef;\n        --term-cyan: #56b6c2;\n        --term-yellow: #e5c07b;\n        --term-red: #e06c75;\n        --term-magenta: #c678dd;\n        --term-black: #000000;\n        --term-gray: #808080;\n      }\n      html, body {\n        height: 100%;\n        margin: 0;\n        padding: 0;\n        background: var(--term-bg);\n        color: var(--term-fg);\n        overflow: hidden;\n      }\n      #terminal {\n        box-sizing: border-box;\n        height: 100%;\n        width: 100%;\n        background: var(--term-bg);\n        font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, \"Liberation Mono\", \"Courier New\", monospace;\n        font-size: 13px;\n        line-height: 1.45;\n        color: var(--term-fg);\n        display: flex;\n        flex-direction: column;\n      }\n      .term-titlebar {\n        height: 26px;\n        display: flex;\n        align-items: center;\n        padding: 0 8px;\n        background: #151515;\n        border-bottom: 1px solid #222;\n        user-select: none;\n      }\n      .term-dots { display: inline-flex; gap: 6px; margin-right: 8px; }\n      .term-dot { width: 10px; height: 10px; border-radius: 50%; }\n      .dot-close { background: #ff5f56; }\n      .dot-min   { background: #ffbd2e; }\n      .dot-max   { background: #27c93f; }\n      .term-title { color: var(--term-subtle); font-size: 12px; }\n      #content {\n        flex: 1 1 auto;\n        overflow: auto;\n        padding: 12px 14px;\n        white-space: pre-wrap;\n        word-wrap: break-word;\n        scrollbar-color: #444 #111;\n        scrollbar-width: thin;\n      }\n      #content::-webkit-scrollbar { width: 10px; height: 10px; }\n      #content::-webkit-scrollbar-track { background: #0e0e0e; }\n      #content::-webkit-scrollbar-thumb {\n        background-color: #3a3a3a;\n        border-radius: 6px;\n        border: 2px solid #0e0e0e;\n      }\n      #content::-webkit-scrollbar-thumb:hover { background-color: #4a4a4a; }\n      ::selection { background: rgba(97, 175, 239, 0.35); }\n    </style>\n  </head>\n  <body>\n    <div id=\"terminal\">\n      <div class=\"term-titlebar\">\n        <div class=\"term-dots\">\n          <span class=\"term-dot dot-close\"></span>\n          <span class=\"term-dot dot-min\"></span>\n          <span class=\"term-dot dot-max\"></span>\n        </div>\n        <div class=\"term-title\">bash \u2014 log</div>\n      </div>\n      <pre id=\"content\">";
        String footer = "      </pre>\n    </div>\n    <script>\n      const content = document.getElementById('content');\n      if (content) content.scrollTop = content.scrollHeight;\n    </script>\n  </body>\n</html>\n";
        return header + String.valueOf(out) + footer;
    }

    private String escapeHtml(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String applySgrToColor(String seq, String current) {
        if (seq == null || seq.isBlank()) {
            return "#E5E5E5";
        }
        String[] parts = seq.split(";");
        String color = current;
        for (String p : parts) {
            try {
                int code = Integer.parseInt(p.trim());
                if (code == 0 || code == 39) {
                    color = "#E5E5E5";
                    continue;
                }
                if (code >= 30 && code <= 37) {
                    color = this.ansiBase(code - 30);
                    continue;
                }
                if (code < 90 || code > 97) continue;
                color = this.ansiBright(code - 90);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    private String ansiBase(int code) {
        return switch (code) {
            case 0 -> "#000000";
            case 1 -> "#E06C75";
            case 2 -> "#98C379";
            case 3 -> "#E5C07B";
            case 4 -> "#61AFEF";
            case 5 -> "#C678DD";
            case 6 -> "#56B6C2";
            case 7 -> "#E5E5E5";
            default -> "#E5E5E5";
        };
    }

    private String ansiBright(int code) {
        return switch (code) {
            case 0 -> "#808080";
            case 1 -> "#F28B8C";
            case 2 -> "#B4E07E";
            case 3 -> "#F2D08C";
            case 4 -> "#79C0FF";
            case 5 -> "#D2A6FF";
            case 6 -> "#7FEADD";
            case 7 -> "#FFFFFF";
            default -> "#E5E5E5";
        };
    }

    public ConsumoRestSingleton getConsumoRestSingleton() {
        return (ConsumoRestSingleton)CDI.current().select(ConsumoRestSingleton.class, new Annotation[0]).get();
    }

    public ConfiguracaoSingleton getConfiguracaoSingleton() {
        return (ConfiguracaoSingleton)CDI.current().select(ConfiguracaoSingleton.class, new Annotation[0]).get();
    }

    public DesenvolvimentoClientFachada getDesenvolvimentoClientFachada() {
        return (DesenvolvimentoClientFachada)CDI.current().select(DesenvolvimentoClientFachada.class, new Annotation[0]).get();
    }

    public EmpacotamentoSvn getEmpacotamentoSvn() {
        return (EmpacotamentoSvn)CDI.current().select(EmpacotamentoSvn.class, new Annotation[0]).get();
    }

    public VersionamentoSvn getVersionamentoSvn() {
        return (VersionamentoSvn)CDI.current().select(VersionamentoSvn.class, new Annotation[0]).get();
    }

    public BibliotecaSvn getBibliotecaSvn() {
        return (BibliotecaSvn)CDI.current().select(BibliotecaSvn.class, new Annotation[0]).get();
    }

    protected void aplicaEfeitoFadeOut(AnchorPane anchorPane, BaseFxml proximaTela) {
        anchorPane.getScene().setFill(null);
        FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)1.5), (Node)anchorPane);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        fadeOut.setCycleCount(1);
        fadeOut.setOnFinished(e -> proximaTela.mostraTela(this));
        fadeOut.play();
    }

    private static class AnsiParser {
        private static final String ESC = "\u001b[";

        private AnsiParser() {
        }

        static List<Text> parse(String input) {
            ArrayList<Text> parts = new ArrayList<Text>();
            Color current = null;
            int i = 0;
            StringBuilder buf = new StringBuilder();
            while (i < input.length()) {
                char c = input.charAt(i);
                if (c == '\u001b') {
                    int mPos;
                    if (buf.length() > 0) {
                        parts.add(AnsiParser.createText(buf.toString(), current));
                        buf.setLength(0);
                    }
                    if (i + 1 < input.length() && input.charAt(i + 1) == '[' && (mPos = input.indexOf(109, i + 2)) > 0) {
                        String seq = input.substring(i + 2, mPos);
                        current = AnsiParser.applySgr(seq, current);
                        i = mPos + 1;
                        continue;
                    }
                    buf.append(c);
                    ++i;
                    continue;
                }
                buf.append(c);
                ++i;
            }
            if (buf.length() > 0) {
                parts.add(AnsiParser.createText(buf.toString(), current));
            }
            return parts;
        }

        private static Text createText(String s, Color color) {
            Text t = new Text(s);
            if (color != null) {
                t.setFill((Paint)color);
            }
            return t;
        }

        private static Color applySgr(String seq, Color current) {
            String[] codes = seq.split(";");
            Color color = current;
            for (String codeStr : codes) {
                int code;
                try {
                    code = Integer.parseInt(codeStr.trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (code == 0) {
                    color = null;
                    continue;
                }
                if (code >= 30 && code <= 37) {
                    color = AnsiParser.mapAnsiBase(code);
                    continue;
                }
                if (code < 90 || code > 97) continue;
                color = AnsiParser.mapAnsiBright(code);
            }
            return color;
        }

        private static Color mapAnsiBase(int code) {
            return switch (code) {
                case 30 -> Color.web((String)"#000000");
                case 31 -> Color.web((String)"#cc0000");
                case 32 -> Color.web((String)"#4e9a06");
                case 33 -> Color.web((String)"#c4a000");
                case 34 -> Color.web((String)"#3465a4");
                case 35 -> Color.web((String)"#75507b");
                case 36 -> Color.web((String)"#06989a");
                case 37 -> Color.web((String)"#d3d7cf");
                default -> null;
            };
        }

        private static Color mapAnsiBright(int code) {
            return switch (code) {
                case 90 -> Color.web((String)"#555753");
                case 91 -> Color.web((String)"#ef2929");
                case 92 -> Color.web((String)"#8ae234");
                case 93 -> Color.web((String)"#fce94f");
                case 94 -> Color.web((String)"#729fcf");
                case 95 -> Color.web((String)"#ad7fa8");
                case 96 -> Color.web((String)"#34e2e2");
                case 97 -> Color.web((String)"#eeeeec");
                default -> null;
            };
        }
    }
}

