/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.util;

import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.AutenticacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoListaForm;
import br.com.dsfnet.gpd.client.form.RetornoForm;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.RequestHttpUtils;
import br.com.dsfnet.gpd.fx.util.ConfiguracaoSingleton;
import br.com.jarch.util.JsonUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class ConsumoRestSingleton {
    @Inject
    private ConfiguracaoSingleton configuracaoSingleton;
    private String SERVICO_REST;
    private String DESCRICAO_SOL;
    private String LISTA_SISTEMA;
    private String LISTA_SISTEMA_CLIENTE;
    private String LISTA_CLIENTE;
    private String VALIDA_SALVA_DESENVOLVIMENTO;
    private String VALIDA_FINALIZA_DESENVOLVIMENTO;
    private String ATUALIZA_BANCO_DADOS_DESCARTE_DESENVOLVIMENTO;
    private String ATUALIZA_BANCO_DADOS_SALVA_DESENVOLVIMENTO;
    private String ATUALIZA_BANCO_DADOS_FINALIZA_DESENVOLVIMENTO;
    private String APLICACAO_PESQUISA;
    private String CARREGA_ULTIMA_SOL_DESENVOLVIMENTO_PESQUISA;

    public void carregaVariaveis() {
        this.SERVICO_REST = this.configuracaoSingleton.getUrlGpd() + "/servico";
        this.DESCRICAO_SOL = this.SERVICO_REST + "/sol/descricao/%s";
        this.LISTA_SISTEMA = this.SERVICO_REST + "/sistemas/ativos";
        this.LISTA_SISTEMA_CLIENTE = this.SERVICO_REST + "/sistema/cliente/%s";
        this.LISTA_CLIENTE = this.SERVICO_REST + "/cliente/lista";
        this.VALIDA_SALVA_DESENVOLVIMENTO = this.SERVICO_REST + "/desenvolvimento/salva/valida/%s/%s";
        this.VALIDA_FINALIZA_DESENVOLVIMENTO = this.SERVICO_REST + "/desenvolvimento/finaliza/valida";
        this.ATUALIZA_BANCO_DADOS_DESCARTE_DESENVOLVIMENTO = this.SERVICO_REST + "/desenvolvimento/descarte/atualizabancodados/%s";
        this.ATUALIZA_BANCO_DADOS_SALVA_DESENVOLVIMENTO = this.SERVICO_REST + "/desenvolvimento/salva/atualizabancodados/%s";
        this.ATUALIZA_BANCO_DADOS_FINALIZA_DESENVOLVIMENTO = this.SERVICO_REST + "/desenvolvimento/finaliza/atualizabancodados/%s";
        this.APLICACAO_PESQUISA = this.SERVICO_REST + "/aplicacao/pesquisa/%s/%s/%s";
        this.CARREGA_ULTIMA_SOL_DESENVOLVIMENTO_PESQUISA = this.SERVICO_REST + "/desenvolvimento/pesquisa/ultimasol/%s/%s";
        LogUtils.generate((String)("###### WEBSERVICE: " + this.SERVICO_REST));
    }

    public void login(AutenticacaoForm autenticacaoForm) throws Exception {
        try {
            String jsonEnvio = JsonUtils.toJson((Object)autenticacaoForm);
            String jsonRetorno = (String)ClientBuilder.newClient().target(this.SERVICO_REST).path("login").request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(Entity.json((Object)jsonEnvio), String.class);
            RetornoForm retornoForm = (RetornoForm)JsonUtils.toObject(RetornoForm.class, (String)jsonRetorno);
            LogUtils.generate((String)retornoForm.getMensagem());
            if (retornoForm.getCodigo() != 0) {
                throw new Exception(retornoForm.getMensagem());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(ex.getMessage());
        }
    }

    public void validaInicioDesenvolvimento(String branch, String cliente, String sistema, TecnologiaType tecnologia, String login) throws Exception {
        try {
            if (StringUtils.isNullOrEmpty((String)branch)) {
                throw new Exception("N\u00famero da Branch\u00e9 Obrigat\u00f3rio");
            }
            if (StringUtils.isNullOrEmpty((String)cliente)) {
                throw new Exception("Cliente \u00e9 Obrigat\u00f3rio");
            }
            if (StringUtils.isNullOrEmpty((String)sistema)) {
                throw new Exception("Sistema \u00e9 Obrigat\u00f3rio");
            }
            if (tecnologia == null) {
                throw new Exception("Tecnologia \u00e9 Obrigat\u00f3rio");
            }
            String retorno = (String)ClientBuilder.newClient().target(this.SERVICO_REST).path("desenvolvimento").path("inicio").path("valida").queryParam("branch", new Object[]{branch}).queryParam("cliente", new Object[]{cliente}).queryParam("sistema", new Object[]{sistema}).queryParam("tecnologia", new Object[]{tecnologia}).queryParam("login", new Object[]{login}).request().accept(new String[]{"application/json"}).get(String.class);
            LogUtils.generate((String)retorno);
            RetornoForm retornoForm = (RetornoForm)JsonUtils.toObject(RetornoForm.class, (String)retorno);
            LogUtils.generate((String)retornoForm.getMensagem());
            if (retornoForm.getCodigo() != 0) {
                throw new Exception(retornoForm.getMensagem());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void validaDescarteDesenvolvimento(Long desenvolvimentoId, String login) throws Exception {
        try {
            if (desenvolvimentoId == null) {
                throw new Exception("N\u00famero da Branch\u00e9 Obrigat\u00f3rio");
            }
            if (login == null || login.isEmpty()) {
                throw new Exception("Tecnologia \u00e9 Obrigat\u00f3rio");
            }
            String retorno = (String)ClientBuilder.newClient().target(this.SERVICO_REST).path("desenvolvimento").path("descarte").path("valida").queryParam("desenvolvimentoId", new Object[]{desenvolvimentoId}).queryParam("login", new Object[]{login}).request().accept(new String[]{"application/json"}).get(String.class);
            LogUtils.generate((String)retorno);
            RetornoForm retornoForm = (RetornoForm)JsonUtils.toObject(RetornoForm.class, (String)retorno);
            LogUtils.generate((String)retornoForm.getMensagem());
            if (retornoForm.getCodigo() != 0) {
                throw new Exception(retornoForm.getMensagem());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void validaSalvaDesenvolvimento(Long desenvolvimentoId, String comentario) throws Exception {
        try {
            if (desenvolvimentoId == null) {
                throw new Exception("N\u00famero da Branch\u00e9 Obrigat\u00f3rio");
            }
            String retorno = RequestHttpUtils.postUrl((String)String.format(this.VALIDA_SALVA_DESENVOLVIMENTO, desenvolvimentoId, comentario));
            if (retorno == null) {
                throw new Exception("ERRO NO SERVI\u00c7O DE VALIDA\u00c7\u00c2O DO DESCARTE DO DESENVOLVIMENTO !");
            }
            if (!retorno.equals("OK")) {
                throw new Exception(retorno);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void validaFinalizaDesenvolvimento(DesenvolvimentoForm desenvolvimentoForm) throws Exception {
        try {
            if (desenvolvimentoForm == null) {
                throw new Exception("N\u00famero da Branch\u00e9 Obrigat\u00f3rio");
            }
            String retorno = (String)RequestHttpUtils.processaPost((URL)new URL(this.VALIDA_FINALIZA_DESENVOLVIMENTO), (Object)desenvolvimentoForm, String.class);
            if (retorno == null) {
                throw new Exception("ERRO NO SERVI\u00c7O DE VALIDA\u00c7\u00c2O DA FINALIZA\u00c7\u00c3O DO DESENVOLVIMENTO !");
            }
            if (!retorno.equals("OK")) {
                throw new Exception(retorno);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void atualizaBancoDadosInicioDesenvolvimento(String branch, String cliente, String sistema, TecnologiaType tecnologia, String login) throws Exception {
        try {
            if (branch.equals("1")) {
                return;
            }
            String retorno = (String)ClientBuilder.newClient().target(this.SERVICO_REST).path("desenvolvimento").path("inicio").path("atualizabancodados").queryParam("branch", new Object[]{branch}).queryParam("cliente", new Object[]{cliente}).queryParam("sistema", new Object[]{sistema}).queryParam("tecnologia", new Object[]{tecnologia}).queryParam("login", new Object[]{login}).request().accept(new String[]{"application/json"}).get(String.class);
            LogUtils.generate((String)retorno);
            RetornoForm retornoForm = (RetornoForm)JsonUtils.toObject(RetornoForm.class, (String)retorno);
            LogUtils.generate((String)retornoForm.getMensagem());
            if (retornoForm.getCodigo() != 0) {
                throw new Exception(retornoForm.getMensagem());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void atualizaBancoDadosDescarteDesenvolvimento(Long desenvolvimentoId) throws Exception {
        try {
            String retorno = RequestHttpUtils.postUrl((String)String.format(this.ATUALIZA_BANCO_DADOS_DESCARTE_DESENVOLVIMENTO, desenvolvimentoId));
            if (retorno == null) {
                throw new Exception("ERRO NO SERVI\u00c7O DE ATUALIZACAO BANCO DE DADOS DO DESCARTE DO DESENVOLVIMENTO !");
            }
            if (!retorno.equals("OK")) {
                throw new Exception(retorno);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void atualizaBancoDadosSalvaDesenvolvimento(Long desenvolvimentoId) throws Exception {
        try {
            String retorno = RequestHttpUtils.postUrl((String)String.format(this.ATUALIZA_BANCO_DADOS_SALVA_DESENVOLVIMENTO, desenvolvimentoId));
            if (retorno == null) {
                throw new Exception("ERRO NO SERVI\u00c7O DE ATUALIZACAO BANCO DE DADOS DO SALVAMENTO DO DESENVOLVIMENTO !");
            }
            if (!retorno.equals("OK")) {
                throw new Exception(retorno);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public void atualizaBancoDadosFinalizaDesenvolvimento(Long desenvolvimentoId) throws Exception {
        try {
            String retorno = RequestHttpUtils.postUrl((String)String.format(this.ATUALIZA_BANCO_DADOS_FINALIZA_DESENVOLVIMENTO, desenvolvimentoId));
            if (retorno == null) {
                throw new Exception("ERRO NO SERVI\u00c7O DE ATUALIZACAO BANCO DE DADOS DO SALVAMENTO DO DESENVOLVIMENTO !");
            }
            if (!retorno.equals("OK")) {
                throw new Exception(retorno);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public String[] sistemasAtivos() throws Exception {
        try {
            String sistema = RequestHttpUtils.postUrl((String)this.LISTA_SISTEMA);
            String[] sistemas = sistema.split(";");
            return sistemas;
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public String[] sistemasAtivos(String cliente) throws Exception {
        try {
            String sistema = RequestHttpUtils.postUrl((String)String.format(this.LISTA_SISTEMA_CLIENTE, cliente));
            String[] sistemas = sistema.split(";");
            return sistemas;
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public String[] listaCliente() throws Exception {
        try {
            String cliente = RequestHttpUtils.getUrl((String)this.LISTA_CLIENTE);
            List<String> todos = Arrays.stream(cliente.split(";")).filter(s -> !s.equals("TODOS")).collect(Collectors.toList());
            todos.add(0, "TODOS");
            return todos.toArray(new String[0]);
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public String descricaoSol(String numeroSol) throws IOException {
        return RequestHttpUtils.postUrl((String)String.format(this.DESCRICAO_SOL, numeroSol.toString()));
    }

    public AplicacaoForm pesquisaAplicacao(String cliente, String sistema, TecnologiaType tecnologia) throws Exception {
        try {
            if (cliente == null || cliente.equals("")) {
                throw new Exception("Cliente \u00e9 Obrigat\u00f3rio");
            }
            if (sistema == null || sistema.equals("")) {
                throw new Exception("Sistema \u00e9 Obrigat\u00f3rio");
            }
            if (tecnologia == null) {
                throw new Exception("Tecnologia \u00e9 Obrigat\u00f3rio");
            }
            AplicacaoForm aplicacaoForm = (AplicacaoForm)RequestHttpUtils.processaPost((URL)new URL(String.format(this.APLICACAO_PESQUISA, cliente, sistema, tecnologia)), null, AplicacaoForm.class);
            return aplicacaoForm;
        }
        catch (Exception ex) {
            throw new Exception("Aplica\u00e7\u00e3o n\u00e3o localizada para esse CLIENTE/SISTEMA/TECNOLOGIA");
        }
    }

    public DesenvolvimentoForm carregaUltimaSolDesenvolvimento(String login, String numeroSol) throws Exception {
        try {
            String retorno = RequestHttpUtils.postUrl((String)String.format(this.CARREGA_ULTIMA_SOL_DESENVOLVIMENTO_PESQUISA, login, numeroSol));
            if (retorno != null) {
                DesenvolvimentoForm form = (DesenvolvimentoForm)JsonUtils.toObject(DesenvolvimentoForm.class, (String)retorno);
                return form;
            }
            return null;
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    public List<DesenvolvimentoForm> listaSolsDesenvolvimento() throws Exception {
        try {
            AutenticacaoForm autenticacaoForm = new AutenticacaoForm();
            autenticacaoForm.setLogin(this.configuracaoSingleton.getLogin());
            autenticacaoForm.setSenha(this.configuracaoSingleton.getSenha());
            autenticacaoForm.setServidorSvn(this.configuracaoSingleton.getServidorSvn());
            String jsonEnvio = JsonUtils.toJson((Object)autenticacaoForm);
            String jsonRetorno = (String)ClientBuilder.newClient().target(this.SERVICO_REST).path("desenvolvimento").path("sols").request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(Entity.json((Object)jsonEnvio), String.class);
            DesenvolvimentoListaForm desenvolvimentoListaForm = (DesenvolvimentoListaForm)JsonUtils.toObject(DesenvolvimentoListaForm.class, (String)jsonRetorno);
            return desenvolvimentoListaForm.getLista();
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }

    private List<DesenvolvimentoForm> converteJsonParaListaObjeto(String json) {
        Gson gson = new Gson();
        List lista = (List)gson.fromJson(json, new TypeToken<List<DesenvolvimentoForm>>(this){}.getType());
        return lista;
    }
}

