/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.usuario;

import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.Md5Utils;
import jakarta.transaction.Transactional;
import java.util.Date;

@JArchDao
public class UsuarioDao
extends CrudDao<UsuarioEntity>
implements UsuarioRepository {
    @Override
    public UsuarioEntity pesquisaLogin(String login) {
        return (UsuarioEntity)this.searchOneBy("login", login);
    }

    @Override
    public void atualizaUltimoAcesso(Long id) {
        UsuarioEntity u = (UsuarioEntity)this.find(id);
        u.setUltimoAcesso(new Date());
    }

    @Override
    public void atualizaSenha(Long id, String novaSenha) {
        UsuarioEntity u = (UsuarioEntity)this.find(id);
        u.setSenha(Md5Utils.generate((String)novaSenha));
    }

    @Override
    public void atualizaSenha(String login, String novaSenha) {
        UsuarioEntity u = this.pesquisaLogin(login);
        u.setSenha(Md5Utils.generate((String)novaSenha));
    }

    @Override
    public void incluiSeNaoExistir(String login) {
        this.incluiSeNaoExistir(login, null);
    }

    @Override
    @Transactional
    public void incluiSeNaoExistir(String login, String senha) {
        if (this.pesquisaLogin(login.toLowerCase()) != null) {
            return;
        }
        UsuarioEntity usuarioEntity = new UsuarioEntity();
        usuarioEntity.setLogin(login);
        usuarioEntity.setNome(login);
        if (senha != null) {
            usuarioEntity.setSenha(Md5Utils.generate((String)senha));
        }
        this.getEntityManager().persist((Object)usuarioEntity);
    }
}

