/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.planejamento;

import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="PLANEJAMENTO_SOL")
@SequenceGenerator(name="PlanejamentoSolIdSequence", sequenceName="SEQ_PLANEJAMENTOSOL_ID", allocationSize=1)
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
public class PlanejamentoSolEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PlanejamentoSolIdSequence")
    private Long id;
    @Column(name="branch")
    private String numeroSol;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date data;
    @ManyToOne
    @JoinColumn(name="planejamento_id", referencedColumnName="id")
    private PlanejamentoEntity planejamentoEntity;
    @OneToOne
    @JoinColumn(name="usuario_id")
    private UsuarioEntity usuarioEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumeroSol() {
        return this.numeroSol;
    }

    public void setNumeroSol(String numeroSol) {
        this.numeroSol = numeroSol;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public PlanejamentoEntity getPlanejamentoEntity() {
        return this.planejamentoEntity;
    }

    public void setPlanejamentoEntity(PlanejamentoEntity planejamentoEntity) {
        this.planejamentoEntity = planejamentoEntity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.numeroSol == null ? 0 : this.numeroSol.hashCode());
        result = 31 * result + (this.planejamentoEntity == null ? 0 : this.planejamentoEntity.hashCode());
        result = 31 * result + (this.usuarioEntity == null ? 0 : this.usuarioEntity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlanejamentoSolEntity other = (PlanejamentoSolEntity)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.numeroSol == null ? other.numeroSol != null : !this.numeroSol.equals(other.numeroSol)) {
            return false;
        }
        if (this.planejamentoEntity == null ? other.planejamentoEntity != null : !this.planejamentoEntity.equals(other.planejamentoEntity)) {
            return false;
        }
        return !(this.usuarioEntity == null ? other.usuarioEntity != null : !this.usuarioEntity.equals((Object)other.usuarioEntity));
    }

    public int compareTo(PlanejamentoSolEntity outro) {
        if (this.getPlanejamentoEntity().getSistemaEntity().getCliente().compareTo(outro.getPlanejamentoEntity().getSistemaEntity().getCliente()) != 0) {
            return this.getPlanejamentoEntity().getSistemaEntity().getCliente().compareTo(outro.getPlanejamentoEntity().getSistemaEntity().getCliente());
        }
        if (this.getPlanejamentoEntity().getSistemaEntity().getSistema().compareTo(outro.getPlanejamentoEntity().getSistemaEntity().getSistema()) != 0) {
            return this.getPlanejamentoEntity().getSistemaEntity().getSistema().compareTo(outro.getPlanejamentoEntity().getSistemaEntity().getSistema());
        }
        if (this.getPlanejamentoEntity().getSistemaEntity().getTecnologia().compareTo(outro.getPlanejamentoEntity().getSistemaEntity().getTecnologia()) != 0) {
            return this.getPlanejamentoEntity().getSistemaEntity().getTecnologia().compareTo(outro.getPlanejamentoEntity().getSistemaEntity().getTecnologia());
        }
        if (this.getPlanejamentoEntity().getVersao().compareTo(outro.getPlanejamentoEntity().getVersao()) != 0) {
            return this.getPlanejamentoEntity().getVersao().compareTo(outro.getPlanejamentoEntity().getVersao());
        }
        if (this.getNumeroSol() != null && outro.getNumeroSol() != null) {
            return this.getNumeroSol().compareTo(outro.getNumeroSol());
        }
        return this.getId().compareTo(outro.getId());
    }

    public String toString() {
        Object print = "";
        if (this.planejamentoEntity != null) {
            print = (String)print + "Cliente: " + this.planejamentoEntity.getSistemaEntity().getCliente();
            print = (String)print + " Produto: " + this.planejamentoEntity.getSistemaEntity().getSistema();
            print = (String)print + " Tecnologia: " + String.valueOf((Object)this.planejamentoEntity.getSistemaEntity().getTecnologia());
            print = (String)print + " Vers\u00e3o: " + this.planejamentoEntity.getVersao();
        }
        print = (String)print + " SOL: " + this.numeroSol;
        return print;
    }
}

