/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.pacote;

import br.com.dsfnet.gpd.client.exception.PacoteException;
import br.com.dsfnet.gpd.client.pacote.PacoteEntity;
import br.com.dsfnet.gpd.client.pacote.PacoteRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import jakarta.persistence.Query;
import jakarta.transaction.Transactional;
import java.util.Date;

@JArchDao
public class PacoteDao
extends CrudDao<PacoteEntity>
implements PacoteRepository {
    @Override
    public PacoteEntity pesquisarVersao(String sistema, TecnologiaType tecnologia, String cliente, String versao) throws PacoteException {
        try {
            Query query = this.getEntityManager().createQuery("SELECT p  FROM PacoteEntity p WHERE p.versao = :versao AND       p.sistemaEntity.sistema = :sistema AND       p.sistemaEntity.tecnologia = :tecnologia AND       p.sistemaEntity.cliente = :cliente AND       NOT EXISTS( SELECT x                   FROM PacoteEntity x                   WHERE x.sistemaEntity.id = p.sistemaEntity.id AND                         x.versao = p.versao AND  \t\t\t\t\t\t x.id > p.id)");
            query.setParameter("versao", (Object)versao);
            query.setParameter("sistema", (Object)sistema);
            query.setParameter("tecnologia", (Object)tecnologia);
            query.setParameter("cliente", (Object)cliente);
            return (PacoteEntity)query.getSingleResult();
        }
        catch (Exception ex) {
            throw new PacoteException("Pacote n\u00e3o localizado " + versao);
        }
    }

    @Override
    @Transactional
    public void gravar(String sistema, TecnologiaType tecnologia, String cliente, String versao, byte[] arquivo, String nomeArquivo) throws PacoteException {
        try {
            PacoteEntity pacoteEntity;
            SistemaEntity sistemaEntity = SistemaRepository.getInstance().pesquisar(cliente, sistema, tecnologia);
            boolean incluir = false;
            try {
                pacoteEntity = this.pesquisarVersao(sistema, tecnologia, cliente, versao);
            }
            catch (Exception ex) {
                incluir = true;
                pacoteEntity = new PacoteEntity();
            }
            pacoteEntity.setSistemaEntity(sistemaEntity);
            pacoteEntity.setVersao(versao);
            pacoteEntity.setArquivo(arquivo);
            pacoteEntity.setNomeArquivo(nomeArquivo);
            pacoteEntity.setData(new Date());
            if (incluir) {
                this.getEntityManager().persist((Object)pacoteEntity);
            } else {
                this.getEntityManager().merge((Object)pacoteEntity);
            }
        }
        catch (Exception ex) {
            throw new PacoteException(ex.getMessage());
        }
    }
}

