/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.homologacao;

import br.com.dsfnet.gpd.client.homologacao.HomologacaoEntity;
import br.com.dsfnet.gpd.client.homologacao.HomologacaoRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class HomologacaoDao
extends CrudDao<HomologacaoEntity>
implements HomologacaoRepository {
    @Override
    @Transactional
    public long bloquear(String cliente, String produto, TecnologiaType tecnologia, String numeroSol, String login) {
        SistemaEntity sistemaEntity = SistemaRepository.getInstance().pesquisar(cliente, produto, tecnologia);
        UsuarioEntity usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(login);
        HomologacaoEntity homologacao = new HomologacaoEntity();
        homologacao.setNumeroSol(numeroSol);
        homologacao.setSistemaEntity(sistemaEntity);
        homologacao.setStatus(StatusType.BLOQUEADO);
        homologacao.setInicio(new Date());
        homologacao.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().persist((Object)homologacao);
        return homologacao.getId();
    }

    @Override
    public void liberar(Long id) {
        HomologacaoEntity homologacao = (HomologacaoEntity)this.find(id);
        homologacao.setStatus(StatusType.LIBERADO);
        homologacao.setFim(new Date());
    }

    @Override
    public void descartar(Long id) {
        HomologacaoEntity homologacao = (HomologacaoEntity)this.find(id);
        homologacao.setStatus(StatusType.DESCARTADO);
        homologacao.setFim(new Date());
    }

    @Override
    public List<HomologacaoEntity> listaBloqueado(String sistema, String projetoSvn) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM HomologacaoEntity ad WHERE ad.sistemaEntity.sistema = :sistema AND \t   ad.sistemaEntity.projetoSvn = :projetoSvn AND       ad.fim IS NULL");
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("projetoSvn", (Object)projetoSvn);
        return CollectionUtils.transform(HomologacaoEntity.class, (Collection)query.getResultList());
    }

    @Override
    public List<HomologacaoEntity> listaSolServidor() {
        Query query = this.getEntityManager().createQuery("SELECT h FROM HomologacaoEntity h JOIN FETCH h.sistemaEntity apl JOIN FETCH h.usuarioEntity usu WHERE h.numeroSol IS NOT NULL AND       (h.fim IS NULL OR NOT EXISTS( SELECT 0                   \t\t\t\t\t FROM HomologacaoEntity x                   \t\t\t\t\t WHERE x.sistemaEntity.id = h.sistemaEntity.id AND                         \t\t\t\t   x.id > h.id)) ORDER BY h.inicio DESC");
        List lista = CollectionUtils.transform(HomologacaoEntity.class, (Collection)query.getResultList());
        return lista;
    }

    @Override
    public List<String> listaSolBloqueado(String login) {
        Query query = this.getEntityManager().createQuery("SELECT h.numeroSol FROM HomologacaoEntity h WHERE h.fim IS NULL AND       h.usuarioEntity.login = :login ORDER BY h.numeroSol");
        query.setParameter("login", (Object)login);
        return CollectionUtils.transform(String.class, (Collection)query.getResultList());
    }

    @Override
    public Set<HomologacaoEntity> listaBloqueado(String login) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(HomologacaoEntity.class);
        Root root = criteria.from(HomologacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereLogin = builder.equal((Expression)root.join("usuarioEntity").get("login"), (Object)login);
        criteria.where(new Predicate[]{whereFim, whereLogin});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<HomologacaoEntity> listaRetorno = new TreeSet<HomologacaoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public boolean bloqueado(Long aplicacaoId, String branch) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(HomologacaoEntity.class);
        Root root = criteria.from(HomologacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereSol = builder.equal((Expression)root.get("numeroSol"), (Object)branch);
        criteria.where(new Predicate[]{whereAplicacao, whereSol, whereFim});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        return lista.size() > 0;
    }

    @Override
    public List<HomologacaoEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(HomologacaoEntity.class);
        Root root = criteria.from(HomologacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }
}

