/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.empacotamento;

import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="EMPACOTAMENTO")
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false, generateDataDetail=false, generateSearch=false)
@SequenceGenerator(name="EmpacotamentoIdSequence", sequenceName="SEQ_EMPACOTAMENTO_ID", allocationSize=1)
public class EmpacotamentoEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EmpacotamentoIdSequence")
    private Long id;
    private String versao;
    @Column(name="branch")
    private String numeroSol;
    @Column(columnDefinition="char(1)", length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    private boolean aceite;
    @Column(columnDefinition="char(1)", length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    private boolean commit;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date inicio;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date fim;
    @OneToOne
    @JoinColumn(name="aplicacao_id", nullable=false)
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="usuario_id", nullable=false)
    private UsuarioEntity usuarioEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getInicio() {
        return this.inicio;
    }

    public void setInicio(Date inicio) {
        this.inicio = inicio;
    }

    public Date getFim() {
        return this.fim;
    }

    public void setFim(Date fim) {
        this.fim = fim;
    }

    public boolean getAceite() {
        return this.aceite;
    }

    public void setAceite(boolean aceite) {
        this.aceite = aceite;
    }

    public boolean getCommit() {
        return this.commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public String getNumeroSol() {
        return this.numeroSol;
    }

    public void setNumeroSol(String numeroSol) {
        this.numeroSol = numeroSol;
    }

    public int compareTo(EmpacotamentoEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getVersao() != null && outro.getVersao() != null && this.getVersao().compareTo(outro.getVersao()) != 0) {
            return this.getVersao().compareTo(outro.getVersao());
        }
        if (this.getNumeroSol() != null && outro.getNumeroSol() != null) {
            return this.getNumeroSol().compareTo(outro.getNumeroSol());
        }
        return this.getId().compareTo(outro.getId());
    }

    public String toString() {
        Object print = "";
        if (this.sistemaEntity != null) {
            print = (String)print + "Cliente: " + this.sistemaEntity.getCliente();
            print = (String)print + " Produto: " + this.sistemaEntity.getSistema();
            print = (String)print + " Tecnologia: " + String.valueOf((Object)this.sistemaEntity.getTecnologia());
        }
        print = (String)print + " Vers\u00e3o: " + this.versao;
        if (!this.commit) {
            print = (String)print + " SOL: " + this.numeroSol;
        }
        return print;
    }
}

