/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.desenvolvimento;

import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="DESENVOLVIMENTO")
@SequenceGenerator(name="DesenvolvimentoIdSequence", sequenceName="SEQ_DESENVOLVIMENTO_ID", allocationSize=1)
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
public class DesenvolvimentoEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DesenvolvimentoIdSequence")
    private Long id;
    @Column(name="branch")
    private String numeroSol;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date inicio;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date fim;
    @Enumerated(value=EnumType.STRING)
    private StatusType status;
    @OneToOne
    @JoinColumn(name="aplicacao_id", nullable=false)
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="usuario_id", nullable=false)
    private UsuarioEntity usuarioEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumeroSol() {
        return this.numeroSol;
    }

    public void setNumeroSol(String numeroSol) {
        this.numeroSol = numeroSol;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getInicio() {
        return this.inicio;
    }

    public void setInicio(Date inicio) {
        this.inicio = inicio;
    }

    public Date getFim() {
        return this.fim;
    }

    public void setFim(Date fim) {
        this.fim = fim;
    }

    public StatusType getStatus() {
        return this.status;
    }

    public void setStatus(StatusType status) {
        this.status = status;
    }

    public int compareTo(DesenvolvimentoEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getNumeroSol() != null && outro.getNumeroSol() != null) {
            return this.getNumeroSol().compareTo(outro.getNumeroSol());
        }
        return this.getId().compareTo(outro.getId());
    }

    public String toString() {
        Object print = "";
        if (this.sistemaEntity != null) {
            print = (String)print + "Cliente: " + this.sistemaEntity.getCliente();
            print = (String)print + " Produto: " + this.sistemaEntity.getSistema();
            print = (String)print + " Tecnologia: " + String.valueOf((Object)this.sistemaEntity.getTecnologia());
        }
        print = (String)print + " SOL: " + this.numeroSol;
        return print;
    }
}

