/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.aceite;

import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="ACEITE")
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
public class AceiteEntity
extends CrudEntity
implements Serializable {
    @SequenceGenerator(name="AceiteIdSequence", sequenceName="SEQ_ACEITE_ID", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AceiteIdSequence")
    private Long id;
    private String versao;
    @Column(name="branch")
    private String numeroSol;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date inicio;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date fim;
    @Enumerated(value=EnumType.STRING)
    private StatusType status;
    @Enumerated(value=EnumType.STRING)
    private AmbienteType ambiente;
    @OneToOne
    @JoinColumn(name="aplicacao_id")
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="usuario_id")
    private UsuarioEntity usuarioEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public String getNumeroSol() {
        return this.numeroSol;
    }

    public void setNumeroSol(String numeroSol) {
        this.numeroSol = numeroSol;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getInicio() {
        return this.inicio;
    }

    public void setInicio(Date inicio) {
        this.inicio = inicio;
    }

    public Date getFim() {
        return this.fim;
    }

    public void setFim(Date fim) {
        this.fim = fim;
    }

    public StatusType getStatus() {
        return this.status;
    }

    public void setStatus(StatusType status) {
        this.status = status;
    }

    public AmbienteType getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(AmbienteType ambiente) {
        this.ambiente = ambiente;
    }

    public int compareTo(AceiteEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getVersao() != null && outro.getVersao() != null) {
            return this.getVersao().compareTo(outro.getVersao());
        }
        if (this.getNumeroSol() != null && outro.getNumeroSol() != null) {
            return this.getNumeroSol().compareTo(outro.getNumeroSol());
        }
        return this.getId().compareTo(outro.getId());
    }
}

