/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzPk;
import com.aspose.words.internal.zzVSW;
import com.aspose.words.internal.zzXYc;
import com.aspose.words.internal.zzXgH;
import com.aspose.words.internal.zzXjo;
import com.aspose.words.internal.zzYMf;
import com.aspose.words.internal.zzZ56;
import com.aspose.words.internal.zzZQv;
import com.aspose.words.internal.zzZd6;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.internal.zzi7;
import com.aspose.words.internal.zzuk;
import com.aspose.words.zz1n;
import com.aspose.words.zzVXi;
import com.aspose.words.zzW2X;
import com.aspose.words.zzW7Z;
import com.aspose.words.zzWhG;
import com.aspose.words.zzWwe;
import com.aspose.words.zzY1G;
import com.aspose.words.zzYxW;
import com.aspose.words.zzZ97;
import com.aspose.words.zzZKu;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXDP(zzZQv zzZQv2, zzZQv zzZQv3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZwy.zzYMQ((Object)zzZQv2, "srcStream");
        zzZwy.zzYMQ((Object)zzZQv3, "dstStream");
        zzZwy.zzYMQ((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYMQ(zzZQv2, zzZQv3, certificateHolder, signOptions);
        zzZQv3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXDP(zzZQv.zzYMQ(srcStream), (zzZQv)zzZQv.zzYeh(dstStream), certHolder, signOptions);
    }

    private static void zzYMQ(zzZQv zzZQv2, zzZQv zzZQv3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYeh(digitalSignature);
        }
        if (zzZ97.zzWgQ(zzZQv2)) {
            DigitalSignatureUtil.zzXDP(zzZQv2, zzZQv3, digitalSignature, true);
            return;
        }
        zzZ97 zzZ972 = new zzZ97();
        zzZQv zzZQv4 = zzZQv2;
        zzZ97 zzZ973 = zzZ972;
        FileFormatInfo fileFormatInfo = zzZ972.zzYMQ(zzZQv4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzPk zzPk2 = new zzPk(zzZQv2);
                int n = fileFormatInfo.zzYko() == 1 ? 1 : 2;
                zzW2X.zzXDP(zzPk2, digitalSignature, n);
                zzZQv3.zzXxJ(0L);
                zzPk2.zzZNf(zzZQv3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXDP(fileFormatInfo.zzX00(), zzZQv3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXDP(zzZQv2, zzZQv3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXDP(zzZQv2, zzZQv3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZwy.zzYeh(srcFileName, "srcFileName");
        zzZwy.zzYeh(dstFileName, "dstFileName");
        try (zzi7 zzi72 = zzZwy.zzYMQ(srcFileName, 3, 1);){
            try (zzi7 zzi73 = zzZwy.zzYMQ(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXDP((zzZQv)zzi72, (zzZQv)zzi73, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZ56 zzZ562 = zzZQv.zzYeh(dstStream);
        zzZQv zzZQv2 = zzZQv.zzYMQ(srcStream);
        DigitalSignatureUtil.zzXDP(zzZQv2, (zzZQv)zzZ562, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzi7 zzi72 = zzZwy.zzYMQ(srcFileName, 3, 1);){
            try (zzi7 zzi73 = zzZwy.zzYMQ(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWOR(zzi72, zzi73);
            }
            return;
        }
    }

    private static void zzWOR(zzZQv zzZQv2, zzZQv zzZQv3) throws Exception {
        zzZ97 zzZ972 = new zzZ97();
        zzZQv zzZQv4 = zzZQv2;
        zzZ97 zzZ973 = zzZ972;
        FileFormatInfo fileFormatInfo = zzZ972.zzYMQ(zzZQv4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzPk zzPk2 = new zzPk(zzZQv2);
                zzPk2.zzZJz().zzW8N("_xmlsignatures");
                zzPk2.zzZJz().zzW8N("_signatures");
                zzZQv3.zzWt4(0L);
                zzPk2.zzZNf(zzZQv3);
                zzZQv zzZQv5 = zzZQv3;
                zzZQv5.zzXxJ(zzZQv5.zz0d());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYMf zzYMf2 = new zzYMf(zzZQv2);
                zzXYc zzXYc2 = zzYMf2.zzXDP(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXYc2 != null) {
                    for (zzXjo zzXjo2 : zzXYc2.zzZIw()) {
                        String string = zzXYc2.zzXDP(zzXjo2);
                        zzYMf2.zzX0G().remove(string);
                    }
                    zzYMf2.zzX0G().remove(zzXYc2.getName());
                    zzXjo zzXjo3 = zzYMf2.zzZIw().zzX5e("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYMf2.zzZIw().remove(zzXjo3.getId());
                    zzYMf2.zzZBn();
                }
                zzZQv3.zzWt4(0L);
                zzYMf2.zzZNf(zzZQv3);
                zzZQv zzZQv6 = zzZQv3;
                zzZQv6.zzXxJ(zzZQv6.zz0d());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWOR(zzZQv.zzYMQ(srcStream), zzZQv.zzYeh(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzi7 zzi72 = zzZwy.zzYMQ(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYF5(zzi72);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYF5(zzZQv zzZQv2) throws Exception {
        if (zzZ97.zzWgQ(zzZQv2)) {
            return DigitalSignatureUtil.zzYmv(zzZQv2);
        }
        zzZ97 zzZ972 = new zzZ97();
        zzZQv zzZQv3 = zzZQv2;
        zzZ97 zzZ973 = zzZ972;
        FileFormatInfo fileFormatInfo = zzZ972.zzYMQ(zzZQv3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZQv2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYF5(zzZQv.zzYMQ(stream));
    }

    static zzuk zzXDP(zzPk zzPk2, String string) throws Exception {
        zzVXi zzVXi2 = new zzVXi(zzPk2);
        if (zzVXi2.zzYOE()) {
            zzuk zzuk2 = zzVXi2.zzW9g(string);
            return zzuk2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXy5(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXgH.zzYMQ("Unexpected digest algorithm: {0}.", n));
    }

    static String zzXHd(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzXy5(n);
    }

    private static void zzXDP(zzZQv zzZQv2, zzZQv zzZQv3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYMf zzYMf2 = new zzYMf(zzZQv2);
        zzY1G zzY1G2 = bl ? new zzWhG(zzYMf2) : new zzWwe(zzYMf2);
        zzY1G2.zzYMQ(digitalSignature);
        zzZQv3.zzXxJ(0L);
        zzYMf2.zzZNf(zzZQv3);
    }

    private static void zzXDP(zzZQv zzZQv2, zzZQv zzZQv3, DigitalSignature digitalSignature) throws Exception {
        zzZKu zzZKu2 = new zzZKu(zzZQv2);
        zz1n zz1n2 = new zz1n(zzZKu2);
        zz1n2.zzYMQ(digitalSignature);
        zzZQv3.zzXxJ(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZQv zzZQv4 = zzZQv3;
        zzZKu zzZKu3 = zzZKu2;
        zzZKu3.zzXDP(zzZQv4, string, null);
    }

    private static void zzXDP(zzPk zzPk2, zzZQv zzZQv2, DigitalSignature digitalSignature, String string) throws Exception {
        zzuk zzuk2 = DigitalSignatureUtil.zzXDP(zzPk2, string);
        zzuk zzuk3 = new zzuk();
        DigitalSignatureUtil.zzXDP((zzZQv)zzuk2, (zzZQv)zzuk3, digitalSignature, false);
        zzPk zzPk3 = zzVXi.zzYeh(zzuk3, string);
        zzPk3.zzZNf(zzZQv2);
    }

    private static DigitalSignatureCollection zzYmv(zzZQv zzZQv2) throws Exception {
        zzZQv2.zzWt4(0L);
        zzYMf zzYMf2 = new zzYMf(zzZQv2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXYc zzXYc2 = zzYMf2.zzXDP(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXYc2 != null) {
            for (zzXjo zzXjo2 : zzXYc2.zzZIw()) {
                String string = zzXYc2.zzXDP(zzXjo2);
                zzXYc zzXYc3 = zzYMf2.zzZrH(string);
                zzXYc zzXYc4 = zzYMf2.zzXDP(zzXYc3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZd6 zzZd62 = zzVSW.zzWAj(zzXYc4.zzWA6().zzWjH());
                zzYxW.zzXDP(zzXYc3.zzXCB(), zzZd62, new zzW7Z(zzYMf2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

