/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public abstract class AutoTextExpressionUtils {
    private static final String PAGE_NUMBER_VAR = "$V{PAGE_NUMBER}";

    public static JRDesignExpression getPageNumberExpression(String before, String after, boolean useI18n) {
        return AutoTextExpressionUtils.getPageNumberExpression(before, after, 0, useI18n);
    }

    public static JRDesignExpression getPageNumberExpression(String before, String after, int pageOffset, boolean useI18n) {
        String text;
        JRDesignExpression expression = new JRDesignExpression();
        if (useI18n) {
            before = !AutoTextExpressionUtils.emptyString(before) ? "$R{" + before + "}" : "\"" + before + "\"";
            after = !AutoTextExpressionUtils.emptyString(after) ? "$R{" + after + "}" : "\"" + after + "\"";
            text = before + "+\" \" + ((" + PAGE_NUMBER_VAR + ").intValue() + " + pageOffset + ")+\" \" + " + after;
        } else {
            before = AutoTextExpressionUtils.emptyString(before) ? "\"\"" : "\"" + before + "\"";
            after = AutoTextExpressionUtils.emptyString(after) ? "\"\"" : "\"" + after + "\"";
            text = before + "+\" \" + ((" + PAGE_NUMBER_VAR + ").intValue() +" + pageOffset + ")+\" \" + " + after;
        }
        expression.setText(text);
        expression.setValueClass(String.class);
        return expression;
    }

    private static boolean emptyString(String str) {
        return str == null || "".equals(str.trim());
    }

    public static JRDesignExpression getDateExpression(String before, String after, Locale locale, byte pattern) {
        before = !AutoTextExpressionUtils.emptyString(before) ? "$R{" + before + "}" : "\"" + before + "\"";
        after = !AutoTextExpressionUtils.emptyString(after) ? "$R{" + after + "}" : "\"" + after + "\"";
        DateFormat dateFormatter = 1 == pattern ? DateFormat.getDateInstance(2, locale) : (2 == pattern ? DateFormat.getTimeInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale));
        JRDesignExpression expression = new JRDesignExpression();
        String text = before + "+\" \" + \"" + dateFormatter.format(new Date()) + "\" +\" \" + " + after;
        expression.setText(text);
        expression.setValueClass(String.class);
        return expression;
    }
}

