/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.poi.util.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public final class XSSFDump {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Dumping " + args[i]);
            ZipFile zip = new ZipFile(args[i]);
            try {
                XSSFDump.dump(zip);
                continue;
            }
            finally {
                zip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(ZipFile zip) throws Exception {
        String zipname = zip.getName();
        int sep = zipname.lastIndexOf(46);
        File root = new File(zipname.substring(0, sep));
        root.mkdir();
        System.out.println("Dupming to directory " + root);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String name = entry.getName();
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                File bs = new File(root, name.substring(0, idx));
                bs.mkdirs();
            }
            File f = new File(root, entry.getName());
            FileOutputStream out = new FileOutputStream(f);
            try {
                if (entry.getName().endsWith(".xml") || entry.getName().endsWith(".vml") || entry.getName().endsWith(".rels")) {
                    try {
                        XmlObject xml = XmlObject.Factory.parse((InputStream)zip.getInputStream(entry));
                        XmlOptions options = new XmlOptions();
                        options.setSavePrettyPrint();
                        xml.save((OutputStream)out, options);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse " + entry.getName() + ", dumping raw content");
                        IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
                    }
                    continue;
                }
                IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
    }
}

