/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.C;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConstructorUtils;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> Boolean evaluateRendered(Predicate<T> evaluate, T object) {
        if (evaluate == null) {
            return true;
        }
        return evaluate.test(object);
    }

    public static <T> Boolean evaluateDisabled(Predicate<T> evaluate, T object) {
        if (evaluate == null) {
            return false;
        }
        return evaluate.test(object);
    }

    public static <T> T getValueByField(Object instance, Field field, Class<T> clazzValueReturn) {
        return (T)ReflectionUtils.getValueByName(instance, field.getName());
    }

    public static Object getValueByField(Object instance, Field field) {
        return ReflectionUtils.getValueByName(instance, field.getName(), field.getType());
    }

    public static <T> T getValueByName(Object instance, String fieldName, Class<T> clazzValueReturn) {
        return (T)ReflectionUtils.getValueByName(instance, fieldName);
    }

    public static Object getValueByName(Object instance, String fieldName) {
        Field field;
        Method getterMethod;
        String attributeName = fieldName;
        boolean isMultLevelProperty = attributeName.contains(".");
        String[] propertyTokens = attributeName.split("\\.");
        if (isMultLevelProperty) {
            String rootProperty = propertyTokens[0];
            attributeName = ReflectionUtils.removeStart(attributeName, rootProperty + ".");
            getterMethod = ReflectionUtils.getGetter(instance.getClass(), rootProperty, true);
            field = ReflectionUtils.getField(instance.getClass(), rootProperty, true);
        } else {
            getterMethod = ReflectionUtils.getGetter(instance.getClass(), attributeName, true);
            field = ReflectionUtils.getField(instance.getClass(), attributeName, true);
        }
        if (getterMethod == null && field == null) {
            throw new RuntimeException("Field not found " + fieldName);
        }
        if (getterMethod != null) {
            try {
                Object result = getterMethod.invoke(instance, new Object[0]);
                result = ReflectionUtils.ajustIfDate(result);
                if (isMultLevelProperty) {
                    return ReflectionUtils.getValueByName(result, attributeName);
                }
                return result;
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        ReflectionUtils.setAttributesAcessible(field);
        try {
            Object result = field.get(instance);
            result = ReflectionUtils.ajustIfDate(result);
            if (isMultLevelProperty) {
                return ReflectionUtils.getValueByName(result, attributeName);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Optional<Object> getOptionalValueByName(Object instance, String fieldName) {
        try {
            return Optional.of(ReflectionUtils.getValueByName(instance, fieldName));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public static void setValue(Object target, Field field, Object value) {
        ReflectionUtils.setValue(target, field, value == null ? null : value.getClass(), value);
    }

    public static void setValue(Object target, Field field, Class<?> classValue, Object value) {
        Method setterMethod = null;
        if (value != null) {
            setterMethod = ReflectionUtils.getSetter(target.getClass(), field.getName(), classValue, true);
        }
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            ReflectionUtils.setAttributesAcessible(field);
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getGetter(Field atributo) {
        return ReflectionUtils.getGetter(atributo.getName());
    }

    public static String getGetter(String atributo) {
        return ReflectionUtils.getMethod("get", atributo);
    }

    public static String getSetter(String atributo) {
        return ReflectionUtils.getMethod("set", atributo);
    }

    public static Method getGetter(Object objeto, Field atributo) {
        return ReflectionUtils.getGetter(objeto.getClass(), atributo.getName());
    }

    public static Method getGetter(Object objeto, String atributo) {
        return ReflectionUtils.getGetter(objeto.getClass(), atributo, true);
    }

    public static Method getGetter(Object objeto, String atributo, boolean buscaClassePai) {
        return ReflectionUtils.getGetter(objeto.getClass(), atributo, buscaClassePai);
    }

    public static Method getGetter(Class<?> classe, String atributo, boolean buscaClassePai) {
        String methodGetter = ReflectionUtils.getGetter(atributo);
        try {
            if (Arrays.stream(classe.getDeclaredMethods()).anyMatch(m -> m.getName().equals(methodGetter))) {
                return classe.getDeclaredMethod(methodGetter, new Class[0]);
            }
            if (buscaClassePai && classe != Object.class) {
                return ReflectionUtils.getGetter(classe.getSuperclass(), atributo, buscaClassePai);
            }
        }
        catch (NoSuchMethodException ex) {
            LogUtils.generate(ex);
        }
        return null;
    }

    public static Method getSetter(Object objeto, String atributo, Class<?> paramClassSet, boolean buscaClassePai) {
        return ReflectionUtils.getSetter(objeto.getClass(), atributo, paramClassSet, buscaClassePai);
    }

    public static Method getSetter(Class<?> clazz, String fieldName, Class<?> paramClassSet, boolean buscaClassePai) {
        String methodGetter = ReflectionUtils.getSetter(fieldName);
        try {
            return clazz.getDeclaredMethod(methodGetter, paramClassSet);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            LogUtils.generateSilent(ex);
            if (buscaClassePai && clazz != Object.class) {
                return ReflectionUtils.getSetter(clazz.getSuperclass(), methodGetter, paramClassSet, buscaClassePai);
            }
            return null;
        }
    }

    public static void setValue(String property, Object target, Object value) {
        Field field = ReflectionUtils.getField(target, property, true);
        ReflectionUtils.setAttributesAcessible(field);
        if (value == null) {
            ReflectionUtils.setValue(target, field, null);
        } else {
            ReflectionUtils.setValue(target, property, value, value.getClass());
        }
    }

    public static void setValue(Object instance, String nameField, Object value, Class<?> setParamClass) {
        Object target = instance;
        String property = nameField;
        String[] propriedadeTokens = property.split("\\.");
        boolean isMultLevelProperty = property.contains(".");
        if (!isMultLevelProperty) {
            Method setterMethod = ReflectionUtils.getSetter(target.getClass(), property, true, setParamClass);
            if (setterMethod != null) {
                try {
                    setterMethod.invoke(target, value);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                Field field = ReflectionUtils.getField(target.getClass(), property, true);
                if (field == null) {
                    throw new RuntimeException();
                }
                ReflectionUtils.setValue(target, field, value);
            }
        } else {
            int lastIndexProperty = property.lastIndexOf(46);
            String propriedadeSet = propriedadeTokens[propriedadeTokens.length - 1];
            property = property.substring(0, lastIndexProperty);
            target = ReflectionUtils.getValueByName(target, property);
            ReflectionUtils.setValue(target, propriedadeSet, value, setParamClass);
        }
    }

    public static Method getSetter(Class<?> clazz, String fieldName, boolean findInSuperClasses, Class<?> ... classParams) {
        String methodOrPropertyName = fieldName;
        if (methodOrPropertyName == null) {
            throw new IllegalStateException("methodOrPropertyName is null");
        }
        if (!methodOrPropertyName.startsWith("set")) {
            methodOrPropertyName = ReflectionUtils.getSetter(methodOrPropertyName);
        }
        try {
            return clazz.getDeclaredMethod(methodOrPropertyName, classParams);
        }
        catch (NoSuchMethodException ex) {
            LogUtils.generate(ex);
            if (findInSuperClasses && clazz != Object.class) {
                return ReflectionUtils.getSetter(clazz.getSuperclass(), methodOrPropertyName, findInSuperClasses, classParams);
            }
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getField(clazz, fieldName, true);
    }

    public static Field getField(Class<?> clazz, Class<?> clazzField) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType() != clazzField) continue;
            return field;
        }
        if (clazz.getSuperclass() != Object.class) {
            return ReflectionUtils.getField(clazz.getSuperclass(), clazzField);
        }
        return null;
    }

    public static Field getField(Object target, String fieldName, boolean findInSuperClasses) {
        return ReflectionUtils.getField(target.getClass(), fieldName, findInSuperClasses);
    }

    public static Field getField(Class<?> clazz, String fieldName, boolean findInSuperClasses) {
        Class<?> classFinal = clazz;
        String attribute = fieldName;
        while (attribute.contains(".")) {
            String attributeParcial = attribute.substring(0, attribute.indexOf(46));
            Field field = ReflectionUtils.getField(classFinal, attributeParcial, findInSuperClasses);
            classFinal = field.getType();
            attribute = attribute.replace(attributeParcial + ".", "");
        }
        String attributeNew = attribute;
        try {
            if (Arrays.stream(classFinal.getDeclaredFields()).anyMatch(f -> f.getName().equals(attributeNew))) {
                return classFinal.getDeclaredField(attributeNew);
            }
            if (findInSuperClasses && classFinal.getSuperclass() != Object.class) {
                return ReflectionUtils.getField(classFinal.getSuperclass(), attributeNew, findInSuperClasses);
            }
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        return null;
    }

    public static Field getFieldCollection(Class<?> clazz, Class<?> clazzOfCollection) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!Collection.class.isAssignableFrom(field.getType()) || ReflectionUtils.getGenericClass(field, 0) != clazzOfCollection) continue;
            return field;
        }
        if (clazz.getSuperclass() != Object.class) {
            return ReflectionUtils.getFieldCollection(clazz.getSuperclass(), clazzOfCollection);
        }
        return null;
    }

    public static void setAttributesAcessible(Field ... fields) {
        for (Field field : fields) {
            try {
                field.setAccessible(true);
            }
            catch (Exception ex) {
                LogUtils.generate(ex);
            }
        }
    }

    public static void setAttributesAcessible(Class<?> clazz, List<Field> fieldList, boolean findInSuperClasses, boolean setFieldsAsAccessible) {
        if (clazz.equals(Object.class) || clazz.equals(Class.class)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (setFieldsAsAccessible) {
                ReflectionUtils.setAttributesAcessible(field);
            }
            fieldList.add(field);
        }
        if (findInSuperClasses) {
            ReflectionUtils.setAttributesAcessible(clazz.getSuperclass(), fieldList, findInSuperClasses, setFieldsAsAccessible);
        }
    }

    public static Field[] getArrayFields(Class<?> clazz, boolean findInSuperClasses, boolean setFieldsAsAccessible) {
        ArrayList<Field> campos = new ArrayList<Field>();
        ReflectionUtils.setAttributesAcessible(clazz, campos, findInSuperClasses, setFieldsAsAccessible);
        return campos.toArray(new Field[campos.size()]);
    }

    public static Field[] getArrayFields(Object target, boolean findInSuperClasses, boolean setFieldsAsAccessible) {
        ArrayList<Field> campos = new ArrayList<Field>();
        ReflectionUtils.setAttributesAcessible(target.getClass(), campos, findInSuperClasses, setFieldsAsAccessible);
        return campos.toArray(new Field[campos.size()]);
    }

    public static Collection<Field> getListFields(Object target, boolean findInSuperClasses, boolean setFieldsAsAccessible) {
        return Arrays.stream(ReflectionUtils.getArrayFields(target, findInSuperClasses, setFieldsAsAccessible)).collect(Collectors.toList());
    }

    public static Collection<Field> getListFields(Class<?> target, boolean findInSuperClasses, boolean setFieldsAsAccessible) {
        return Arrays.stream(ReflectionUtils.getArrayFields(target, findInSuperClasses, setFieldsAsAccessible)).collect(Collectors.toList());
    }

    public static Object executeMethod(Object target, String methodName, Object ... params) throws InvocationTargetException, IllegalAccessException {
        Optional<Method> optMethod = Arrays.stream(target.getClass().getMethods()).filter(m -> m.getName().equals(methodName)).findAny();
        if (optMethod.isPresent()) {
            return ReflectionUtils.executeMethod(target, optMethod.get(), params);
        }
        Class[] paramsTypes = new Class[params.length];
        for (int i = 0; i < paramsTypes.length; ++i) {
            paramsTypes[i] = params[i].getClass();
        }
        Method method = ReflectionUtils.getMethod(target.getClass(), methodName, paramsTypes);
        if (method == null) {
            throw new RuntimeException("M\u00e9todo " + methodName + " com a assinatura buscada n\u00e3o encontrado em " + String.valueOf(target.getClass()) + " e em nenhuma de suas super classes");
        }
        return ReflectionUtils.executeMethod(target, method, params);
    }

    public static Object executeMethod(Object target, Method method, Object ... params) throws InvocationTargetException, IllegalAccessException {
        if (target == null) {
            throw new IllegalStateException("Objeto n\u00e3o pode ser null");
        }
        Class[] paramsTypes = new Class[params.length];
        for (int i = 0; i < paramsTypes.length; ++i) {
            paramsTypes[i] = params[i].getClass();
        }
        method.setAccessible(true);
        return method.invoke(target, params);
    }

    public static Method getMethod(Class<?> clazz, String methodName, List<Object> args) {
        return ReflectionUtils.getMethod(clazz, methodName, args.toArray());
    }

    public static Method getMethod(Class<?> clazz, String methodName, Object[] args) {
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            classes[i] = args[i].getClass();
        }
        return ReflectionUtils.getMethod(clazz, methodName, classes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramsTypes) {
        Method method;
        try {
            method = clazz.getMethod(methodName, paramsTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LogUtils.generateSilent(e);
            if (clazz == Object.class) {
                return null;
            }
            return ReflectionUtils.getMethod(clazz.getSuperclass(), methodName, paramsTypes);
        }
        return method;
    }

    public static boolean isAttribute(Object target, String attribute, boolean findInSuperClasses) {
        return ReflectionUtils.getField(target, attribute, findInSuperClasses) != null;
    }

    public static boolean isAttribute(Class<?> clazz, String attribute, boolean findInSuperClasses) {
        return ReflectionUtils.getField(clazz, attribute, findInSuperClasses) != null;
    }

    public static <T> Class<T> getGenericClass(Class<?> clazz, int idx) {
        ParameterizedType paramType;
        Type type = clazz.getGenericSuperclass();
        try {
            paramType = (ParameterizedType)type;
        }
        catch (ClassCastException cause) {
            if (clazz != Object.class) {
                return ReflectionUtils.getGenericClass(clazz.getSuperclass(), idx);
            }
            throw cause;
        }
        try {
            return (Class)paramType.getActualTypeArguments()[idx];
        }
        catch (ClassCastException cause) {
            type = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
            try {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return (Class)parameterizedType.getRawType();
            }
            catch (Exception cause2) {
                LogUtils.generateSilent(cause);
                throw cause;
            }
        }
    }

    public static <T> Class<T> getGenericClass(Field field, int idx) {
        Type type = field.getGenericType();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[idx];
    }

    public static <T> Class<T> getGenericClass(Member member, int idx) {
        Class<T> result = null;
        if (member instanceof Field) {
            result = ReflectionUtils.getGenericClass((Field)member, idx);
        } else if (member instanceof Method) {
            result = ReflectionUtils.getGenericClass((Method)member, idx);
        }
        return result;
    }

    public static <T> Class<T> getGenericClass(Method method, int pos) {
        return (Class)method.getGenericParameterTypes()[pos];
    }

    public static Object createInstance(Class<?> clazz) {
        try {
            if (Collection.class.isAssignableFrom(clazz)) {
                return ReflectionUtils.createCollection(clazz);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return new HashMap();
            }
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LogUtils.generate(ex);
            throw new RuntimeException(ex);
        }
    }

    public static <E> E createInstance(Class<E> clazz, Object ... args) {
        try {
            return (E)ConstructorUtils.invokeConstructor(clazz, (Object[])args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }

    public static Object cloneAttributes(Object copiar, Object copiado) {
        Field[] fieldsCopiado;
        if (copiar == null || copiado == null) {
            return null;
        }
        for (Field fieldCopiado : fieldsCopiado = ReflectionUtils.getArrayFields(copiado, false, false)) {
            Field fieldCopiar = ReflectionUtils.getField(copiar, fieldCopiado.getName(), false);
            if (fieldCopiar == null || !fieldCopiar.getType().isAssignableFrom(fieldCopiado.getType())) continue;
            try {
                ReflectionUtils.setAttributesAcessible(fieldCopiar, fieldCopiado);
                ReflectionUtils.setValue(copiar, fieldCopiar, fieldCopiado.get(copiado));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
        return copiar;
    }

    public static boolean isFieldAssignFromClass(Field field, Class<?> clazz) {
        if (!ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            return false;
        }
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        Class fieldClass = (Class)stringListType.getActualTypeArguments()[0];
        return clazz.isAssignableFrom(fieldClass);
    }

    public static Class<?> getGenericClass(Field field) {
        if (!ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            return field.getType();
        }
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        return (Class)stringListType.getActualTypeArguments()[0];
    }

    private static String getMethod(String prefix, String fieldName) {
        if (fieldName.startsWith(prefix)) {
            return fieldName;
        }
        String first = fieldName.substring(0, 1);
        return prefix + fieldName.replaceFirst(first, first.toUpperCase(Locale.getDefault()));
    }

    private static String removeStart(String str, String remove) {
        return !ReflectionUtils.isEmpty(str) && !ReflectionUtils.isEmpty(remove) ? (str.startsWith(remove) ? str.substring(remove.length()) : str) : str;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static Object createCollection(Class<?> clazz) {
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet();
        }
        return null;
    }

    private static Object ajustIfDate(Object result) {
        if (result != null) {
            if (Timestamp.class.equals(result.getClass())) {
                if (Date.class.isAssignableFrom(result.getClass())) {
                    result = new Date(((Timestamp)result).getTime());
                }
            } else if (Time.class.equals(result.getClass())) {
                if (Date.class.isAssignableFrom(result.getClass())) {
                    result = new Date(((Time)result).getTime());
                }
            } else if (LocalDate.class.equals(result.getClass())) {
                if (Date.class.isAssignableFrom(result.getClass())) {
                    result = DateUtils.toLocalDate(new Date(((Timestamp)result).getTime()));
                }
            } else if (LocalDateTime.class.equals(result.getClass()) && Date.class.isAssignableFrom(result.getClass())) {
                result = DateUtils.toLocalDateTime(new Date(((Timestamp)result).getTime()));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        C c = new C();
        ReflectionUtils.getListFields(c, true, true).forEach(f -> LogUtils.generate("Field: " + f.getName()));
    }
}

