/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.CheckoutSvn;
import br.com.jarch.svn.CommitSvn;
import br.com.jarch.svn.CopySvn;
import br.com.jarch.svn.DeleteSvn;
import br.com.jarch.svn.DiffSvn;
import br.com.jarch.svn.FileSvnUtils;
import br.com.jarch.svn.LogSvn;
import br.com.jarch.svn.MergeSvn;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.svn.StatusSvn;
import br.com.jarch.svn.SwitchSvn;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnFachada {
    private final CheckoutSvn checkoutSvn;
    private final SwitchSvn switchSvn;
    private final CopySvn copySvn;
    private final DeleteSvn deleteSvn;
    private final CommitSvn commitSvn;
    private final MergeSvn mergeSvn;
    private final StatusSvn statusSvn;
    private final DiffSvn diffSvn;
    private String login;
    private String senha;
    private List<String> log;

    public SvnFachada(String login, String senha, OutputStream outputStream) {
        this.login = login;
        this.senha = senha;
        this.log = new ArrayList<String>();
        this.checkoutSvn = new CheckoutSvn(this.log, login, senha, outputStream);
        this.copySvn = new CopySvn(this.log, login, senha, outputStream);
        this.deleteSvn = new DeleteSvn(this.log, login, senha, outputStream);
        this.switchSvn = new SwitchSvn(this.log, login, senha, outputStream);
        this.commitSvn = new CommitSvn(this.log, login, senha, outputStream);
        this.mergeSvn = new MergeSvn(this.log, login, senha, outputStream);
        this.statusSvn = new StatusSvn(this.log, login, senha, outputStream);
        this.diffSvn = new DiffSvn(this.log, login, senha, outputStream);
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public void checkout(URL repositorio, File workingCopy) throws Exception {
        this.checkoutSvn.checkout(repositorio, workingCopy);
    }

    public void checkout(URL repositorio, File workingCopy, long revisao) throws Exception {
        this.checkoutSvn.checkout(repositorio, workingCopy, revisao);
    }

    public void copy(URL repositorioOrigem, URL repositorioDestino, String comentario) throws Exception {
        this.copySvn.copy(repositorioOrigem, repositorioDestino, comentario);
    }

    public void delete(URL repositorio, String comentario) throws Exception {
        this.deleteSvn.delete(repositorio, comentario);
    }

    public void switchSvn(URL repositorio, File workingCopy) throws Exception {
        this.switchSvn.switchSvn(repositorio, workingCopy);
    }

    public void commit(URL repositorio, File workingCopy, Collection<String> listaArquivoIgnorar, String comentario) throws Exception {
        this.commitSvn.commit(repositorio, workingCopy, listaArquivoIgnorar, comentario);
    }

    public void merge(URL repositorio, File workingCopy) throws Exception {
        this.mergeSvn.merge(repositorio, workingCopy);
    }

    public void status(File workingCopy) throws Exception {
        this.statusSvn.status(workingCopy);
    }

    public boolean existeRepositorio(URL url) throws Exception {
        return this.commitSvn.existeRepositorio(url);
    }

    public void verificaConflito(File pastaTrabalho) throws Exception {
        this.commitSvn.verificaConflito(pastaTrabalho);
    }

    public URL getRepositorio(File pastaWorkinkCopy) throws SVNException, MalformedURLException {
        return this.commitSvn.getRepositorio(pastaWorkinkCopy);
    }

    public void limpaLog() {
        this.log = new ArrayList<String>();
    }

    public List<String> getLog() {
        return this.log;
    }

    public List<StatusArquivoForm> listaArquivoNaoComitado(File pastaTrabalho) throws Exception {
        return this.statusSvn.status(pastaTrabalho);
    }

    public List<String> diferencaArquivo(String nomeArquivo) throws Exception {
        File arquivo = new File(nomeArquivo);
        return this.diffSvn.diff(arquivo);
    }

    public List<String> descarte(File pastaTrabalho, final OutputStream outputStream) throws Exception {
        try {
            final LogSvn logUtil = new LogSvn();
            final ArrayList<String> logDescarte = new ArrayList<String>();
            logUtil.formatBegin(logDescarte, "DESCARTE", outputStream);
            try {
                SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
                svnOperationFactory.setEventHandler(new ISVNEventHandler(){

                    public void handleEvent(SVNEvent svnEvent, double v) throws SVNException {
                        if (svnEvent.getFile() != null) {
                            String mensagem = "REVERT: " + String.valueOf(svnEvent.getFile());
                            logUtil.formatMiddle(logDescarte, mensagem, outputStream);
                        }
                    }

                    public void checkCancelled() {
                    }
                });
                SvnRevert svnRevert = svnOperationFactory.createRevert();
                svnRevert.setSingleTarget(SvnTarget.fromFile((File)pastaTrabalho));
                svnRevert.setDepth(SVNDepth.INFINITY);
                svnRevert.setRevertMissingDirectories(true);
                svnRevert.setClearChangelists(true);
                svnRevert.run();
                List<StatusArquivoForm> listaArquivoNaoComitado = this.listaArquivoNaoComitado(pastaTrabalho);
                listaArquivoNaoComitado.forEach(af -> {
                    if (!af.getArquivo().equals(pastaTrabalho.getAbsolutePath())) {
                        logUtil.formatMiddle(logDescarte, "Apagando arquivo: " + af.getArquivo(), outputStream);
                        FileSvnUtils.remove(new File(af.getArquivo()));
                    }
                });
                logUtil.formatEnd(logDescarte, "DESCARTE", outputStream);
            }
            catch (SVNException ex) {
                ex.printStackTrace();
            }
            logUtil.formatBeginMiddleEnd(logDescarte, "DESCARTAR ALTERA\u00c7\u00d5ES", new String[]{"Working Copy " + pastaTrabalho.getAbsolutePath() + " DESCARTADO (REVERT)"});
            return logDescarte;
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
    }
}

