/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.crud.repository.BaseRepository;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import br.com.jarch.util.StringUtils;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Query;
import jakarta.persistence.Table;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.hibernate.Hibernate;

public final class JpaUtils {
    private JpaUtils() {
    }

    public static boolean cached(Class<?> clazz) {
        Cacheable cacheable = clazz.getAnnotation(Cacheable.class);
        return cacheable != null && cacheable.value();
    }

    public static <T> TypedQuery<T> createQueryCache(Class<?> clazz, TypedQuery<T> query) {
        if (!JpaUtils.cached(clazz)) {
            return query;
        }
        return query.setHint("org.hibernate.cacheable", (Object)true);
    }

    public static <T> TypedQuery<T> forceCache(TypedQuery<T> query) {
        return query.setHint("org.hibernate.cacheable", (Object)true);
    }

    public static boolean isCollectioOneToManyWithLazy(Field field) {
        if (!ReflectionUtils.isCollection((Field)field)) {
            return false;
        }
        if (!field.isAnnotationPresent(OneToMany.class)) {
            return false;
        }
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        return oneToMany.fetch() == FetchType.LAZY;
    }

    public static boolean isCollectionOneToMany(Object entity, Field field) {
        boolean result = ReflectionUtils.isCollection((Field)field);
        result &= JpaUtils.isObjectInitialize(entity, field);
        return result &= field.isAnnotationPresent(OneToMany.class);
    }

    public static boolean isCollectionOneToManyWithCascade(Object entity, Field field, CascadeType cascadeAcao) {
        if (!JpaUtils.isCollectionOneToMany(entity, field)) {
            return false;
        }
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        boolean cascade = false;
        for (CascadeType cascadeType : oneToMany.cascade()) {
            if (!cascadeType.equals((Object)CascadeType.ALL) && !cascadeType.equals((Object)cascadeAcao)) continue;
            cascade = true;
            break;
        }
        return cascade;
    }

    public static boolean isCollectionOneToManyWithCascadeAllOrCascadeMerge(Object entity, Field field) {
        return JpaUtils.isCollectionOneToManyWithCascade(entity, field, CascadeType.MERGE);
    }

    public static boolean isCollectionOneToManyWithCascadeAllOrCascadeRemove(Object entity, Field field) {
        return JpaUtils.isCollectionOneToManyWithCascade(entity, field, CascadeType.REMOVE);
    }

    public static boolean isOneToManyAndCascadeRemove(Class<?> classDelete, Class<?> classRelation) {
        for (Field field : ReflectionUtils.getListFields(classDelete, (boolean)true, (boolean)true)) {
            OneToMany oneToMany;
            if (!Collection.class.isAssignableFrom(field.getType()) || !ReflectionUtils.getGenericClass((Field)field).equals(classRelation) || (oneToMany = field.getAnnotation(OneToMany.class)) == null) continue;
            return Arrays.stream(oneToMany.cascade()).anyMatch(c -> CascadeType.ALL.equals(c) || CascadeType.REMOVE.equals(c));
        }
        return false;
    }

    public static boolean isOneToOneAndCascadeRemove(Class<?> classDelete, Class<?> classRelation) {
        for (Field field : ReflectionUtils.getListFields(classDelete, (boolean)true, (boolean)true)) {
            OneToOne oneToOne;
            if (!ReflectionUtils.getGenericClass((Field)field).equals(classRelation) || (oneToOne = field.getAnnotation(OneToOne.class)) == null) continue;
            return Arrays.stream(oneToOne.cascade()).anyMatch(c -> CascadeType.ALL.equals(c) || CascadeType.REMOVE.equals(c));
        }
        return false;
    }

    public static boolean isOneToOneAndMappedBy(Class<?> classMaster, Class<?> entiyType) {
        for (Field field : ReflectionUtils.getListFields(entiyType, (boolean)true, (boolean)true)) {
            OneToOne oneToOne;
            if (!ReflectionUtils.getGenericClass((Field)field).equals(classMaster) || (oneToOne = field.getAnnotation(OneToOne.class)) == null) continue;
            return !oneToOne.mappedBy().isEmpty();
        }
        return false;
    }

    public static boolean isOneToOneAndOrphanRemoval(Class<?> classMaster, Class<?> entiyType) {
        for (Field field : ReflectionUtils.getListFields(entiyType, (boolean)true, (boolean)true)) {
            OneToOne oneToOne;
            if (!ReflectionUtils.getGenericClass((Field)field).equals(classMaster) || (oneToOne = field.getAnnotation(OneToOne.class)) == null) continue;
            return oneToOne.orphanRemoval();
        }
        return false;
    }

    public static String nameEntity(Class<?> clazz) {
        Entity annotation = clazz.getAnnotation(Entity.class);
        return annotation == null || annotation.name() == null || annotation.name().isEmpty() ? clazz.getName() : annotation.name();
    }

    public static void setParameter(Query query, String nameParameter, Object valueParameter) {
        if (System.getProperty("JARCH.LOG.QUERYPARAM", "N").equals("S")) {
            LogUtils.generate((String)("PARAMETER: " + nameParameter + " VALUE: " + String.valueOf(valueParameter)));
        }
        query.setParameter(nameParameter, valueParameter);
    }

    public static void setParameterLike(Query query, String nameParameter, Object valueParameter) {
        Object valueLike = JpaUtils.getValueLike(valueParameter);
        JpaUtils.setParameter(query, nameParameter, valueLike);
    }

    private static Object getValueLike(Object value) {
        if (value instanceof String && !value.toString().startsWith("%") && !value.toString().endsWith("%")) {
            return "%" + String.valueOf(value) + "%";
        }
        return value;
    }

    public static void initialize(Object value) {
        Hibernate.initialize((Object)value);
    }

    public static void initializeCollectionLazy(Object entity) {
        if (entity == null) {
            return;
        }
        ReflectionUtils.getListFields((Object)entity, (boolean)true, (boolean)false).stream().filter(field -> Collection.class.isAssignableFrom(field.getType())).forEach(field -> {
            if (!JpaUtils.isObjectInitialize(entity, field)) {
                JpaUtils.objectInitialize(entity, field);
            }
            if (JpaUtils.isObjectInitialize(entity, field) && Collection.class.isAssignableFrom(field.getType())) {
                try {
                    Collection colecaoE = (Collection)field.get(entity);
                    if (colecaoE != null && !ReflectionUtils.getGenericClass((Field)field).isAnnotationPresent(Embeddable.class)) {
                        colecaoE.forEach(JpaUtils::initializeCollectionLazy);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LogUtils.generate((Throwable)ex);
                }
            }
        });
    }

    public static <E extends IIdentity> void initializeAllFields(E entity) {
        for (Field field : ReflectionUtils.getArrayFields(entity, (boolean)true, (boolean)false)) {
            JpaUtils.objectInitialize(entity, field);
        }
    }

    public static boolean isCollectionInitialized(Collection<?> collection) {
        return Hibernate.isInitialized(collection);
    }

    public static boolean isObjectInitialize(Object value) {
        return Hibernate.isInitialized((Object)value);
    }

    public static boolean isObjectInitialize(Object entity, Field field) {
        try {
            field.setAccessible(true);
            return Hibernate.isInitialized((Object)field.get(entity));
        }
        catch (IllegalAccessException | SecurityException ex) {
            LogUtils.generate((Throwable)ex);
            return false;
        }
    }

    public static void objectInitialize(Object entity, Field field) {
        try {
            if (JpaUtils.isObjectInitialize(entity, field)) {
                return;
            }
            field.setAccessible(true);
            Hibernate.initialize((Object)field.get(entity));
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }

    public static String ownerEntity(BaseRepository<? extends IIdentity> repository) {
        String owner = repository.getClassEntity().getAnnotation(Table.class).schema();
        if (StringUtils.isNotEmpty((String)owner)) {
            return owner;
        }
        return repository.getEntityManager().getEntityManagerFactory().getProperties().entrySet().stream().filter(es -> ((String)es.getKey()).equals("hibernate.default_schema")).map(Map.Entry::getValue).map(Object::toString).findFirst().orElseThrow(() -> new RuntimeException("Default SCHEMA not found in database connection"));
    }

    public static String tableName(BaseRepository<? extends IIdentity> repository) {
        return repository.getClassEntity().getAnnotation(Table.class).name();
    }

    public static String tableFullName(BaseRepository<? extends IIdentity> repository) {
        String owner = JpaUtils.ownerEntity(repository);
        String table = JpaUtils.tableName(repository);
        return owner + "." + table;
    }
}

