/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.service;

import br.com.jarch.core.annotation.JArchEventCloneEntity;
import br.com.jarch.core.annotation.JArchEventCreateEntity;
import br.com.jarch.core.annotation.JArchEventValidChange;
import br.com.jarch.core.annotation.JArchEventValidDelete;
import br.com.jarch.core.annotation.JArchEventValidInsert;
import br.com.jarch.core.annotation.JArchEventValidInsertChange;
import br.com.jarch.core.crud.repository.CrudRepository;
import br.com.jarch.core.crud.service.BaseService;
import br.com.jarch.core.crud.service.ICrudService;
import br.com.jarch.core.crud.util.CloneEntityUtils;
import br.com.jarch.core.crud.validation.BaseValidation;
import br.com.jarch.core.crud.validation.ChangeValidation;
import br.com.jarch.core.crud.validation.InsertChangeValidation;
import br.com.jarch.core.crud.validation.InsertValidation;
import br.com.jarch.core.model.ErroEntityForm;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.BeanValidationUtils;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import jakarta.validation.groups.Default;
import java.util.Collection;
import java.util.List;

public abstract class CrudService<E extends ICrudEntity, R extends CrudRepository<E>>
extends BaseService<E, R>
implements ICrudService<E> {
    @Inject
    @JArchEventCreateEntity
    private Event<E> eventCreateEntity;
    @Inject
    @JArchEventCloneEntity
    private Event<E> eventCloneInstance;
    @Inject
    @JArchEventValidInsert
    private Event<E> eventValidInsertNormal;
    @Inject
    @JArchEventValidInsert(dynamic=true)
    private Event<E> eventValidInsertDynamic;
    @Inject
    @JArchEventValidChange
    private Event<E> eventValidChangeNormal;
    @Inject
    @JArchEventValidChange(dynamic=true)
    private Event<E> eventValidChangeDynamic;
    @Inject
    @JArchEventValidInsertChange
    private Event<E> eventValidInsertChangeNormal;
    @Inject
    @JArchEventValidInsertChange(dynamic=true)
    private Event<E> eventValidInsertChangeDynamic;
    @Inject
    @JArchEventValidDelete
    private Event<E> eventValidDeleteNormal;
    @Inject
    @JArchEventValidDelete(dynamic=true)
    private Event<E> eventValidDeleteDynamic;

    @Override
    @Transactional
    public void insert(E entity) {
        ((CrudRepository)this.getRepository()).insert(entity);
    }

    @Override
    @Transactional
    public void insert(E entity, Class<?> ... groupBeanValidation) {
        ((CrudRepository)this.getRepository()).insert(entity, groupBeanValidation);
    }

    @Override
    @Transactional
    public void insert(E entity, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        ((CrudRepository)this.getRepository()).insert(entity, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> insert(Collection<E> entitys) {
        return ((CrudRepository)this.getRepository()).insert(entitys, List.of(), List.of());
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> insert(Collection<E> entitys, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        return ((CrudRepository)this.getRepository()).insert(entitys, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public E change(E entityChange) {
        return ((CrudRepository)this.getRepository()).change(entityChange);
    }

    @Override
    @Transactional
    public E change(E entityChange, Class<?> ... groupBeanValidation) {
        return ((CrudRepository)this.getRepository()).change(entityChange, groupBeanValidation);
    }

    @Override
    @Transactional
    public E change(E entityChange, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        return ((CrudRepository)this.getRepository()).change(entityChange, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> change(Collection<E> entitys) {
        return ((CrudRepository)this.getRepository()).change(entitys, List.of(), List.of());
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> change(Collection<E> entitys, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        return ((CrudRepository)this.getRepository()).change(entitys, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public void delete(E entity) {
        ((CrudRepository)this.getRepository()).delete(entity);
    }

    @Override
    @Transactional
    public void delete(E entity, Class<?> ... groupBeanValidation) {
        ((CrudRepository)this.getRepository()).delete(entity, groupBeanValidation);
    }

    @Override
    @Transactional
    public void delete(E entity, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        ((CrudRepository)this.getRepository()).delete(entity, groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public void delete(Long id) {
        ((CrudRepository)this.getRepository()).delete(id);
    }

    @Override
    @Transactional
    public void delete(Long id, Class<?> ... groupBeanValidation) {
        ((CrudRepository)this.getRepository()).delete((ICrudEntity)this.loadCrud(id), groupBeanValidation);
    }

    @Override
    @Transactional
    public void delete(Long id, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        ((CrudRepository)this.getRepository()).delete((ICrudEntity)this.loadCrud(id), groupBeanValidation, validations);
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> delete(Collection<E> entitys) {
        return ((CrudRepository)this.getRepository()).delete(entitys, List.of(), List.of());
    }

    @Override
    @Transactional
    public Collection<ErroEntityForm<E>> delete(Collection<E> entitys, List<Class<?>> groupBeanValidation, List<Class<? extends BaseValidation<E>>> validations) {
        return ((CrudRepository)this.getRepository()).delete(entitys, groupBeanValidation, validations);
    }

    @Override
    public E createEntity() {
        return this.createEntity(null);
    }

    @Override
    public E createEntity(String logicFrom) {
        try {
            ICrudEntity e = (ICrudEntity)this.getClassEntity().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            e.setLogicFrom(logicFrom);
            this.eventCreateEntity.fire((Object)e);
            return (E)e;
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
            return null;
        }
    }

    @Override
    public E cloneEntity(E entity) {
        return this.cloneEntity(entity, true);
    }

    @Override
    public E cloneEntity(E entity, boolean reloadCrud) {
        Object entityClone = entity.getId() == null || !reloadCrud ? entity : (ICrudEntity)this.loadCrud(entity.getId());
        ICrudEntity entityCloned = (ICrudEntity)CloneEntityUtils.clone(entityClone);
        this.eventCloneInstance.fire((Object)entityCloned);
        return (E)entityCloned;
    }

    @Override
    public void validInsert(E entity) {
        BeanValidationUtils.applyValidation(entity, InsertValidation.class, Default.class);
        this.firedEventsInsertChange(entity, this.eventValidInsertNormal, this.eventValidInsertDynamic);
    }

    @Override
    public void validChange(E entity) {
        BeanValidationUtils.applyValidation(entity, ChangeValidation.class, Default.class);
        this.firedEventsInsertChange(entity, this.eventValidChangeNormal, this.eventValidChangeDynamic);
    }

    @Override
    public void validDelete(E entity) {
        if (this.getIdDynamic() == null || this.getIdDynamic().isBlank()) {
            this.eventValidDeleteNormal.fire(entity);
        } else {
            this.eventValidDeleteDynamic.fire(entity);
        }
    }

    @Override
    public boolean isExclusionLogic() {
        return ((CrudRepository)this.getRepository()).isExclusionLogic();
    }

    @Override
    public void refresh(E entity) {
        ((CrudRepository)this.getRepository()).refresh(entity);
    }

    private void firedEventsInsertChange(E entity, Event<E> eventValidInsertNormal, Event<E> eventValidInsertDynamic) {
        BeanValidationUtils.applyValidation(entity, InsertChangeValidation.class, Default.class);
        if (this.getIdDynamic() == null || this.getIdDynamic().isBlank()) {
            eventValidInsertNormal.fire(entity);
            this.eventValidInsertChangeNormal.fire(entity);
        } else {
            eventValidInsertDynamic.fire(entity);
            this.eventValidInsertChangeDynamic.fire(entity);
        }
    }
}

