/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchValidPeriod;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchValidPeriod", "br.com.jarch.core.annotation.JArchValidPeriod.List"})
public class PeriodProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWithAny(Set.of(JArchValidPeriod.class, JArchValidPeriod.List.class)).forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                this.validPeriod((Element)element);
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void validPeriod(Element element) {
        for (JArchValidPeriod anotacao : (JArchValidPeriod[])element.getAnnotationsByType(JArchValidPeriod.class)) {
            TypeElement classeElement = (TypeElement)element;
            PeriodProcessor.existsFieldPeriod(this.processingEnv, element, classeElement, anotacao.fieldBegin());
            PeriodProcessor.existsFieldPeriod(this.processingEnv, element, classeElement, anotacao.fieldEnd());
            PeriodProcessor.validaTypesEquals(this.processingEnv, element, classeElement, anotacao.fieldBegin(), anotacao.fieldEnd());
        }
    }

    private static void existsFieldPeriod(ProcessingEnvironment processingEnv, Element elementAtual, TypeElement classeElement, String field) {
        ArrayList classTypes = new ArrayList();
        classTypes.add(Date.class);
        classTypes.add(LocalDate.class);
        classTypes.add(YearMonth.class);
        if (!ProcessorUtils.existsFieldType(classeElement, field, classTypes)) {
            ProcessorUtils.messageError("JARCH ERROR: Atributo " + field + " dos tipos [" + classTypes.stream().map(c -> c.getName()).collect(Collectors.joining(", ")) + "] n\u00e3o localizado na anota\u00e7\u00e3o @JArchValidPeriod", elementAtual);
        }
    }

    private static void validaTypesEquals(ProcessingEnvironment processingEnv, Element elementAtual, TypeElement classeElement, String field1, String field2) {
        try {
            String classAttribute1 = ProcessorUtils.classTypeField(classeElement, field1);
            String classAttribute2 = ProcessorUtils.classTypeField(classeElement, field2);
            if (!classAttribute1.equals(classAttribute2)) {
                throw new Exception("Tipo do atributo " + field1 + " (" + classAttribute1 + ") diferente do tipo atributo " + field2 + " (" + classAttribute2 + ") na anota\u00e7\u00e3o @JArchValidPeriod");
            }
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: " + ex.getMessage(), classeElement);
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return super.getCompletions(element, annotation, member, userText);
    }
}

