/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Index;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.IndexOrUniqueKeySecondPass;
import org.hibernate.boot.model.internal.JPAIndexHolder;
import org.hibernate.boot.model.internal.ObjectNameSource;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.UniqueConstraintHolder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public class TableBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TableBinder.class.getName());
    private MetadataBuildingContext buildingContext;
    private String schema;
    private String catalog;
    private String name;
    private boolean isAbstract;
    private List<UniqueConstraintHolder> uniqueConstraints;
    private String ownerEntityTable;
    private String associatedEntityTable;
    private String propertyName;
    private String ownerClassName;
    private String ownerEntity;
    private String ownerJpaEntity;
    private String associatedClassName;
    private String associatedEntity;
    private String associatedJpaEntity;
    private boolean isJPA2ElementCollection;
    private List<JPAIndexHolder> jpaIndexHolders;

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public void setUniqueConstraints(UniqueConstraint[] uniqueConstraints) {
        this.uniqueConstraints = TableBinder.buildUniqueConstraintHolders(uniqueConstraints);
    }

    public void setJpaIndex(jakarta.persistence.Index[] jpaIndex) {
        this.jpaIndexHolders = TableBinder.buildJpaIndexHolder(jpaIndex);
    }

    public void setJPA2ElementCollection(boolean isJPA2ElementCollection) {
        this.isJPA2ElementCollection = isJPA2ElementCollection;
    }

    public Table bind() {
        final Identifier ownerEntityTableNameIdentifier = this.toIdentifier(this.ownerEntityTable);
        final String unquotedOwnerTable = StringHelper.unquote(this.ownerEntityTable);
        final String unquotedAssocTable = StringHelper.unquote(this.associatedEntityTable);
        ObjectNameSource nameSource = this.buildNameContext();
        final boolean ownerEntityTableQuoted = StringHelper.isQuoted(this.ownerEntityTable);
        final boolean associatedEntityTableQuoted = StringHelper.isQuoted(this.associatedEntityTable);
        NamingStrategyHelper namingStrategyHelper = new NamingStrategyHelper(){

            @Override
            public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
                ImplicitNamingStrategy namingStrategy = buildingContext.getBuildingOptions().getImplicitNamingStrategy();
                Identifier name = TableBinder.this.isJPA2ElementCollection ? namingStrategy.determineCollectionTableName(new ImplicitCollectionTableNameSource(){
                    private final EntityNaming entityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return TableBinder.this.ownerClassName;
                        }

                        @Override
                        public String getEntityName() {
                            return TableBinder.this.ownerEntity;
                        }

                        @Override
                        public String getJpaEntityName() {
                            return TableBinder.this.ownerJpaEntity;
                        }
                    };

                    @Override
                    public Identifier getOwningPhysicalTableName() {
                        return ownerEntityTableNameIdentifier;
                    }

                    @Override
                    public EntityNaming getOwningEntityNaming() {
                        return this.entityNaming;
                    }

                    @Override
                    public AttributePath getOwningAttributePath() {
                        return AttributePath.parse(TableBinder.this.propertyName);
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return buildingContext;
                    }
                }) : namingStrategy.determineJoinTableName(new ImplicitJoinTableNameSource(){
                    private final EntityNaming owningEntityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return TableBinder.this.ownerClassName;
                        }

                        @Override
                        public String getEntityName() {
                            return TableBinder.this.ownerEntity;
                        }

                        @Override
                        public String getJpaEntityName() {
                            return TableBinder.this.ownerJpaEntity;
                        }
                    };
                    private final EntityNaming nonOwningEntityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return TableBinder.this.associatedClassName;
                        }

                        @Override
                        public String getEntityName() {
                            return TableBinder.this.associatedEntity;
                        }

                        @Override
                        public String getJpaEntityName() {
                            return TableBinder.this.associatedJpaEntity;
                        }
                    };

                    @Override
                    public String getOwningPhysicalTableName() {
                        return unquotedOwnerTable;
                    }

                    @Override
                    public EntityNaming getOwningEntityNaming() {
                        return this.owningEntityNaming;
                    }

                    @Override
                    public String getNonOwningPhysicalTableName() {
                        return unquotedAssocTable;
                    }

                    @Override
                    public EntityNaming getNonOwningEntityNaming() {
                        return this.nonOwningEntityNaming;
                    }

                    @Override
                    public AttributePath getAssociationOwningAttributePath() {
                        return AttributePath.parse(TableBinder.this.propertyName);
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return buildingContext;
                    }
                });
                if (ownerEntityTableQuoted || associatedEntityTableQuoted) {
                    name = Identifier.quote(name);
                }
                return name;
            }

            @Override
            public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
                return buildingContext.getMetadataCollector().getDatabase().toIdentifier(explicitName);
            }

            @Override
            public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
                return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment());
            }
        };
        return TableBinder.buildAndFillTable(this.schema, this.catalog, StringHelper.isNotEmpty(nameSource.getExplicitName()) ? namingStrategyHelper.handleExplicitName(nameSource.getExplicitName(), this.buildingContext) : namingStrategyHelper.determineImplicitName(this.buildingContext), this.isAbstract, this.uniqueConstraints, this.jpaIndexHolders, this.buildingContext, null, null);
    }

    private Identifier toIdentifier(String tableName) {
        return this.buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(tableName);
    }

    private ObjectNameSource buildNameContext() {
        if (this.name != null) {
            return new AssociationTableNameSource(this.name, null);
        }
        Identifier logicalName = this.isJPA2ElementCollection ? this.buildingContext.getBuildingOptions().getImplicitNamingStrategy().determineCollectionTableName(new ImplicitCollectionTableNameSource(){
            private final EntityNaming owningEntityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return TableBinder.this.ownerClassName;
                }

                @Override
                public String getEntityName() {
                    return TableBinder.this.ownerEntity;
                }

                @Override
                public String getJpaEntityName() {
                    return TableBinder.this.ownerJpaEntity;
                }
            };

            @Override
            public Identifier getOwningPhysicalTableName() {
                return TableBinder.this.toIdentifier(TableBinder.this.ownerEntityTable);
            }

            @Override
            public EntityNaming getOwningEntityNaming() {
                return this.owningEntityNaming;
            }

            @Override
            public AttributePath getOwningAttributePath() {
                return AttributePath.parse(TableBinder.this.propertyName);
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return TableBinder.this.buildingContext;
            }
        }) : this.buildingContext.getBuildingOptions().getImplicitNamingStrategy().determineJoinTableName(new ImplicitJoinTableNameSource(){
            private final EntityNaming owningEntityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return TableBinder.this.ownerClassName;
                }

                @Override
                public String getEntityName() {
                    return TableBinder.this.ownerEntity;
                }

                @Override
                public String getJpaEntityName() {
                    return TableBinder.this.ownerJpaEntity;
                }
            };
            private final EntityNaming nonOwningEntityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return TableBinder.this.associatedClassName;
                }

                @Override
                public String getEntityName() {
                    return TableBinder.this.associatedEntity;
                }

                @Override
                public String getJpaEntityName() {
                    return TableBinder.this.associatedJpaEntity;
                }
            };

            @Override
            public String getOwningPhysicalTableName() {
                return TableBinder.this.ownerEntityTable;
            }

            @Override
            public EntityNaming getOwningEntityNaming() {
                return this.owningEntityNaming;
            }

            @Override
            public String getNonOwningPhysicalTableName() {
                return TableBinder.this.associatedEntityTable;
            }

            @Override
            public EntityNaming getNonOwningEntityNaming() {
                return this.nonOwningEntityNaming;
            }

            @Override
            public AttributePath getAssociationOwningAttributePath() {
                return AttributePath.parse(TableBinder.this.propertyName);
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return TableBinder.this.buildingContext;
            }
        });
        return new AssociationTableNameSource(this.name, logicalName.render());
    }

    public static Table buildAndFillTable(String schema, String catalog, Identifier logicalName, boolean isAbstract, List<UniqueConstraintHolder> uniqueConstraints, MetadataBuildingContext buildingContext) {
        return TableBinder.buildAndFillTable(schema, catalog, logicalName, isAbstract, uniqueConstraints, null, buildingContext, null, null);
    }

    public static Table buildAndFillTable(String schema, String catalog, Identifier logicalName, boolean isAbstract, List<UniqueConstraintHolder> uniqueConstraints, MetadataBuildingContext buildingContext, String subselect, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        return TableBinder.buildAndFillTable(schema, catalog, logicalName, isAbstract, uniqueConstraints, null, buildingContext, subselect, denormalizedSuperTableXref);
    }

    private static Table buildAndFillTable(String schema, String catalog, Identifier logicalName, boolean isAbstract, List<UniqueConstraintHolder> uniqueConstraints, List<JPAIndexHolder> jpaIndexHolders, MetadataBuildingContext buildingContext, String subselect, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        schema = StringHelper.nullIfEmpty(schema);
        catalog = StringHelper.nullIfEmpty(catalog);
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        Table table = denormalizedSuperTableXref != null ? metadataCollector.addDenormalizedTable(schema, catalog, logicalName.render(), isAbstract, subselect, denormalizedSuperTableXref.getPrimaryTable(), buildingContext) : metadataCollector.addTable(schema, catalog, logicalName.render(), subselect, isAbstract, buildingContext);
        if (CollectionHelper.isNotEmpty(uniqueConstraints)) {
            metadataCollector.addUniqueConstraintHolders(table, uniqueConstraints);
        }
        if (CollectionHelper.isNotEmpty(jpaIndexHolders)) {
            metadataCollector.addJpaIndexHolders(table, jpaIndexHolders);
        }
        metadataCollector.addTableNameBinding(logicalName, table);
        return table;
    }

    public static void bindForeignKey(PersistentClass referencedEntity, PersistentClass destinationEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, boolean unique, MetadataBuildingContext buildingContext) {
        PropertyHolder holder;
        PersistentClass associatedClass = destinationEntity != null ? destinationEntity : ((holder = joinColumns.getPropertyHolder()) == null ? null : holder.getPersistentClass());
        AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
        if (joinColumns.hasMappedBy()) {
            TableBinder.bindUnownedAssociation(joinColumns, value, associatedClass, joinColumns.getMappedBy());
        } else if (firstColumn.isImplicit()) {
            TableBinder.bindImplicitColumns(referencedEntity, joinColumns, value);
            if (value instanceof ToOne) {
                ((ToOne)value).setSorted(true);
            }
        } else {
            TableBinder.bindExplicitColumns(referencedEntity, joinColumns, value, buildingContext, associatedClass);
        }
        value.createForeignKey(referencedEntity, joinColumns);
        if (unique) {
            value.createUniqueKey();
        }
    }

    private static void bindExplicitColumns(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, MetadataBuildingContext buildingContext, PersistentClass associatedClass) {
        switch (joinColumns.getReferencedColumnsType(referencedEntity)) {
            case NON_PRIMARY_KEY_REFERENCE: {
                TableBinder.bindNonPrimaryKeyReference(referencedEntity, joinColumns, value);
                break;
            }
            case IMPLICIT_PRIMARY_KEY_REFERENCE: {
                TableBinder.bindImplicitPrimaryKeyReference(referencedEntity, joinColumns, value, associatedClass);
                break;
            }
            case EXPLICIT_PRIMARY_KEY_REFERENCE: {
                TableBinder.bindPrimaryKeyReference(referencedEntity, joinColumns, value, associatedClass, buildingContext);
            }
        }
    }

    private static void bindImplicitPrimaryKeyReference(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, PersistentClass associatedClass) {
        if (joinColumns.getColumns().size() != referencedEntity.getIdentifier().getColumnSpan()) {
            throw new AnnotationException("An association that targets entity '" + referencedEntity.getEntityName() + "' from entity '" + associatedClass.getEntityName() + "' has " + joinColumns.getColumns().size() + " '@JoinColumn's but the primary key has " + referencedEntity.getIdentifier().getColumnSpan() + " columns");
        }
        TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(referencedEntity, referencedEntity.getIdentifier(), joinColumns, value);
        if (value instanceof SortableValue) {
            ((SortableValue)((Object)value)).sortProperties();
        }
    }

    private static void bindPrimaryKeyReference(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, PersistentClass associatedClass, MetadataBuildingContext buildingContext) {
        KeyValue key = referencedEntity.getKey();
        if (key instanceof Component) {
            ((Component)key).sortProperties();
        }
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        Dialect dialect = metadataCollector.getDatabase().getJdbcEnvironment().getDialect();
        for (int j = 0; j < key.getColumnSpan(); ++j) {
            if (TableBinder.matchUpJoinColumnsWithKeyColumns(referencedEntity, joinColumns, value, metadataCollector, dialect, j)) continue;
            throw new AnnotationException("An association that targets entity '" + referencedEntity.getEntityName() + "' from entity '" + associatedClass.getEntityName() + "' has no '@JoinColumn' referencing column '" + key.getColumns().get(j).getName() + "'");
        }
        if (value instanceof ToOne) {
            ((ToOne)value).setSorted(true);
        } else if (value instanceof DependantValue) {
            ((DependantValue)value).setSorted(true);
        } else {
            throw new AssertionError((Object)("This should never happen, value can only be ToOne or DependantValue,instead it's '" + value.getClass().getName() + "'"));
        }
    }

    private static boolean matchUpJoinColumnsWithKeyColumns(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns, SimpleValue value, InFlightMetadataCollector metadataCollector, Dialect dialect, int index) {
        for (AnnotatedJoinColumn joinColumn : joinColumns.getJoinColumns()) {
            Column column;
            String quotedName;
            List<Column> columns;
            String referencedColumn;
            block8: {
                String referencedNamed = joinColumn.getReferencedColumn();
                referencedColumn = null;
                columns = null;
                try {
                    Table referencedTable = referencedEntity.getTable();
                    referencedColumn = metadataCollector.getPhysicalColumnName(referencedTable, referencedNamed);
                    columns = referencedEntity.getKey().getColumns();
                }
                catch (MappingException me) {
                    for (Join join : referencedEntity.getJoins()) {
                        try {
                            Table referencedTable = join.getTable();
                            referencedColumn = metadataCollector.getPhysicalColumnName(referencedTable, referencedNamed);
                            columns = referencedTable.getPrimaryKey().getColumns();
                            break;
                        }
                        catch (MappingException mappingException) {
                        }
                    }
                    if (referencedColumn != null) break block8;
                    throw me;
                }
            }
            if (!referencedColumn.equalsIgnoreCase(quotedName = (column = columns.get(index)).getQuotedName(dialect))) continue;
            if (joinColumn.isNameDeferred()) {
                joinColumn.linkValueUsingDefaultColumnNaming(column, referencedEntity, value);
            } else {
                joinColumn.linkWithValue(value);
            }
            joinColumn.overrideFromReferencedColumnIfNecessary(column);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void bindNonPrimaryKeyReference(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns, SimpleValue value) {
        String referencedPropertyName;
        if (value instanceof ToOne) {
            referencedPropertyName = ((ToOne)value).getReferencedPropertyName();
        } else {
            if (!(value instanceof DependantValue)) throw new AssertionFailure("Property ref to an unexpected Value type: " + value.getClass().getName());
            String propertyName = joinColumns.getPropertyName();
            if (propertyName == null) throw new AnnotationException("The '@JoinColumn' for a secondary table must reference the primary key");
            Collection collection = (Collection)referencedEntity.getRecursiveProperty(propertyName).getValue();
            referencedPropertyName = collection.getReferencedPropertyName();
        }
        if (referencedPropertyName == null) {
            throw new AssertionFailure("No property ref found");
        }
        Property synthProp = referencedEntity.getReferencedProperty(referencedPropertyName);
        if (synthProp == null) {
            throw new AssertionFailure("Cannot find synthetic property: " + referencedEntity.getEntityName() + "." + referencedPropertyName);
        }
        TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(referencedEntity, synthProp.getValue(), joinColumns, value);
        ((SortableValue)((Object)value)).sortProperties();
    }

    private static void bindImplicitColumns(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns, SimpleValue value) {
        List<Column> idColumns = referencedEntity instanceof JoinedSubclass ? referencedEntity.getKey().getColumns() : referencedEntity.getIdentifier().getColumns();
        for (Column column : idColumns) {
            AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
            firstColumn.linkValueUsingDefaultColumnNaming(column, referencedEntity, value);
            firstColumn.overrideFromReferencedColumnIfNecessary(column);
        }
    }

    private static void bindUnownedAssociation(AnnotatedJoinColumns joinColumns, SimpleValue value, PersistentClass associatedClass, String mappedByProperty) {
        AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
        for (Column column : TableBinder.mappedByColumns(associatedClass, mappedByProperty)) {
            firstColumn.overrideFromReferencedColumnIfNecessary(column);
            firstColumn.linkValueUsingAColumnCopy(column, value);
        }
    }

    private static List<Column> mappedByColumns(PersistentClass associatedClass, String mappedByProperty) {
        LOG.debugf("Retrieving property %s.%s", associatedClass.getEntityName(), mappedByProperty);
        Value value = associatedClass.getRecursiveProperty(mappedByProperty).getValue();
        if (value instanceof Collection) {
            Value element = ((Collection)value).getElement();
            if (element == null) {
                throw new AnnotationException("Both sides of the bidirectional association '" + associatedClass.getEntityName() + "." + mappedByProperty + "' specify 'mappedBy'");
            }
            return element.getColumns();
        }
        return value.getColumns();
    }

    public static void linkJoinColumnWithValueOverridingNameIfImplicit(PersistentClass referencedEntity, Value value, AnnotatedJoinColumns joinColumns, SimpleValue simpleValue) {
        List<Column> valueColumns = value.getColumns();
        List<AnnotatedJoinColumn> columns = joinColumns.getJoinColumns();
        for (int i = 0; i < columns.size(); ++i) {
            AnnotatedJoinColumn joinColumn = columns.get(i);
            Column synthCol = valueColumns.get(i);
            if (joinColumn.isNameDeferred()) {
                joinColumn.linkValueUsingDefaultColumnNaming(synthCol, referencedEntity, simpleValue);
                continue;
            }
            joinColumn.linkWithValue(simpleValue);
            joinColumn.overrideFromReferencedColumnIfNecessary(synthCol);
        }
    }

    public static void addIndexes(Table table, Index[] indexes, MetadataBuildingContext context) {
        for (Index index : indexes) {
            context.getMetadataCollector().addSecondPass(new IndexOrUniqueKeySecondPass(table, index.name(), index.columnNames(), context));
        }
    }

    public static void addIndexes(Table table, jakarta.persistence.Index[] indexes, MetadataBuildingContext context) {
        context.getMetadataCollector().addJpaIndexHolders(table, TableBinder.buildJpaIndexHolder(indexes));
    }

    public static List<JPAIndexHolder> buildJpaIndexHolder(jakarta.persistence.Index[] indexes) {
        ArrayList<JPAIndexHolder> holders = new ArrayList<JPAIndexHolder>(indexes.length);
        for (jakarta.persistence.Index index : indexes) {
            holders.add(new JPAIndexHolder(index));
        }
        return holders;
    }

    public static List<UniqueConstraintHolder> buildUniqueConstraintHolders(UniqueConstraint[] annotations) {
        List<UniqueConstraintHolder> result;
        if (annotations == null || annotations.length == 0) {
            result = Collections.emptyList();
        } else {
            result = CollectionHelper.arrayList(annotations.length);
            for (UniqueConstraint uc : annotations) {
                result.add(new UniqueConstraintHolder().setName(uc.name(), !uc.name().isEmpty()).setColumns(uc.columnNames()));
            }
        }
        return result;
    }

    public void setDefaultName(String ownerClassName, String ownerEntity, String ownerJpaEntity, String ownerEntityTable, String associatedClassName, String associatedEntity, String associatedJpaEntity, String associatedEntityTable, String propertyName) {
        this.ownerClassName = ownerClassName;
        this.ownerEntity = ownerEntity;
        this.ownerJpaEntity = ownerJpaEntity;
        this.ownerEntityTable = ownerEntityTable;
        this.associatedClassName = associatedClassName;
        this.associatedEntity = associatedEntity;
        this.associatedJpaEntity = associatedJpaEntity;
        this.associatedEntityTable = associatedEntityTable;
        this.propertyName = propertyName;
        this.name = null;
    }

    private static class AssociationTableNameSource
    implements ObjectNameSource {
        private final String explicitName;
        private final String logicalName;

        private AssociationTableNameSource(String explicitName, String logicalName) {
            this.explicitName = explicitName;
            this.logicalName = logicalName;
        }

        @Override
        public String getExplicitName() {
            return this.explicitName;
        }

        @Override
        public String getLogicalName() {
            return this.logicalName;
        }
    }
}

