/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.planejamento.PlanejamentoSolEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.fx.util.AmbienteUtils;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

public class InicioEmpacotamentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private Button buttonInicioDesenvolvimento;
    private SistemaEntity sistemaEntity;
    private File pastaTrabalho;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.atualizaCombo();
        Platform.runLater(() -> {
            try {
                this.clearLog();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        });
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                InicioEmpacotamentoController.this.desabilitaComponentes();
                PlanejamentoSolEntity planejamentoSol = (PlanejamentoSolEntity)InicioEmpacotamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                InicioEmpacotamentoController.this.sistemaEntity = planejamentoSol.getPlanejamentoEntity().getSistemaEntity();
                String login = InicioEmpacotamentoController.this.getConfiguracaoSingleton().getLogin();
                String versao = planejamentoSol.getPlanejamentoEntity().getVersao();
                InicioEmpacotamentoController.this.pastaTrabalho = PastaUtil.getPastaTrabalho((String)login, (String)InicioEmpacotamentoController.this.sistemaEntity.getServidorEmpacotamento(), (String)versao);
                RemoteFactory.getInstance().getProcessamento().validacaoInicioEmpacotamento(planejamentoSol.getId());
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                InicioEmpacotamentoController.this.startProcessLog();
                Platform.runLater(() -> InicioEmpacotamentoController.this.clearLog());
                InicioEmpacotamentoController.this.criaTaskAtualizacaoLabel();
                ArrayList log = new ArrayList();
                String servidorSvn = InicioEmpacotamentoController.this.getConfiguracaoSingleton().getServidorSvn();
                String senha = InicioEmpacotamentoController.this.getConfiguracaoSingleton().getSenha();
                InicioEmpacotamentoController.this.getEmpacotamentoSvn().iniciaEmpacotamento(servidorSvn, login, senha, planejamentoSol, log, InicioEmpacotamentoController.this.getOutputStream());
                RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosInicioEmpacotamento(login, planejamentoSol.getId());
                InicioEmpacotamentoController.this.getEmpacotamentoSvn().verificaConflito(login, senha, InicioEmpacotamentoController.this.sistemaEntity, versao, InicioEmpacotamentoController.this.getOutputStream());
                Platform.runLater(() -> InicioEmpacotamentoController.this.updateLogWebView(String.join((CharSequence)"\n", log)));
                return null;
            }

            protected void failed() {
                this.getException().printStackTrace();
                Platform.runLater(() -> {
                    InicioEmpacotamentoController.this.endProcessLog();
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString("cd " + InicioEmpacotamentoController.this.pastaTrabalho.getAbsolutePath() + "; svn resolve");
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                    try {
                        if (AmbienteUtils.isLinux()) {
                            Runtime.getRuntime().exec("gnome-terminal", null, InicioEmpacotamentoController.this.pastaTrabalho);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Object mensagemErro = "Existe arquivo(s) em conflito. Resolver antes de continuar...\n\n";
                    mensagemErro = (String)mensagemErro + "Colar o comando do clipboard no terminal que acabou de ser aberto!";
                    MensagemView.getInstancia().mostraErro(InicioEmpacotamentoController.this.anchorPane, (String)mensagemErro);
                    InicioEmpacotamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    InicioEmpacotamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(InicioEmpacotamentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    InicioEmpacotamentoController.this.habilitaComponentes();
                    InicioEmpacotamentoController.this.atualizaCombo();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getSelectionModel().clearSelection();
        this.comboBoxPlanejamento.getItems().clear();
        this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaInicioEmpacotamento(this.getConfiguracaoSingleton().getLogin()).stream().sorted(OrdenacaoLista.planejamentoSolComparator).collect(Collectors.toList()));
        this.comboBoxPlanejamento.setValue(null);
    }
}

