/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseButton;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class FinalizacaoDesenvolvimentoController
extends BaseFxml {
    @FXML
    private Button buttonSalvaDesenvolvimento;
    @FXML
    private TextArea textAreaComentario;
    @FXML
    private ComboBox comboBoxDesenvolvimento;
    @FXML
    private TableView tableViewArquivo;
    private File pacoteSelecionado;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.getDesenvolvimentoClientFachada().criaColunasTableViewArquivo(this.tableViewArquivo);
        this.comboBoxDesenvolvimento.setOnAction(event -> this.eventoCliqueSol());
        this.tableViewArquivo.setOnMouseClicked(event -> {
            if (!event.getButton().equals((Object)MouseButton.PRIMARY) || event.getClickCount() != 2) {
                return;
            }
            this.eventoCliqueArquivo();
        });
        Platform.runLater(this::criaTaskAtualizacaoGrid);
    }

    private void atualizaGrid() {
        try {
            List<DesenvolvimentoForm> listaSolsAberto = this.getConsumoRestSingleton().listaSolsDesenvolvimento();
            ObservableList data = FXCollections.observableArrayList(listaSolsAberto);
            Platform.runLater(() -> {
                this.comboBoxDesenvolvimento.getItems().clear();
                this.comboBoxDesenvolvimento.getItems().addAll((Collection)data.stream().sorted(OrdenacaoLista.desenvolvimentoFormComparator).collect(Collectors.toList()));
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void buttonSalvaDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)FinalizacaoDesenvolvimentoController.this.comboBoxDesenvolvimento.getSelectionModel().getSelectedItem();
                if (desenvolvimentoForm == null) {
                    throw new Exception("Selecione uma SOL");
                }
                if (FinalizacaoDesenvolvimentoController.this.textAreaComentario.getText().isEmpty()) {
                    throw new Exception("Coment\u00e1rio tem que conter pelo menos 5 caracteres");
                }
                desenvolvimentoForm.setUtilizador(FinalizacaoDesenvolvimentoController.this.getConfiguracaoSingleton().getUtilizador());
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                desenvolvimentoForm.setNomeArquivoPacote("NAO UTILIZADO");
                desenvolvimentoForm.setTamanhoPacoteBytes(100L);
                desenvolvimentoForm.setComentario(FinalizacaoDesenvolvimentoController.this.textAreaComentario.getText());
                FinalizacaoDesenvolvimentoController.this.desabilitaComponentes();
                FinalizacaoDesenvolvimentoController.this.startProcessLog();
                FinalizacaoDesenvolvimentoController.this.criaTaskAtualizacaoLabel();
                AplicacaoForm aplicacaoForm = FinalizacaoDesenvolvimentoController.this.getConsumoRestSingleton().pesquisaAplicacao(desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia());
                List<String> log = FinalizacaoDesenvolvimentoController.this.getDesenvolvimentoClientFachada().finalizaDesenvolvimento(FinalizacaoDesenvolvimentoController.this.getConfiguracaoSingleton().getServidorSvn(), desenvolvimentoForm, aplicacaoForm, FinalizacaoDesenvolvimentoController.this.getOutputStream());
                FinalizacaoDesenvolvimentoController.this.criaTaskAtualizacaoGrid();
                Platform.runLater(() -> {
                    try {
                        File pastaSistema = PastaUtil.getPastaTrabalho((String)desenvolvimentoForm.getLogin(), (String)aplicacaoForm.getServidorDesenvolvimento(), (String)"");
                        PastaUtil.moveBackupToConcluido((String)pastaSistema.getAbsolutePath());
                        File pastaTrabalho = PastaUtil.getPastaTrabalho((String)desenvolvimentoForm.getLogin(), (String)aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                        File pastaTrabalhoBkp = PastaUtil.getPastaTrabalhoFinalizado((String)desenvolvimentoForm.getLogin(), (String)aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                        try {
                            FileUtils.move((File)pastaTrabalho, (File)pastaTrabalhoBkp);
                        }
                        catch (Exception ex) {
                            throw new ValidationException(String.format("Pasta de trabalho %s n\u00e3o encontrada. Opera\u00e7\u00e3o cancelada.", pastaTrabalho.getAbsolutePath()));
                        }
                    }
                    catch (Exception ex) {
                        log.add(ex.getMessage());
                    }
                    FinalizacaoDesenvolvimentoController.this.updateLogWebView(String.join((CharSequence)"\n", log));
                });
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    FinalizacaoDesenvolvimentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(FinalizacaoDesenvolvimentoController.this.anchorPane, this.getException().getMessage());
                    FinalizacaoDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    FinalizacaoDesenvolvimentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(FinalizacaoDesenvolvimentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    FinalizacaoDesenvolvimentoController.this.habilitaComponentes();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxDesenvolvimento.setDisable(disable);
            this.textAreaComentario.setDisable(disable);
            this.buttonSalvaDesenvolvimento.setDisable(disable);
        });
    }

    public void criaTaskAtualizacaoGrid() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                FinalizacaoDesenvolvimentoController.this.atualizaGrid();
                return null;
            }

            protected void succeeded() {
            }
        };
        Thread t = new Thread((Runnable)task);
        t.setDaemon(true);
        t.start();
    }

    private void eventoCliqueSol() {
        try {
            DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)this.comboBoxDesenvolvimento.getSelectionModel().getSelectedItem();
            if (desenvolvimentoForm == null) {
                throw new Exception("Selecione uma SOL");
            }
            AplicacaoForm aplicacaoForm = this.getConsumoRestSingleton().pesquisaAplicacao(desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia());
            List<StatusArquivoForm> listaArquivoNaoComitado = this.getDesenvolvimentoClientFachada().listaArquivoNaoComitado(this.getConfiguracaoSingleton().getLogin(), this.getConfiguracaoSingleton().getSenha(), aplicacaoForm, desenvolvimentoForm.getBranch(), this.getOutputStream());
            ObservableList data = FXCollections.observableArrayList(listaArquivoNaoComitado);
            Platform.runLater(() -> this.tableViewArquivo.setItems(data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void eventoCliqueArquivo() {
        try {
            int selecionado = this.tableViewArquivo.getSelectionModel().getSelectedIndex();
            if (selecionado < 0) {
                return;
            }
            StatusArquivoForm statusArquivoForm = (StatusArquivoForm)this.tableViewArquivo.getItems().get(selecionado);
            if (statusArquivoForm.getStatus().equals(SVNStatusType.STATUS_MODIFIED.toString().toUpperCase())) {
                this.updateLogWebView(String.join((CharSequence)"\n", this.getDesenvolvimentoClientFachada().diferencaArquivo(this.getConfiguracaoSingleton().getLogin(), this.getConfiguracaoSingleton().getSenha(), statusArquivoForm.getArquivo(), this.getOutputStream())));
            } else {
                this.updateLogWebView("Arquivo com " + statusArquivoForm.getArquivo() + " com " + statusArquivoForm.getStatus() + " n\u00e3o pode ser comparado");
            }
            this.textAreaLog.requestFocus();
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }
}

