/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;

public class DescarteDesenvolvimentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxDesenvolvimento;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.criaTaskAtualizacaoGrid();
        Platform.runLater(this::onShow);
    }

    private void atualizaCombo() {
        try {
            List<DesenvolvimentoForm> listaSolsAberto = this.getConsumoRestSingleton().listaSolsDesenvolvimento();
            ObservableList data = FXCollections.observableArrayList(listaSolsAberto);
            Platform.runLater(() -> {
                this.comboBoxDesenvolvimento.getItems().clear();
                this.comboBoxDesenvolvimento.getItems().addAll((Collection)data.stream().sorted(OrdenacaoLista.desenvolvimentoFormComparator).collect(Collectors.toList()));
                this.comboBoxDesenvolvimento.getSelectionModel().select(-1);
            });
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }

    public void buttonDescartarDesenvolvimentoAction(ActionEvent event) {
        try {
            DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)this.comboBoxDesenvolvimento.getSelectionModel().getSelectedItem();
            if (desenvolvimentoForm == null) {
                throw new Exception("Selecione uma SOL");
            }
        }
        catch (Exception ex) {
            this.endProcessLog();
            Platform.runLater(() -> MensagemView.getInstancia().mostraErro(this.anchorPane, ex.getMessage()));
        }
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)DescarteDesenvolvimentoController.this.comboBoxDesenvolvimento.getSelectionModel().getSelectedItem();
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                AplicacaoForm aplicacaoForm = DescarteDesenvolvimentoController.this.getConsumoRestSingleton().pesquisaAplicacao(desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia());
                LogUtils.generate((String)("##### Selecionado " + desenvolvimentoForm.getBranch()));
                DescarteDesenvolvimentoController.this.startProcessLog();
                Platform.runLater(() -> DescarteDesenvolvimentoController.this.clearLog());
                DescarteDesenvolvimentoController.this.criaTaskAtualizacaoLabel();
                List<String> log = DescarteDesenvolvimentoController.this.getDesenvolvimentoClientFachada().descarteDesenvolvimento(desenvolvimentoForm, aplicacaoForm, DescarteDesenvolvimentoController.this.getConfiguracaoSingleton(), DescarteDesenvolvimentoController.this.getOutputStream());
                try {
                    File pastaSistema = PastaUtil.getPastaTrabalho((String)desenvolvimentoForm.getLogin(), (String)aplicacaoForm.getServidorDesenvolvimento(), (String)"");
                    PastaUtil.moveBackupToConcluido((String)pastaSistema.getAbsolutePath());
                    File pastaTrabalho = PastaUtil.getPastaTrabalho((String)desenvolvimentoForm.getLogin(), (String)aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                    File pastaTrabalhoBkp = PastaUtil.getPastaTrabalhoDescartado((String)desenvolvimentoForm.getLogin(), (String)aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                    try {
                        FileUtils.move((File)pastaTrabalho, (File)pastaTrabalhoBkp);
                    }
                    catch (Exception ex) {
                        throw new ValidationException(String.format("Pasta de trabalho %s n\u00e3o encontrada. Opera\u00e7\u00e3o cancelada.", pastaTrabalho.getAbsolutePath()));
                    }
                }
                catch (Exception ex) {
                    log.add(ex.getMessage());
                }
                DescarteDesenvolvimentoController.this.updateLogWebView(String.join((CharSequence)"\n", log));
                DescarteDesenvolvimentoController.this.criaTaskAtualizacaoGrid();
                DescarteDesenvolvimentoController.this.endProcessLog();
                MensagemView.getInstancia().mostraSucesso(DescarteDesenvolvimentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    LogUtils.generate((Throwable)this.getException());
                    DescarteDesenvolvimentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(DescarteDesenvolvimentoController.this.anchorPane, this.getException().getMessage());
                    DescarteDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    DescarteDesenvolvimentoController.this.endProcessLog();
                    String mensagem = "Processamento Conclu\u00eddo com Sucesso";
                    MensagemView.getInstancia().mostraSucesso(DescarteDesenvolvimentoController.this.anchorPane, mensagem);
                    DescarteDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            protected void running() {
                DescarteDesenvolvimentoController.this.desabilitaComponentes();
            }
        };
        new Thread((Runnable)task).start();
    }

    public void criaTaskAtualizacaoGrid() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                DescarteDesenvolvimentoController.this.atualizaCombo();
                return null;
            }

            protected void succeeded() {
            }
        };
        Thread t = new Thread((Runnable)task);
        t.setDaemon(true);
        t.start();
    }

    private void onShow() {
        this.criaTaskAtualizacaoGrid();
        this.clearLog();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> this.comboBoxDesenvolvimento.setDisable(disable));
    }
}

