/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.util;

import br.com.dsfnet.gpd.fx.util.AmbienteUtils;
import br.com.jarch.util.SoftwareUtils;

public class AnalisaIdeDesenvolvimento {
    private static final String CRITICA_TORTOISESVN_ABERTO = "Para garantir a integridade do(s) arquivo(s) se faz necess\u00e1rio que o TORTOISESVN esteja FECHADO";
    private static final String CRITICA_ECLIPSE_ABERTO = "Para garantir a integridade do(s) arquivo(s) se faz necess\u00e1rio que o ECLIPSE esteja FECHADO";
    private static final String CRITICA_NETBEANS_ABERTO = "Para garantir a integridade do(s) arquivo(s) se faz necess\u00e1rio que o NETBEANS esteja FECHADO";
    private static final String CRITICA_INTELLIJ_IDEA_ABERTO = "Para garantir a integridade do(s) arquivo(s) se faz necess\u00e1rio que o INTELLIJ IDEA esteja FECHADO";
    private static final String VARIAVEL_AMBIENTE_GPD_CRITICA_PROG_IDE_ABERTO = "GPD_CRITICA_PROG_IDE_ABERTO";

    public static boolean existeAlgumaEmExecucao() throws Exception {
        if (AnalisaIdeDesenvolvimento.descartaCritica()) {
            return false;
        }
        try {
            if (AmbienteUtils.isWindows()) {
                AnalisaIdeDesenvolvimento.verificaIdeWindows();
            } else {
                AnalisaIdeDesenvolvimento.verificaIdeLinux();
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    private static void verificaIdeLinux() throws Exception {
        if (SoftwareUtils.runningLinux((String)"intellij")) {
            throw new Exception(CRITICA_INTELLIJ_IDEA_ABERTO);
        }
        if (SoftwareUtils.runningLinux((String)"eclipse")) {
            throw new Exception(CRITICA_ECLIPSE_ABERTO);
        }
        if (SoftwareUtils.runningLinux((String)"netbeans")) {
            throw new Exception(CRITICA_NETBEANS_ABERTO);
        }
    }

    private static void verificaIdeWindows() throws Exception {
        if (SoftwareUtils.runningWindows((String)"intellij.exe")) {
            throw new Exception(CRITICA_INTELLIJ_IDEA_ABERTO);
        }
        if (SoftwareUtils.runningWindows((String)"eclipse.exe")) {
            throw new Exception(CRITICA_ECLIPSE_ABERTO);
        }
        if (SoftwareUtils.runningWindows((String)"netbeans.exe")) {
            throw new Exception(CRITICA_NETBEANS_ABERTO);
        }
        if (SoftwareUtils.runningWindows((String)"tortoiseproc.exe")) {
            throw new Exception(CRITICA_TORTOISESVN_ABERTO);
        }
    }

    private static boolean descartaCritica() {
        String critica = System.getenv(VARIAVEL_AMBIENTE_GPD_CRITICA_PROG_IDE_ABERTO);
        return critica != null && critica.equals("N");
    }
}

