/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.fachada;

import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.svn.DesenvolvimentoSvn;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.fx.util.ConfiguracaoSingleton;
import br.com.dsfnet.gpd.fx.util.ConsumoRestSingleton;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.svn.SvnFachada;
import jakarta.inject.Inject;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class DesenvolvimentoClientFachada {
    @Inject
    private ConsumoRestSingleton consumoRestSingleton;
    @Inject
    private DesenvolvimentoSvn desenvolvimentoSvn;

    public void validaInicioDesenvolvimento(String login, String branch, String cliente, String sistema, TecnologiaType tecnologia, AplicacaoForm aplicacaoForm) throws Exception {
        this.consumoRestSingleton.validaInicioDesenvolvimento(branch, cliente, sistema, tecnologia, login);
    }

    public List<String> inicioDesenvolvimento(String servidorSvn, String login, String senha, String branch, String cliente, String sistema, TecnologiaType tecnologia, AplicacaoForm aplicacaoForm, boolean mergeTrunk, OutputStream outputStream) throws Exception {
        this.consumoRestSingleton.validaInicioDesenvolvimento(branch, cliente, sistema, tecnologia, login);
        List log = this.desenvolvimentoSvn.inicioDesenvolvimento(servidorSvn, login, senha, branch, aplicacaoForm, mergeTrunk, outputStream);
        this.consumoRestSingleton.atualizaBancoDadosInicioDesenvolvimento(branch, cliente, sistema, tecnologia, login);
        return log;
    }

    public List<String> descarteDesenvolvimento(DesenvolvimentoForm desenvolvimentoForm, AplicacaoForm aplicacaoForm, ConfiguracaoSingleton configuracaoSingleton, OutputStream outputStream) throws Exception {
        this.consumoRestSingleton.validaDescarteDesenvolvimento(desenvolvimentoForm.getId(), configuracaoSingleton.getLogin());
        List log = this.desenvolvimentoSvn.descarte(desenvolvimentoForm.getLogin(), desenvolvimentoForm.getSenha(), aplicacaoForm.getServidorDesenvolvimento(), desenvolvimentoForm.getBranch(), outputStream);
        this.consumoRestSingleton.atualizaBancoDadosDescarteDesenvolvimento(desenvolvimentoForm.getId());
        boolean existeFinalizado = RemoteFactory.getInstance().getProcessamento().existeDesenvolvimentoFinalizado(aplicacaoForm.getProjetoSvn(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getBranch());
        if (existeFinalizado) {
            return log;
        }
        boolean existeDesenvolvilmentoBloqueado = RemoteFactory.getInstance().getProcessamento().existeDesenvolvimentoIniciado(aplicacaoForm.getProjetoSvn(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getBranch());
        if (existeDesenvolvilmentoBloqueado) {
            return log;
        }
        URL urlBranch = PastaUtil.getUrlBranch((String)configuracaoSingleton.getServidorSvn(), (String)aplicacaoForm.getProjetoSvn(), (String)desenvolvimentoForm.getBranch());
        SvnFachada svnFachada = new SvnFachada(configuracaoSingleton.getLogin(), configuracaoSingleton.getSenha(), outputStream);
        svnFachada.delete(urlBranch, "Desenvolvimento iniciado e descartado...");
        return log;
    }

    public List<String> salvaDesenvolvimento(String servidorSvn, DesenvolvimentoForm form, AplicacaoForm aplicacaoForm, Collection<String> listaArquivoIgnorar, OutputStream outputStream) throws Exception {
        this.consumoRestSingleton.validaSalvaDesenvolvimento(form.getId(), form.getComentario());
        this.desenvolvimentoSvn.validacaoWorkingCopyBranch(servidorSvn, aplicacaoForm.getProjetoSvn(), form.getLogin(), form.getSenha(), aplicacaoForm.getServidorDesenvolvimento(), form.getBranch(), outputStream);
        List log = this.desenvolvimentoSvn.salvaDesenvolvimento(servidorSvn, aplicacaoForm.getProjetoSvn(), form.getLogin(), form.getSenha(), aplicacaoForm.getServidorDesenvolvimento(), form.getBranch(), listaArquivoIgnorar, form.getComentario(), outputStream);
        this.consumoRestSingleton.atualizaBancoDadosSalvaDesenvolvimento(form.getId());
        return log;
    }

    public List<String> finalizaDesenvolvimento(String servidorSvn, DesenvolvimentoForm desenvolvimentoForm, AplicacaoForm aplicacaoForm, OutputStream outputStream) throws Exception {
        this.consumoRestSingleton.validaFinalizaDesenvolvimento(desenvolvimentoForm);
        this.desenvolvimentoSvn.validacaoWorkingCopyBranch(servidorSvn, aplicacaoForm.getProjetoSvn(), desenvolvimentoForm.getLogin(), desenvolvimentoForm.getSenha(), aplicacaoForm.getServidorDesenvolvimento(), desenvolvimentoForm.getBranch(), outputStream);
        List log = this.desenvolvimentoSvn.finalizaDesenvolvimento(servidorSvn, desenvolvimentoForm, aplicacaoForm, null, outputStream);
        this.consumoRestSingleton.atualizaBancoDadosFinalizaDesenvolvimento(desenvolvimentoForm.getId());
        return log;
    }

    public void criaColunasTableViewSol(TableView tableView) {
        TableColumn branch = new TableColumn();
        branch.setText("Branch");
        branch.setCellValueFactory((Callback)new PropertyValueFactory("branch"));
        branch.setMinWidth(70.0);
        TableColumn cliente = new TableColumn();
        cliente.setText("Cliente");
        cliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        cliente.setMinWidth(70.0);
        TableColumn sistema = new TableColumn();
        sistema.setText("Sistema");
        sistema.setCellValueFactory((Callback)new PropertyValueFactory("sistema"));
        sistema.setMinWidth(150.0);
        TableColumn tecnologia = new TableColumn();
        tecnologia.setText("Tecnologia");
        tecnologia.setCellValueFactory((Callback)new PropertyValueFactory("tecnologia"));
        tecnologia.setMinWidth(90.0);
        TableColumn dataInicio = new TableColumn();
        dataInicio.setText("Data Inicio");
        dataInicio.setCellValueFactory((Callback)new PropertyValueFactory("dataInicio"));
        dataInicio.setMinWidth(90.0);
        TableColumn descricaoSol = new TableColumn();
        descricaoSol.setText("Descri\u00e7\u00e3o Branch");
        descricaoSol.setCellValueFactory((Callback)new PropertyValueFactory("descricaoSol"));
        descricaoSol.setMinWidth(500.0);
        tableView.getColumns().addAll(new Object[]{branch, cliente, sistema, tecnologia, dataInicio, descricaoSol});
    }

    public void criaColunasTableViewArquivo(TableView tableView) {
        TableColumn check = new TableColumn();
        check.setText("Ignora");
        check.setCellValueFactory((Callback)new PropertyValueFactory("ignora"));
        check.setMinWidth(50.0);
        check.setCellFactory(p -> new CheckBoxTableCell());
        check.setVisible(false);
        TableColumn status = new TableColumn();
        status.setText("Status");
        status.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        status.setMinWidth(150.0);
        TableColumn arquivo = new TableColumn();
        arquivo.setText("Arquivo");
        arquivo.setCellValueFactory((Callback)new PropertyValueFactory("arquivo"));
        arquivo.setMinWidth(790.0);
        tableView.getColumns().addAll(new Object[]{check, status, arquivo});
    }

    public List<StatusArquivoForm> listaArquivoNaoComitado(String login, String senha, AplicacaoForm aplicacaoForm, String branch, OutputStream outputStream) throws Exception {
        return this.desenvolvimentoSvn.listaArquivoNaoComitado(login, senha, aplicacaoForm, branch, outputStream);
    }

    public List<String> diferencaArquivo(String login, String senha, String arquivo, OutputStream outputStream) throws Exception {
        return this.desenvolvimentoSvn.diferencaArquivo(login, senha, arquivo, outputStream);
    }
}

