/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.util;

import br.com.jarch.util.LogUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class RequestHttpUtils {
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-type";
    public static final int CONTENT_LENGTH = 5000;
    public static final int CONNECT_TIMEOUT = 60000;

    public static void main(String[] args) {
        try {
            String retorno = RequestHttpUtils.getUrl("https://kanbanflow.com/api/v1/tasks?apiToken=e684cc66012011522f90eb9d41d93da8");
            LogUtils.generate((String)retorno);
        }
        catch (IOException ex) {
            Logger.getLogger(RequestHttpUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getUrl(URL url) throws IOException {
        return RequestHttpUtils.processaUrl(url, MetodoType.GET, null);
    }

    public static String getUrl(String value) throws IOException {
        String url = value.replace(" ", "+");
        return RequestHttpUtils.processaUrl(new URL(url), MetodoType.GET, null);
    }

    public static String getUrl(URL url, Map<String, Object> parametros) throws IOException {
        return RequestHttpUtils.processaUrl(url, MetodoType.GET, parametros);
    }

    public static String getUrl(String value, Map<String, Object> parametros) throws IOException {
        String url = value.replace(" ", "+");
        return RequestHttpUtils.processaUrl(new URL(url), MetodoType.GET, parametros);
    }

    public static String postUrl(String value) throws IOException {
        String url = value.replace(" ", "+");
        return RequestHttpUtils.processaUrl(new URL(url), MetodoType.POST, null);
    }

    public static String postUrl(URL url) throws IOException {
        return RequestHttpUtils.processaUrl(url, MetodoType.POST, null);
    }

    public static String postUrl(String value, Map<String, Object> parametros) throws IOException {
        String url = value.replace(" ", "+");
        return RequestHttpUtils.processaUrl(new URL(url), MetodoType.POST, parametros);
    }

    public static String postUrl(URL url, Map<String, Object> parametros) throws IOException {
        return RequestHttpUtils.processaUrl(url, MetodoType.POST, parametros);
    }

    private static String processaUrl(URL url, MetodoType metodoType, Map<String, Object> parametros) throws IOException {
        String linha;
        LogUtils.start();
        LogUtils.generate((String)url.toString());
        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
        HttpURLConnection.setFollowRedirects(false);
        huc.setDoInput(true);
        huc.setDoOutput(true);
        huc.setUseCaches(false);
        System.setProperty("http.keepAlive", "false");
        huc.setRequestProperty("Content-length", String.valueOf(5000));
        huc.setConnectTimeout(60000);
        huc.setReadTimeout(60000);
        huc.setRequestMethod(metodoType.name());
        if (parametros != null) {
            Set<String> chaves = parametros.keySet();
            LogUtils.generate((String)"Parametros");
            for (String chave : chaves) {
                Object conteudo = parametros.get(chave);
                huc.addRequestProperty(chave, conteudo.toString());
                LogUtils.generate((String)("   Chave: " + chave + " Conteudo: " + String.valueOf(conteudo)));
            }
        }
        LogUtils.generate((String)"Conectando");
        huc.connect();
        LogUtils.generate((String)"Conectado");
        InputStream input = huc.getInputStream();
        InputStreamReader inputReader = new InputStreamReader(input);
        BufferedReader bufferedReader = new BufferedReader(inputReader);
        LogUtils.generate((String)"**** RETORNO DA PAGINA WEB ****");
        StringBuilder sbRetorno = new StringBuilder();
        while ((linha = bufferedReader.readLine()) != null) {
            LogUtils.generate((String)linha);
            sbRetorno.append(linha);
        }
        LogUtils.generate((String)"Fim");
        return sbRetorno.toString();
    }

    public static <T> T processaGet(URL url, Object objeto, Class<T> classeRetorno) throws IOException {
        return RequestHttpUtils.processaRequisicao(MetodoType.GET, url, objeto, classeRetorno);
    }

    public static <T> T processaPost(URL url, Object objeto, Class<T> classeRetorno) throws IOException {
        return RequestHttpUtils.processaRequisicao(MetodoType.POST, url, objeto, classeRetorno);
    }

    private static <T> T processaRequisicao(MetodoType metodoType, URL url, Object objeto, Class<T> classeRetorno) throws IOException {
        String line;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(metodoType.name());
        connection.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
        connection.setUseCaches(false);
        if (objeto != null) {
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            ObjectMapper mapper = new ObjectMapper();
            StringWriter strWriter = new StringWriter();
            mapper.writeValue((Writer)strWriter, objeto);
            String stringJSON = ((Object)strWriter).toString();
            wr.writeBytes(stringJSON);
            wr.flush();
            wr.close();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder stringBuilderJson = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            stringBuilderJson.append(line);
        }
        rd.close();
        connection.disconnect();
        if (classeRetorno == String.class) {
            return (T)stringBuilderJson.toString();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(stringBuilderJson.toString(), classeRetorno);
    }

    static enum MetodoType {
        GET,
        POST;

    }
}

