/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.util;

import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.AutenticacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.jarch.core.cdi.GlobalInformation;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import java.text.SimpleDateFormat;

public class Factory {
    @Produces
    @Named(value="loginSvn")
    public String loginSvn() {
        String retorno = "";
        try {
            AutenticacaoForm autenticacaoForm = (AutenticacaoForm)GlobalInformation.getInstance().get("autenticacao");
            if (autenticacaoForm != null) {
                return autenticacaoForm.getLogin();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retorno;
    }

    @Produces
    @Named(value="senhaSvn")
    public String senhaSvn() {
        String retorno = "";
        try {
            AutenticacaoForm autenticacaoForm = (AutenticacaoForm)GlobalInformation.getInstance().get("autenticacao");
            if (autenticacaoForm != null) {
                return autenticacaoForm.getSenha();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retorno;
    }

    public static AplicacaoForm getAplicacaoForm(SistemaEntity aplicacao) {
        AplicacaoForm aplicacaoForm = new AplicacaoForm();
        aplicacaoForm.setId(aplicacao.getId());
        aplicacaoForm.setProjetoSvn(aplicacao.getProjetoSvn());
        aplicacaoForm.setPacotesValido(aplicacao.getPacotes());
        aplicacaoForm.setServidorDesenvolvimento(aplicacao.getServidorDesenvolvimento());
        aplicacaoForm.setTecnologia(aplicacao.getTecnologia());
        return aplicacaoForm;
    }

    public static DesenvolvimentoForm getDesenvolvimentoForm(DesenvolvimentoEntity desenvolvimentoEntity, String login) {
        DesenvolvimentoForm form = new DesenvolvimentoForm();
        form.setId(desenvolvimentoEntity.getId());
        form.setCliente(desenvolvimentoEntity.getSistemaEntity().getCliente());
        form.setDataInicio(new SimpleDateFormat("dd/MM/yyyy").format(desenvolvimentoEntity.getInicio()));
        form.setBranch(desenvolvimentoEntity.getNumeroSol().toString());
        form.setSistema(desenvolvimentoEntity.getSistemaEntity().getSistema());
        form.setTecnologia(desenvolvimentoEntity.getSistemaEntity().getTecnologia());
        return form;
    }
}

