/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.usuario;

import br.com.dsfnet.gpd.client.exception.LoginException;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.model.IUser;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Collection;

@JArchService
public class UsuarioService
extends CrudService<UsuarioEntity, UsuarioRepository> {
    public static UsuarioService getInstance() {
        return (UsuarioService)((Object)CDI.current().select(UsuarioService.class, new Annotation[0]).get());
    }

    public UsuarioEntity pesquisaLogin(String login) {
        return ((UsuarioRepository)this.getRepository()).pesquisaLogin(login);
    }

    public Collection<UsuarioEntity> listaTodosUsuarios() {
        return ((UsuarioRepository)this.getRepository()).searchAll();
    }

    public IUser efetuaLogin(String login, String senha) throws Exception {
        if (login == null || login.isEmpty()) {
            throw new LoginException("Login obrigat\u00f3rio");
        }
        if (senha == null || senha.isEmpty()) {
            throw new LoginException("Senha obrigat\u00f3rio");
        }
        UsuarioEntity usuario = this.pesquisaLogin(login);
        if (senha != null && !usuario.senhaValida(senha)) {
            throw new LoginException("Senha inv\u00e1lida !");
        }
        return usuario;
    }

    public void validaLoginWebService(String login, String senha) throws Exception {
        UsuarioEntity usuario = this.pesquisaLogin(login);
        if (usuario.getSenha() == null) {
            throw new Exception("Primeiro Acesso");
        }
        if (usuario.senhaValida(senha)) {
            throw new Exception("Senha inv\u00e1lida");
        }
    }

    public void atualizaSenha(String login, String novaSenha) {
        ((UsuarioRepository)this.getRepository()).atualizaSenha(login, novaSenha);
    }

    public void incluiSeNaoExistir(String login) {
        ((UsuarioRepository)this.getRepository()).incluiSeNaoExistir("administrador");
    }

    public void atualizaUltimoAcesso(UsuarioEntity usuario) {
        ((UsuarioRepository)this.getRepository()).atualizaUltimoAcesso(usuario.getId());
    }
}

