/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.usuario;

import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.annotation.JArchLookup;
import br.com.jarch.core.annotation.JArchValidExclusive;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.entity.CrudEntity;
import br.com.jarch.core.model.IUser;
import br.com.jarch.util.Md5Utils;
import jakarta.enterprise.inject.Alternative;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.List;

@Alternative
@Table(name="tb_usuario")
@Entity(name="usuario")
@JArchLookup(codeAttribute="login", descriptionAttribute="nome")
@SequenceGenerator(name="UsuarioIdSequence", sequenceName="sq_idusuario", allocationSize=1)
@JArchConfiguration(generateFilterSelection=false, generateDataDetail=false)
public class UsuarioEntity
extends CrudEntity
implements IUser {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="UsuarioIdSequence")
    @Column(name="id_usuario")
    private Long id;
    @JArchValidExclusive
    @Column(name="nm_login")
    @JArchValidRequired(value="label.login")
    private String login;
    @Column(name="nm_nome")
    @JArchValidRequired(value="label.nome")
    private String nome;
    @Column(name="cn_senha")
    private String senha;
    @Column(name="dh_ultimoAcesso")
    private Date ultimoAcesso;
    @Transient
    private List<String> grupo;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Date getUltimoAcesso() {
        return this.ultimoAcesso;
    }

    public void setUltimoAcesso(Date ultimoAcesso) {
        this.ultimoAcesso = ultimoAcesso;
    }

    public boolean senhaValida(String senha) {
        if (senha == null) {
            senha = "";
        }
        if (this.senha == null) {
            return true;
        }
        return this.senha.equals(Md5Utils.generate((String)senha));
    }
}

