/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.svn;

import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoSolEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.svn.BibliotecaSvn;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.jarch.svn.SvnFachada;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;

public class EmpacotamentoSvn {
    public void criacaoEmpacotamento(String servidorSvn, String loginSvn, String senhaSvn, PlanejamentoEntity planejamento, List<String> log, OutputStream outputStream) throws EmpacotamentoException {
        try {
            SistemaEntity aplicacao = planejamento.getSistemaEntity();
            String versao = planejamento.getVersao();
            String projetoSvn = aplicacao.getProjetoSvn();
            String servidorEmpacotamento = aplicacao.getServidorEmpacotamento();
            URL urlTrunk = PastaUtil.getUrlTrunk(servidorSvn, projetoSvn);
            URL urlVersao = PastaUtil.getUrlBranch(servidorSvn, projetoSvn, versao);
            File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, servidorEmpacotamento, planejamento.getVersao());
            if (pastaTrabalho.exists()) {
                PastaUtil.remover(pastaTrabalho);
            }
            SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
            svnFachada.checkout(urlTrunk, pastaTrabalho);
            if (svnFachada.existeRepositorio(urlVersao)) {
                svnFachada.delete(urlVersao, "EMPACOTAMENTO VERSAO " + versao);
            }
            svnFachada.copy(urlTrunk, urlVersao, "EMPACOTAMENTO - COPIA TRUNK PARA BRANCH");
            if (aplicacao.getTecnologia() == TecnologiaType.JAVA) {
                BibliotecaSvn bibliotecaSvn = new BibliotecaSvn();
                bibliotecaSvn.baixaBiblioteca(servidorSvn, loginSvn, senhaSvn);
            }
            log.addAll(svnFachada.getLog());
        }
        catch (Exception ex) {
            throw new EmpacotamentoException(ex.getMessage());
        }
    }

    public void iniciaEmpacotamento(String servidorSvn, String loginSvn, String senhaSvn, PlanejamentoSolEntity planejamentoSol, List<String> log, OutputStream outputStream) throws Exception {
        try {
            SistemaEntity aplicacao = planejamentoSol.getPlanejamentoEntity().getSistemaEntity();
            String versao = planejamentoSol.getPlanejamentoEntity().getVersao();
            String projetoSvn = aplicacao.getProjetoSvn();
            String servidorEmpacotamento = aplicacao.getServidorEmpacotamento();
            URL urlVersao = PastaUtil.getUrlBranch(servidorSvn, projetoSvn, versao);
            File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, servidorEmpacotamento, versao);
            SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
            svnFachada.switchSvn(urlVersao, pastaTrabalho);
            String numeroSol = planejamentoSol.getNumeroSol();
            URL urlSol = PastaUtil.getUrlBranch(servidorSvn, projetoSvn, numeroSol.toString());
            svnFachada.merge(urlSol, pastaTrabalho);
            log.addAll(svnFachada.getLog());
        }
        catch (IOException ex) {
            throw new EmpacotamentoException(ex.getMessage());
        }
    }

    public void verificaConflito(String loginSvn, String senhaSvn, SistemaEntity aplicacao, String branch, OutputStream outputStream) throws Exception {
        SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
        String servidorEmpacotamento = aplicacao.getServidorEmpacotamento();
        File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, servidorEmpacotamento, branch);
        svnFachada.verificaConflito(pastaTrabalho);
    }

    public void finalizaEmpacotamento(String servidorSvn, String loginSvn, String senhaSvn, EmpacotamentoEntity empacotamento, Collection<String> listaArquivoIgnorar, List<String> log, OutputStream outputStream) throws Exception {
        try {
            String projetoSvn = empacotamento.getSistemaEntity().getProjetoSvn();
            String servidorEmpacotamento = empacotamento.getSistemaEntity().getServidorEmpacotamento();
            URL urlVersao = PastaUtil.getUrlBranch(servidorSvn, projetoSvn, empacotamento.getVersao());
            File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, servidorEmpacotamento, empacotamento.getVersao());
            SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
            svnFachada.commit(urlVersao, pastaTrabalho, listaArquivoIgnorar, "FIM DO EMPACOTAMENTO DA SOL: " + empacotamento.getNumeroSol());
            log.addAll(svnFachada.getLog());
        }
        catch (IOException ex) {
            throw new EmpacotamentoException(ex.getMessage());
        }
    }

    public void fechaEmpacotamento() throws EmpacotamentoException {
    }
}

