/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.sistema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public enum AmbienteType {
    DEV("DEV", "Desenvolvimento"),
    HML("HML", "Homologa\u00e7\u00e3o"),
    POC("POC", "POC"),
    PPR("PREPRD", "Pr\u00e9 Produ\u00e7\u00e3o"),
    PRD("PRD", "Produ\u00e7\u00e3o");

    private final String abbreviation;
    private final String description;

    private AmbienteType(String abbreviation, String description) {
        this.abbreviation = abbreviation;
        this.description = description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getDescription() {
        return this.description;
    }

    public static AmbienteType abbreviationToEnum(String abbreviation) {
        return Arrays.stream(AmbienteType.values()).filter(m -> m.getAbbreviation().equals(abbreviation)).findAny().orElse(null);
    }

    public static AmbienteType descriptionToEnum(String description) {
        return Arrays.stream(AmbienteType.values()).filter(m -> m.getDescription().equals(description)).findAny().orElse(null);
    }

    public static Collection<AmbienteType> getCollection() {
        return Arrays.stream(AmbienteType.values()).collect(Collectors.toCollection(ArrayList::new));
    }

    public String toString() {
        return this.getDescription();
    }
}

