/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.qualidade;

import br.com.dsfnet.gpd.client.qualidade.QualidadeEntity;
import br.com.dsfnet.gpd.client.qualidade.QualidadeRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class QualidadeDao
extends CrudDao<QualidadeEntity>
implements QualidadeRepository {
    @Override
    @Transactional
    public void bloquear(String cliente, String produto, TecnologiaType tecnologia, String numeroSol, String login) {
        SistemaEntity sistemaEntity = SistemaRepository.getInstance().pesquisar(cliente, produto, tecnologia);
        UsuarioEntity usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(login);
        QualidadeEntity qualidade = new QualidadeEntity();
        qualidade.setNumeroSol(numeroSol);
        qualidade.setSistemaEntity(sistemaEntity);
        qualidade.setStatus(StatusType.BLOQUEADO);
        qualidade.setInicio(new Date());
        qualidade.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().persist((Object)qualidade);
    }

    @Override
    public void liberar(Long id) {
        QualidadeEntity qualidade = (QualidadeEntity)this.find(id);
        qualidade.setStatus(StatusType.LIBERADO);
        qualidade.setFim(new Date());
    }

    @Override
    public void descartar(Long id) {
        QualidadeEntity qualidade = (QualidadeEntity)this.find(id);
        qualidade.setStatus(StatusType.DESCARTADO);
        qualidade.setFim(new Date());
    }

    @Override
    public List<QualidadeEntity> listaBloqueado(String sistema, String projetoSvn) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM QualidadeEntity ad WHERE ad.sistemaEntity.sistema = :sistema AND \t   ad.sistemaEntity.projetoSvn = :projetoSvn AND       ad.fim IS NULL");
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("projetoSvn", (Object)projetoSvn);
        return CollectionUtils.transform(QualidadeEntity.class, (Collection)query.getResultList());
    }

    @Override
    public List<QualidadeEntity> listaSolServidor() {
        Query query = this.getEntityManager().createQuery("SELECT q FROM QualidadeEntity q JOIN FETCH q.sistemaEntity apl JOIN FETCH q.usuarioEntity usu WHERE q.numeroSol IS NOT NULL AND       NOT EXISTS( SELECT 0                   FROM QualidadeEntity x                   WHERE x.sistemaEntity.id = q.sistemaEntity.id AND                         x.id > q.id) ORDER BY q.inicio DESC");
        List lista = CollectionUtils.transform(QualidadeEntity.class, (Collection)query.getResultList());
        return lista;
    }

    @Override
    public List<String> listaSolBloqueado(String login) {
        Query query = this.getEntityManager().createQuery("SELECT q.numeroSol FROM QualidadeEntity q WHERE q.fim IS NULL AND       q.usuarioEntity.login = :login ORDER BY q.numeroSol");
        query.setParameter("login", (Object)login);
        return CollectionUtils.transform(String.class, (Collection)query.getResultList());
    }

    @Override
    public Set<QualidadeEntity> listaBloqueado(String login) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(QualidadeEntity.class);
        Root root = criteria.from(QualidadeEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereLogin = builder.equal((Expression)root.join("usuarioEntity").get("login"), (Object)login);
        criteria.where(new Predicate[]{whereFim, whereLogin});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<QualidadeEntity> listaRetorno = new TreeSet<QualidadeEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public boolean bloqueado(Long aplicacaoId, String branch) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(QualidadeEntity.class);
        Root root = criteria.from(QualidadeEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereSol = builder.equal((Expression)root.get("numeroSol"), (Object)branch);
        criteria.where(new Predicate[]{whereAplicacao, whereSol, whereFim});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        return lista.size() > 0;
    }

    @Override
    public List<QualidadeEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(QualidadeEntity.class);
        Root root = criteria.from(QualidadeEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }
}

