/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.publicacao;

import br.com.dsfnet.gpd.client.aceite.AceiteRepository;
import br.com.dsfnet.gpd.client.publicacao.PublicacaoEntity;
import br.com.dsfnet.gpd.client.publicacao.PublicacaoRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.StatusPublicacaoType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import br.com.jarch.util.LogUtils;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class PublicacaoDao
extends CrudDao<PublicacaoEntity>
implements PublicacaoRepository {
    @Override
    @Transactional
    public void incluir(VersionamentoEntity versionamento, String login) {
        SistemaEntity aplicacao = (SistemaEntity)SistemaRepository.getInstance().find(versionamento.getSistemaEntity().getId());
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        PublicacaoEntity publicacao = new PublicacaoEntity();
        publicacao.setTag(versionamento.getTag());
        publicacao.setSistemaEntity(aplicacao);
        publicacao.setData(new Date());
        publicacao.setStatus(StatusPublicacaoType.PUBLICADO);
        publicacao.setUsuarioEntity(usuario);
        this.gravaTagDesmembrado(publicacao);
        this.getEntityManager().persist((Object)publicacao);
    }

    @Override
    @Transactional
    public void cancelar(Long id, String login) {
        PublicacaoEntity publicacao = (PublicacaoEntity)this.find(id);
        UsuarioEntity usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(login);
        publicacao.setStatus(StatusPublicacaoType.CANCELADO);
        publicacao.setDataCancelamento(new Date());
        publicacao.setUsuarioCancelamentoEntity(usuarioEntity);
        this.getEntityManager().merge((Object)publicacao);
        VersionamentoEntity versionamentoEntity = VersionamentoRepository.getInstance().pesquisar(publicacao.getSistemaEntity().getId(), publicacao.getTag());
        VersionamentoRepository.getInstance().descartar(versionamentoEntity.getId(), login);
        AceiteRepository.getInstance().descartar(publicacao.getSistemaEntity().getCliente(), publicacao.getSistemaEntity().getSistema(), publicacao.getSistemaEntity().getTecnologia(), versionamentoEntity.getVersao(), AmbienteType.PRODUCAO);
    }

    @Override
    public List<PublicacaoEntity> listaVersaoServidor() {
        Query query = this.getEntityManager().createQuery("SELECT p FROM PublicacaoEntity p JOIN FETCH p.sistemaEntity pl JOIN FETCH p.usuarioEntity usu WHERE p.data IS NOT NULL AND       NOT EXISTS( SELECT 0                   FROM PublicacaoEntity x                   WHERE x.sistemaEntity.id = p.sistemaEntity.id AND                         x.id > p.id) ORDER BY p.data DESC");
        List lista = CollectionUtils.transform(PublicacaoEntity.class, (Collection)query.getResultList());
        return lista;
    }

    @Override
    public Set<PublicacaoEntity> listaPublicacao() {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PublicacaoEntity.class);
        Root root = criteria.from(PublicacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereStatus = builder.equal((Expression)root.get("status"), (Object)StatusPublicacaoType.PUBLICADO);
        criteria.where((Expression)whereStatus);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.orderBy(new Order[]{orderById});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<PublicacaoEntity> listaRetorno = new TreeSet<PublicacaoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public List<PublicacaoEntity> pesquisaTagAplicacao(String tag, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PublicacaoEntity.class);
        Root root = criteria.from(PublicacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereTag = builder.equal((Expression)root.get("tag"), (Object)tag);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereTag, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<PublicacaoEntity> pesquisaTagAplicacao(List<String> listaTag, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PublicacaoEntity.class);
        Root root = criteria.from(PublicacaoEntity.class);
        criteria.select((Selection)root);
        Predicate[] wheresOr = new Predicate[listaTag.size()];
        int i = 0;
        for (String tag : listaTag) {
            wheresOr[i++] = builder.equal((Expression)root.get("tag"), (Object)tag);
        }
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereAplicacao, builder.or(wheresOr)});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    @Transactional
    public void ajustaTags() {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PublicacaoEntity.class);
        Root root = criteria.from(PublicacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereTag1 = builder.isNull((Expression)root.get("tagVersao1"));
        Predicate whereTag2 = builder.isNull((Expression)root.get("tagVersao2"));
        Predicate whereTag3 = builder.isNull((Expression)root.get("tagVersao3"));
        Predicate whereTag4 = builder.isNull((Expression)root.get("tagVersao4"));
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereTag1, whereTag2, whereTag3, whereTag4});
        criteria.orderBy(new Order[]{orderById});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        for (PublicacaoEntity publicacao : lista) {
            this.gravaTagDesmembrado(publicacao);
            this.getEntityManager().merge((Object)publicacao);
        }
    }

    private void gravaTagDesmembrado(PublicacaoEntity publicacao) {
        String tag = publicacao.getTag();
        if (tag == null || tag.isEmpty() || tag.contains("antigo")) {
            LogUtils.generate((String)("##### PULANDO TAG #### " + tag));
            return;
        }
        LogUtils.generate((String)("##### TAG #### " + tag));
        long tagVersao1 = Long.parseLong(tag.substring(0, tag.indexOf(".")));
        tag = tag.substring(tag.indexOf(".") + 1);
        long tagVersao2 = Long.parseLong(tag.substring(0, tag.indexOf(".")));
        tag = tag.substring(tag.indexOf(".") + 1);
        long tagVersao3 = Long.parseLong(tag.substring(0, tag.indexOf(".")));
        tag = tag.substring(tag.indexOf(".") + 1);
        long tagVersao4 = Long.parseLong(tag);
        LogUtils.generate((String)("Tag: " + publicacao.getTag() + " - Desmembrado: " + tagVersao1 + "." + tagVersao2 + "." + tagVersao3 + "." + tagVersao4));
        publicacao.setTagVersao1(tagVersao1);
        publicacao.setTagVersao2(tagVersao2);
        publicacao.setTagVersao3(tagVersao3);
        publicacao.setTagVersao4(tagVersao4);
    }
}

