/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.form;

import br.com.dsfnet.gpd.client.sistema.AmbienteType;
import br.com.dsfnet.gpd.client.sistema.DadosPublicacaoEntity;
import br.com.dsfnet.gpd.client.sistema.LocalType;
import br.com.dsfnet.gpd.client.sistema.ModuloType;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.StringUtils;
import java.time.LocalDateTime;

public class PublicacaoForm {
    private LocalType local;
    private AmbienteType ambiente;
    private ModuloType modulo;
    private String artefato;
    private String nomeAlternativo;
    private String servidor;
    private int porta;
    private String no;
    private String pastaServidor;
    private String comandoAntesCompilacao;
    private String comandoAposPublicacao;
    private boolean servidorContingencia;
    private boolean acessivel = true;

    public PublicacaoForm(DadosPublicacaoEntity dadosPublicacao) {
        this.local = dadosPublicacao.getLocal();
        this.ambiente = dadosPublicacao.getAmbiente();
        this.modulo = dadosPublicacao.getModulo();
        this.artefato = dadosPublicacao.getArtefato();
        this.servidor = dadosPublicacao.getIpServidor();
        this.porta = dadosPublicacao.getPorta() == null ? 22 : dadosPublicacao.getPorta();
        this.no = StringUtils.nullAsBlank((Object)dadosPublicacao.getNo());
        this.pastaServidor = dadosPublicacao.getPathServidor();
        this.comandoAntesCompilacao = StringUtils.nullAsBlank((Object)dadosPublicacao.getComandoAntesCompilacao());
        this.comandoAposPublicacao = StringUtils.nullAsBlank((Object)dadosPublicacao.getComandoReiniciarServidor());
        this.servidorContingencia = dadosPublicacao.getContingencia();
    }

    public LocalType getLocal() {
        return this.local;
    }

    public void setLocal(LocalType local) {
        this.local = local;
    }

    public AmbienteType getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(AmbienteType ambiente) {
        this.ambiente = ambiente;
    }

    public ModuloType getModulo() {
        return this.modulo;
    }

    public void setModulo(ModuloType modulo) {
        this.modulo = modulo;
    }

    public String getArtefato() {
        return this.artefato;
    }

    public void setArtefato(String artefato) {
        this.artefato = artefato;
    }

    public String getNomeAlternativo() {
        return this.nomeAlternativo;
    }

    public void setNomeAlternativo(String nomeAlternativo) {
        this.nomeAlternativo = nomeAlternativo;
    }

    public String getServidor() {
        return this.servidor;
    }

    public void setServidor(String servidor) {
        this.servidor = servidor;
    }

    public int getPorta() {
        return this.porta;
    }

    public void setPorta(int porta) {
        this.porta = porta;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getPastaServidor() {
        return this.pastaServidor;
    }

    public void setPastaServidor(String pastaServidor) {
        this.pastaServidor = pastaServidor;
    }

    public String getComandoAntesCompilacao() {
        return this.comandoAntesCompilacao;
    }

    public void setComandoAntesCompilacao(String comandoAntesCompilacao) {
        this.comandoAntesCompilacao = comandoAntesCompilacao;
    }

    public String getComandoAposPublicacao() {
        return this.comandoAposPublicacao;
    }

    public void setComandoAposPublicacao(String comandoAposPublicacao) {
        this.comandoAposPublicacao = comandoAposPublicacao;
    }

    public boolean isServidorContingencia() {
        return this.servidorContingencia;
    }

    public void setServidorContingencia(boolean servidorContingencia) {
        this.servidorContingencia = servidorContingencia;
    }

    public String getPastaDeployment() {
        Object pastaDeployment = this.pastaServidor;
        if (!((String)pastaDeployment).endsWith("/")) {
            pastaDeployment = (String)pastaDeployment + "/";
        }
        return ((String)pastaDeployment).concat("standalone/deployments/");
    }

    public String getNomeWar() {
        Object war;
        Object object = war = StringUtils.isNullOrEmpty((String)this.nomeAlternativo) ? this.artefato : this.nomeAlternativo + this.artefato.substring(this.artefato.lastIndexOf("-"));
        if (!((String)war).endsWith(".war")) {
            war = (String)war + ".war";
        }
        return war;
    }

    public String getDeploymentWar() {
        return this.getPastaDeployment() + this.getNomeWar();
    }

    public String getToDeployWar() {
        return this.getPastaDeployment().replace("deployments", "todeploy") + this.getNomeWar();
    }

    public String getDeploymentWarUltimoBackup() {
        return this.getDeploymentWar() + "_bkp_ultimo";
    }

    public String getDeploymentWarBackupAgora() {
        return this.getDeploymentWar() + "_" + NumberUtils.onlyNumber((String)DateUtils.formatyyyyMMddHHmmss((LocalDateTime)LocalDateTime.now()));
    }

    public String getDeploymentWarUndeployed() {
        return this.getDeploymentWar() + ".undeployed";
    }

    public String getDeploymentWarIsUndeploying() {
        return this.getDeploymentWar() + ".isundeploying";
    }

    public String getDeploymentWarIsDeploying() {
        return this.getDeploymentWar() + ".isdeploying";
    }

    public String getDeploymentWarFailed() {
        return this.getDeploymentWar() + ".failed";
    }

    public String getDeploymentWarDeployed() {
        return this.getDeploymentWar() + ".deployed";
    }

    public boolean isComandoAntesCompilacao() {
        return !StringUtils.isNullOrEmpty((String)this.comandoAntesCompilacao);
    }

    public boolean isComandoAposPublicacao() {
        return !StringUtils.isNullOrEmpty((String)this.comandoAposPublicacao);
    }

    public String getInfo(String branch) {
        return this.getInfo("-", branch);
    }

    public String getInfo(String separator, String branch) {
        String contingencia = this.isServidorContingencia() ? " CONTINGENCIA" : "";
        String no = this.getNo().isEmpty() ? "" : " N\u00d3: " + this.getNo();
        String artefato = this.getArtefato();
        return separator + " LOCAL: " + String.valueOf((Object)this.getLocal()) + "\n" + separator + " AMBIENTE: " + String.valueOf((Object)this.getAmbiente()) + "\n" + separator + " SERVIDOR: " + this.getServidor() + contingencia + no + "\n" + separator + " PASTA: " + this.getPastaServidor() + "\n" + separator + " BRANCH: " + (StringUtils.isNullOrEmpty((String)branch) ? "TRUNK" : branch) + "\n" + separator + " M\u00d3DULO: " + String.valueOf((Object)this.modulo) + "\n" + separator + " ARTEFATO: " + artefato;
    }

    public void inacessivel() {
        this.acessivel = false;
    }

    public boolean isAcessivel() {
        return this.acessivel;
    }

    public boolean isInacessivel() {
        return !this.acessivel;
    }
}

