/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.empacotamento;

import br.com.dsfnet.gpd.client.ambiente.AmbienteEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoRepository;
import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.exception.PacoteException;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoRepository;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoSolEntity;
import br.com.dsfnet.gpd.client.rs.ServiceClient;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.svn.LogSvn;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@JArchService
public class EmpacotamentoService
extends CrudService<EmpacotamentoEntity, EmpacotamentoRepository> {
    public static EmpacotamentoService getInstance() {
        return (EmpacotamentoService)((Object)CDI.current().select(EmpacotamentoService.class, new Annotation[0]).get());
    }

    public Set<PlanejamentoEntity> carregaListaCriacaoEmpacotamento() {
        return PlanejamentoRepository.getInstance().listaPlanejamento();
    }

    public void validacaoCriacaoEmpacotamento(Long idPlanejamento, String loginSvn) throws EmpacotamentoException {
        if (idPlanejamento == null) {
            throw new EmpacotamentoException("Selecione o planejamento");
        }
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)PlanejamentoRepository.getInstance().find(idPlanejamento);
        if (EmpacotamentoRepository.getInstance().existeAbertoWorkingCopy(planejamentoEntity.getSistemaEntity().getServidorEmpacotamento(), loginSvn)) {
            throw new EmpacotamentoException("Existe uma empacotamento em andamento para esse Working Copy");
        }
    }

    public EmpacotamentoEntity atualizacaoBancoDadosCriacaoEmpacotamento(String loginSvn, Long idPlanejamento) throws EmpacotamentoException {
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)PlanejamentoRepository.getInstance().find(idPlanejamento);
        return EmpacotamentoRepository.getInstance().iniciarPlanejamento(planejamentoEntity, loginSvn);
    }

    public Set<PlanejamentoSolEntity> carregaListaInicioEmpacotamento(String login) {
        return PlanejamentoRepository.getInstance().listaEmpacotamentoIniciar(login);
    }

    public void validacaoInicioEmpacotamento(Long idPlanejamentoSol) throws EmpacotamentoException {
        if (idPlanejamentoSol == null) {
            throw new EmpacotamentoException("Selecione os dados para empacotamento");
        }
        PlanejamentoSolEntity planejamentoSolEntity = (PlanejamentoSolEntity)((EmpacotamentoRepository)this.getRepository()).getEntityManager().find(PlanejamentoSolEntity.class, (Object)idPlanejamentoSol);
        if (EmpacotamentoRepository.getInstance().existeSemCommit(planejamentoSolEntity.getPlanejamentoEntity().getVersao(), planejamentoSolEntity.getPlanejamentoEntity().getSistemaEntity().getId())) {
            throw new EmpacotamentoException("Existe uma Branch n\u00e3o finalizada para esta vers\u00e3o");
        }
    }

    public EmpacotamentoEntity atualizacaoBancoDadosInicioEmpacotamento(String loginSvn, Long idPlanejamentoSol) throws EmpacotamentoException {
        PlanejamentoSolEntity planejamentoSolEntity = (PlanejamentoSolEntity)((EmpacotamentoRepository)this.getRepository()).getEntityManager().find(PlanejamentoSolEntity.class, (Object)idPlanejamentoSol);
        return EmpacotamentoRepository.getInstance().iniciarEmpacotamento(planejamentoSolEntity, loginSvn);
    }

    public Set<EmpacotamentoEntity> carregaListaFimEmpacotamento(String login) {
        return EmpacotamentoRepository.getInstance().listaEmpacotamentoFinalizar(login);
    }

    public void validacaoFimEmpacotamento(Long idEmpacotamento) throws EmpacotamentoException {
        if (idEmpacotamento == null) {
            throw new EmpacotamentoException("Selecione os dados para empacotamento");
        }
    }

    public void atualizacaoBancoDadosFimEmpacotamento(Long idEmpacotamento) throws EmpacotamentoException {
        EmpacotamentoEntity empacotamentoEntity = (EmpacotamentoEntity)EmpacotamentoRepository.getInstance().find(idEmpacotamento);
        EmpacotamentoRepository.getInstance().finalizarEmpacotamento(empacotamentoEntity);
    }

    public Set<PlanejamentoEntity> carregaListaFechamentoEmpacotamento(String login) {
        return PlanejamentoRepository.getInstance().listaEmpacotamentoFechar(login);
    }

    public void validacaoFechamentoEmpacotamento(Long idPlanejamento, String nomeArquivo, byte[] streamArquivo) throws EmpacotamentoException {
        if (idPlanejamento == null) {
            throw new EmpacotamentoException("Selecione os dados para empacotamento");
        }
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)PlanejamentoRepository.getInstance().find(idPlanejamento);
        if (planejamentoEntity.getSistemaEntity().getTecnologia() != null && planejamentoEntity.getSistemaEntity().getTecnologia().pacoteObrigatorio() && (nomeArquivo == null || streamArquivo == null)) {
            throw new EmpacotamentoException("Pacote para publica\u00e7\u00e3o N\u00c3O selecionado");
        }
        if (planejamentoEntity.getSistemaEntity().getTecnologia().pacoteObrigatorio() && streamArquivo.length == 0) {
            throw new EmpacotamentoException("Pacote para publica\u00e7\u00e3o est\u00e1 vazio (0 bytes)");
        }
        if (planejamentoEntity.getSistemaEntity().getNomePacote() == null && planejamentoEntity.getSistemaEntity().getPacotes() != null && !planejamentoEntity.getSistemaEntity().getPacotes().contains(nomeArquivo)) {
            throw new EmpacotamentoException("Nome de pacote inv\u00e1lido. Somente um dos pacotes " + planejamentoEntity.getSistemaEntity().getPacotes().replaceAll(",", " / ") + " ser\u00e1 aceito");
        }
    }

    public List<String> geraLogFechamentoEmpacotamento(Long idPlanejamento) {
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)PlanejamentoRepository.getInstance().find(idPlanejamento);
        Set<String> solsSelecionadas = PlanejamentoRepository.getInstance().listaSol(planejamentoEntity.getSistemaEntity().getCliente(), planejamentoEntity.getSistemaEntity().getSistema(), planejamentoEntity.getSistemaEntity().getTecnologia(), planejamentoEntity.getVersao());
        LogSvn logUtil = new LogSvn();
        ArrayList<String> log = new ArrayList<String>();
        logUtil.formatBeginMiddleEnd(log, "FECHAMENTO EMPACOTAMENTO", new String[]{"Cliente: " + planejamentoEntity.getSistemaEntity().getCliente(), "Sistema: " + planejamentoEntity.getSistemaEntity().getSistema(), "Tecnologia: " + planejamentoEntity.getSistemaEntity().getTecnologia().name(), "Pacote: " + planejamentoEntity.getVersao(), "Sol(s): " + solsSelecionadas.stream().map(Object::toString).collect(Collectors.joining(", "))});
        return log;
    }

    public void atualizacaoBancoDadosFechamentoEmpacotamentoSemChamadaJenkins(String loginSvn, Long idPlanejamento, String nomeArquivo, byte[] streamArquivo) throws PacoteException, EmpacotamentoException {
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)PlanejamentoRepository.getInstance().find(idPlanejamento);
        EmpacotamentoRepository.getInstance().liberar(loginSvn, planejamentoEntity.getVersao(), planejamentoEntity.getSistemaEntity().getId(), nomeArquivo, streamArquivo);
    }

    public void atualizacaoBancoDadosFechamentoEmpacotamento(String loginSvn, Long idPlanejamento, String nomeArquivo, byte[] streamArquivo, AmbienteType ambiente) throws PacoteException, EmpacotamentoException {
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)PlanejamentoRepository.getInstance().find(idPlanejamento);
        this.atualizacaoBancoDadosFechamentoEmpacotamentoSemChamadaJenkins(loginSvn, planejamentoEntity.getId(), nomeArquivo, streamArquivo);
        if (planejamentoEntity.getSistemaEntity().isProcessoAutomatico()) {
            this.chamaJenkinsPublicacao(planejamentoEntity.getId(), ambiente);
        }
    }

    public void chamaJenkinsPublicacao(Long idPlanejamento, AmbienteType ambiente) {
        PlanejamentoEntity planejamentoEntity = PlanejamentoRepository.getInstance().pesquisar(idPlanejamento);
        String listaSol = planejamentoEntity.getListaSol().stream().map(planejamentoSolEntity -> planejamentoSolEntity.getNumeroSol()).collect(Collectors.joining(";"));
        List lista = planejamentoEntity.getSistemaEntity().getListaAmbiente().stream().filter(a -> a.getTipo().equals((Object)ambiente)).collect(Collectors.toList());
        for (AmbienteEntity ambienteEntity : lista) {
            ServiceClient.servicoAutomatizaFase2(planejamentoEntity.getId(), listaSol, planejamentoEntity.getSistemaEntity(), planejamentoEntity.getVersao(), ambienteEntity.getNome(), ambienteEntity.getIp(), ambienteEntity.getCaminho(), planejamentoEntity.getKanbanEntity().getToken(), planejamentoEntity.getKanbanEntity().getHomologacaoRaia(), planejamentoEntity.getKanbanEntity().getHomologacaoCorInicial(), planejamentoEntity.getKanbanEntity().getHomologacaoCorSucesso(), planejamentoEntity.getKanbanEntity().getHomologacaoCorFalha(), ambiente);
        }
    }

    public void gravaEmpacotamento(PlanejamentoEntity planejamentoEntity, UsuarioEntity usuarioEntity) throws EmpacotamentoException {
        ArrayList<EmpacotamentoEntity> listaEmpacotamento = new ArrayList<EmpacotamentoEntity>();
        listaEmpacotamento.add(this.atualizacaoBancoDadosCriacaoEmpacotamento(usuarioEntity.getLogin(), planejamentoEntity.getId()));
        for (PlanejamentoSolEntity item : planejamentoEntity.getListaSol()) {
            listaEmpacotamento.add(this.atualizacaoBancoDadosInicioEmpacotamento(usuarioEntity.getLogin(), item.getId()));
            Set<EmpacotamentoEntity> lista = this.carregaListaFimEmpacotamento(usuarioEntity.getLogin());
            EmpacotamentoEntity empacotamentoEntity = lista.stream().findFirst().orElse(null);
            this.atualizacaoBancoDadosFimEmpacotamento(empacotamentoEntity != null ? empacotamentoEntity.getId() : null);
        }
        this.atualizacaoBancoDadosFechamentoEmpacotamentoSemChamadaJenkins(usuarioEntity.getLogin(), planejamentoEntity.getId(), planejamentoEntity.getSistemaEntity().getNomePacote(), null);
    }
}

