/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ProxyHelper {
    private static final Pattern HTTP_PROXY_STATUS_LINE_PATTERN = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    private static final int SOCKS_COMMAND_CONNECT = 1;
    private static final int SOCKS_VERSION4 = 4;
    private static final int SOCKS_VERSION5 = 5;
    private static final int SOCKS_RESPONSE_REQUEST_OK = 0;
    private static final int SOCKS_AUTH_TYPE_NO_AUTHENTICATION = 0;
    private static final int SOCKS_AUTH_TYPE_USER_PASSWORD = 2;
    private static final int SOCKS_AUTH_TYPE_UNKNOWN = -1;
    private static final int SOCKS_ADDRESS_TYPE_IPV4 = 1;
    private static final int SOCKS_ADDRESS_TYPE_DOMAIN_NAME = 3;
    private static final int SOCKS_ADDRESS_TYPE_IPV6 = 4;

    ProxyHelper() {
    }

    static void connectViaProxy(Proxy proxy, InetSocketAddress endPoint, SocketChannel socketChannel) throws IOException {
        if (proxy.type() == Proxy.Type.HTTP) {
            ProxyHelper.doHTTPTunneling(endPoint, socketChannel);
        } else if (proxy.type() == Proxy.Type.SOCKS) {
            ProxyHelper.doSOCKSTunneling(endPoint, socketChannel, proxy);
        } else {
            throw new IOException("Unknown proxy type : " + proxy.type());
        }
    }

    private static void doHTTPTunneling(InetSocketAddress endPoint, SocketChannel socketChannel) throws IOException {
        String remoteHost = endPoint.getHostString() + ":" + endPoint.getPort();
        StringBuilder httpTunnelRequest = new StringBuilder();
        httpTunnelRequest.append("CONNECT " + remoteHost + " HTTP/1.0\r\n");
        httpTunnelRequest.append("Host: " + remoteHost + "\r\n");
        httpTunnelRequest.append("\r\n");
        ByteBuffer requestBuffer = ByteBuffer.wrap(httpTunnelRequest.toString().getBytes(StandardCharsets.ISO_8859_1));
        while (requestBuffer.hasRemaining()) {
            socketChannel.write(requestBuffer);
        }
        ByteBuffer responseBuffer = ByteBuffer.allocate(512);
        socketChannel.read(responseBuffer);
        responseBuffer.flip();
        String response = new String(responseBuffer.array(), responseBuffer.arrayOffset(), responseBuffer.limit(), StandardCharsets.US_ASCII);
        BufferedReader responseReader = new BufferedReader(new StringReader(response));
        String statusLine = responseReader.readLine();
        Matcher matcher = HTTP_PROXY_STATUS_LINE_PATTERN.matcher(statusLine);
        if (!matcher.matches()) {
            throw new IOException("HTTP proxy tunneling failed [" + statusLine + "]");
        }
        int statusCode = Integer.parseInt(matcher.group(1));
        String statusReason = matcher.group(2);
        if (statusCode != 200) {
            throw new IOException("HTTP proxy tunneling failed [" + statusCode + ":" + statusLine + "]");
        }
    }

    private static void doSOCKSTunneling(InetSocketAddress endPoint, SocketChannel socketChannel, Proxy proxy) throws IOException {
        ProxyHelper.checkEndPointAccessPermission(endPoint);
        ByteBuffer ioBuffer = ByteBuffer.allocate(512);
        ProxyHelper.doSOCKSAuthentication(endPoint, socketChannel, proxy, ioBuffer);
        ProxyHelper.doSOCKSConnect(endPoint, socketChannel, proxy, ioBuffer);
    }

    private static void doSOCKSAuthentication(InetSocketAddress epoint, SocketChannel socketChannel, Proxy proxy, ByteBuffer ioBuffer) throws IOException {
        ProxyHelper.writeAuthPacket(ioBuffer, socketChannel);
        int i = ProxyHelper.read(ioBuffer, socketChannel, 2);
        if (i == 2 && ioBuffer.get(0) == 5) {
            byte authType = ioBuffer.get(1);
            if (authType == -1) {
                throw new SocketException("Unknown SOCKS Authentication.");
            }
            if (!ProxyHelper.authenticate(authType, ioBuffer, socketChannel, proxy)) {
                throw new SocketException("SOCKS Authentication failure.");
            }
        } else {
            if (epoint.isUnresolved()) {
                throw new UnknownHostException(epoint.toString());
            }
            ProxyHelper.doSOCKSV4Connect(ioBuffer, socketChannel, epoint);
            return;
        }
    }

    private static void doSOCKSConnect(InetSocketAddress epoint, SocketChannel socketChannel, Proxy proxy, ByteBuffer ioBuffer) throws IOException {
        ProxyHelper.writeConnectPacket(ioBuffer, socketChannel, epoint);
        int i = ProxyHelper.read(ioBuffer, socketChannel, 4);
        if (i != 4) {
            throw new SocketException("SOCKS Bad response.");
        }
        if (ioBuffer.get(1) != 0) {
            throw new SocketException("SOCKS Connect Failure : " + ioBuffer.get(1));
        }
        ProxyHelper.processConnectSuccess(ioBuffer, socketChannel);
    }

    private static void checkEndPointAccessPermission(InetSocketAddress epoint) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (epoint.isUnresolved()) {
                security.checkConnect(epoint.getHostName(), epoint.getPort());
            } else {
                security.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
            }
        }
    }

    private static void processConnectSuccess(ByteBuffer ioBuffer, SocketChannel sc) throws IOException {
        SocketException ex = null;
        byte socketAddrType = ioBuffer.get(3);
        switch (socketAddrType) {
            case 1: {
                byte[] addr = new byte[4];
                int i = ProxyHelper.read(ioBuffer, sc, 4);
                if (i != 4) {
                    throw new SocketException("SOCKS Bad response.");
                }
                ioBuffer.get(addr);
                i = ProxyHelper.read(ioBuffer, sc, 2);
                if (i == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            case 3: {
                byte len = ioBuffer.get(1);
                byte[] host = new byte[len];
                int i = ProxyHelper.read(ioBuffer, sc, len);
                if (i != len) {
                    throw new SocketException("SOCKS Bad response.");
                }
                ioBuffer.get(host);
                i = ProxyHelper.read(ioBuffer, sc, 2);
                if (i == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            case 4: {
                byte len = ioBuffer.get(1);
                byte[] addr = new byte[len];
                int i = ProxyHelper.read(ioBuffer, sc, len);
                if (i != len) {
                    throw new SocketException("SOCKS Bad response.");
                }
                ioBuffer.get(addr);
                i = ProxyHelper.read(ioBuffer, sc, 2);
                if (i == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            default: {
                ex = new SocketException("SOCKS Bad response.");
            }
        }
    }

    private static void writeAuthPacket(ByteBuffer ioBuffer, SocketChannel sc) throws IOException {
        ioBuffer.clear();
        ioBuffer.put((byte)5);
        ioBuffer.put((byte)2);
        ioBuffer.put((byte)0);
        ioBuffer.put((byte)2);
        ioBuffer.flip();
        sc.write(ioBuffer);
    }

    private static void writeConnectPacket(ByteBuffer ioBuffer, SocketChannel sc, InetSocketAddress epoint) throws IOException {
        ioBuffer.clear();
        ioBuffer.put((byte)5);
        ioBuffer.put((byte)1);
        ioBuffer.put((byte)0);
        if (epoint.isUnresolved()) {
            ioBuffer.put((byte)3);
            ioBuffer.put((byte)epoint.getHostName().length());
            ioBuffer.put(epoint.getHostName().getBytes("ISO-8859-1"));
            ioBuffer.put((byte)(epoint.getPort() >> 8 & 0xFF));
            ioBuffer.put((byte)(epoint.getPort() >> 0 & 0xFF));
        } else if (epoint.getAddress() instanceof Inet6Address) {
            ioBuffer.put((byte)4);
            ioBuffer.put(epoint.getAddress().getAddress());
            ioBuffer.put((byte)(epoint.getPort() >> 8 & 0xFF));
            ioBuffer.put((byte)(epoint.getPort() >> 0 & 0xFF));
        } else {
            ioBuffer.put((byte)1);
            ioBuffer.put(epoint.getAddress().getAddress());
            ioBuffer.put((byte)(epoint.getPort() >> 8 & 0xFF));
            ioBuffer.put((byte)(epoint.getPort() >> 0 & 0xFF));
        }
        ioBuffer.flip();
        sc.write(ioBuffer);
    }

    private static int read(ByteBuffer ioBuffer, SocketChannel sc, int requiredBytes) throws IOException {
        ioBuffer.clear().limit(requiredBytes);
        for (int attempts = 0; ioBuffer.hasRemaining() && attempts < 3; ++attempts) {
            if (sc.read(ioBuffer) != -1) continue;
            throw new ClosedChannelException();
        }
        if (ioBuffer.hasRemaining()) {
            throw new SocketException("Malformed reply from SOCKS server");
        }
        ioBuffer.flip();
        return ioBuffer.remaining();
    }

    private static boolean authenticate(int method, ByteBuffer ioBuffer, SocketChannel sc, Proxy proxy) throws IOException {
        if (method == 0) {
            return true;
        }
        if (method == 2) {
            String userName;
            InetAddress addr;
            int proxyPort;
            String password = null;
            String proxyHost = ((InetSocketAddress)proxy.address()).getHostString();
            PasswordAuthentication pw = ProxyHelper.getUserPassword(proxyHost, proxyPort = ((InetSocketAddress)proxy.address()).getPort(), addr = InetAddress.getByName(proxyHost));
            if (pw != null) {
                userName = pw.getUserName();
                password = new String(pw.getPassword());
            } else {
                userName = System.getProperty("user.name", "");
            }
            if (userName == null) {
                return false;
            }
            ioBuffer.clear();
            ioBuffer.put((byte)1);
            ioBuffer.put((byte)userName.length());
            ioBuffer.put(userName.getBytes("ISO-8859-1"));
            if (password != null) {
                ioBuffer.put((byte)password.length());
                ioBuffer.put(password.getBytes("ISO-8859-1"));
            } else {
                ioBuffer.put((byte)0);
            }
            ioBuffer.flip();
            sc.write(ioBuffer);
            int i = ProxyHelper.read(ioBuffer, sc, 2);
            return i == 2 && ioBuffer.get(1) == 0;
        }
        return false;
    }

    private static PasswordAuthentication getUserPassword(final String proxyHost, final int proxyPort, final InetAddress addr) {
        return AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

            @Override
            public PasswordAuthentication run() {
                return Authenticator.requestPasswordAuthentication(proxyHost, addr, proxyPort, "SOCKS5", "SOCKS authentication", null);
            }
        });
    }

    private static void doSOCKSV4Connect(ByteBuffer ioBuffer, SocketChannel sc, InetSocketAddress endpoint) throws IOException {
        if (!(endpoint.getAddress() instanceof Inet4Address)) {
            throw new SocketException("SOCKS V4 requires IPv4 only addresses");
        }
        ioBuffer.clear();
        ioBuffer.put((byte)4);
        ioBuffer.put((byte)1);
        ioBuffer.put((byte)(endpoint.getPort() >> 8 & 0xFF));
        ioBuffer.put((byte)(endpoint.getPort() >> 0 & 0xFF));
        ioBuffer.put(endpoint.getAddress().getAddress());
        String userName = System.getProperty("user.name", "");
        ioBuffer.put(userName.getBytes("ISO-8859-1"));
        ioBuffer.put((byte)0);
        ioBuffer.flip();
        sc.write(ioBuffer);
        int readLength = ProxyHelper.read(ioBuffer, sc, 8);
        if (readLength != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + readLength);
        }
        if (ioBuffer.get(0) != 0 && ioBuffer.get(0) != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        switch (ioBuffer.get(1)) {
            case 91: {
                throw new SocketException("SOCKS Failure: request rejected.");
            }
            case 92: {
                throw new SocketException("SOCKS Failure: unable to connect to destination.");
            }
            case 93: {
                throw new SocketException("SOCKS Failure: authentication failed.");
            }
        }
        throw new SocketException("SOCKS Failure: bad status : " + ioBuffer.get(1));
    }
}

