/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import java.util.Arrays;
import oracle.net.aso.AsoException;
import oracle.net.aso.CipherBlockProcessor;
import oracle.net.aso.EncryptionEngine;
import oracle.net.aso.PaddedCipher;

class PKCS5Padding
extends PaddedCipher {
    private final byte[] tempBuffer;

    PKCS5Padding(int blockSize, EncryptionEngine engine, CipherBlockProcessor blockProcessor) {
        super(blockSize, engine, blockProcessor);
        this.tempBuffer = new byte[blockSize];
    }

    @Override
    public byte[] encrypt(byte[] buffer) throws AsoException {
        int length = buffer.length;
        byte padding = (byte)(length % this.blockSize == 0 ? this.blockSize : this.blockSize - length % this.blockSize);
        int elength = length + padding;
        byte[] result = new byte[elength];
        if (this.coreEngine.canProcessBulk(elength)) {
            byte[] input = new byte[elength];
            System.arraycopy(buffer, 0, input, 0, length);
            Arrays.fill(input, length, elength, padding);
            this.coreEngine.encrypt(input, 0, elength, result);
        } else {
            for (int i = 0; i < elength; i += this.blockSize) {
                if (i <= length - this.blockSize) {
                    System.arraycopy(buffer, i, this.tempBuffer, 0, this.blockSize);
                } else {
                    System.arraycopy(buffer, i, this.tempBuffer, 0, buffer.length - i);
                    Arrays.fill(this.tempBuffer, buffer.length - i, this.blockSize, padding);
                }
                byte[] output = this.blockProcessor.encrypt(this.tempBuffer);
                System.arraycopy(output, 0, result, i, this.blockSize);
            }
        }
        return result;
    }

    @Override
    public byte[] decrypt(byte[] ebuffer) throws AsoException {
        int elen = ebuffer.length;
        byte[] temp = new byte[elen];
        if (this.coreEngine.canProcessBulk(elen)) {
            this.coreEngine.decrypt(ebuffer, 0, elen, temp);
        } else {
            for (int i = 0; i < elen - 1; i += this.blockSize) {
                System.arraycopy(ebuffer, i, this.tempBuffer, 0, this.blockSize);
                byte[] output = this.blockProcessor.decrypt(this.tempBuffer);
                System.arraycopy(output, 0, temp, i, this.blockSize);
            }
        }
        byte padding = temp[elen - 1];
        byte[] result = Arrays.copyOfRange(temp, 0, elen - padding);
        return result;
    }
}

