/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.PropertiesExporterConfigurationFactory;
import net.sf.jasperreports.export.annotations.ExporterParameter;
import net.sf.jasperreports.export.annotations.ExporterProperty;
import net.sf.jasperreports.export.parameters.ParameterOverriddenResolver;
import net.sf.jasperreports.export.parameters.ParameterOverrideResolver;
import net.sf.jasperreports.export.parameters.ParameterResolver;

public class ParametersExporterConfigurationFactory<C extends CommonExportConfiguration> {
    private final JasperReportsContext jasperReportsContext;
    private final Map<JRExporterParameter, Object> parameters;
    private final JasperPrint jasperPrint;
    private final ParameterResolver parameterResolver;
    private static final Object NULL_VALUE_PLACEHOLDER = new Object();

    public ParametersExporterConfigurationFactory(JasperReportsContext jasperReportsContext, Map<JRExporterParameter, Object> parameters, JasperPrint jasperPrint) {
        this.jasperReportsContext = jasperReportsContext;
        this.parameters = parameters;
        this.jasperPrint = jasperPrint;
        boolean isParametersOverrideHints = true;
        Boolean param = (Boolean)parameters.get(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS);
        isParametersOverrideHints = param == null ? JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty("net.sf.jasperreports.export.parameters.override.report.hints") : param.booleanValue();
        this.parameterResolver = isParametersOverrideHints ? new ParameterOverrideResolver(jasperReportsContext, jasperPrint, parameters) : new ParameterOverriddenResolver(jasperReportsContext, jasperPrint, parameters);
    }

    public C getConfiguration(Class<C> configurationInterface) {
        return this.getProxy(configurationInterface, new ParametersInvocationHandler());
    }

    private final C getProxy(Class<?> clazz, InvocationHandler handler) {
        CommonExportConfiguration proxy = (CommonExportConfiguration)Proxy.newProxyInstance(JRAbstractExporter.class.getClassLoader(), new Class[]{clazz}, handler);
        return (C)proxy;
    }

    protected Object getPropertyValue(Method method) {
        Object value = null;
        JRExporterParameter parameter = null;
        ExporterParameter exporterParameter = method.getAnnotation(ExporterParameter.class);
        if (exporterParameter != null) {
            try {
                parameter = (JRExporterParameter)exporterParameter.type().getField(exporterParameter.name()).get(null);
            }
            catch (NoSuchFieldException e) {
                throw new JRRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new JRRuntimeException(e);
            }
        }
        ExporterProperty exporterProperty = method.getAnnotation(ExporterProperty.class);
        if (parameter == null) {
            if (exporterProperty != null) {
                value = PropertiesExporterConfigurationFactory.getPropertyValue(this.jasperReportsContext, this.jasperPrint, exporterProperty, method.getReturnType());
            }
        } else if (exporterProperty == null) {
            value = this.parameters.get(parameter);
        } else {
            String propertyName = exporterProperty.value();
            Class<?> type = method.getReturnType();
            if (String[].class.equals(type)) {
                value = this.parameterResolver.getStringArrayParameter(parameter, propertyName);
            } else if (String.class.equals(type)) {
                value = exporterParameter.acceptNull() ? this.parameterResolver.getStringParameter(parameter, propertyName) : this.parameterResolver.getStringParameterOrDefault(parameter, propertyName);
            } else if (Character.class.equals(type)) {
                value = this.parameterResolver.getCharacterParameter(parameter, propertyName);
            } else if (Integer.class.equals(type)) {
                value = this.parameterResolver.getIntegerParameter(parameter, propertyName, exporterProperty.intDefault());
            } else if (Float.class.equals(type)) {
                value = Float.valueOf(this.parameterResolver.getFloatParameter(parameter, propertyName, exporterProperty.floatDefault()));
            } else if (Boolean.class.equals(type)) {
                value = this.parameterResolver.getBooleanParameter(parameter, propertyName, exporterProperty.booleanDefault());
            } else if (Map.class.isAssignableFrom(type)) {
                value = this.parameterResolver.getMapParameter(parameter, propertyName);
            } else if (NamedEnum.class.isAssignableFrom(type)) {
                value = exporterParameter.acceptNull() ? this.parameterResolver.getStringParameter(parameter, propertyName) : this.parameterResolver.getStringParameterOrDefault(parameter, propertyName);
                try {
                    Method byNameMethod = type.getMethod("getByName", String.class);
                    value = byNameMethod.invoke(null, value);
                }
                catch (NoSuchMethodException e) {
                    throw new JRRuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new JRRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JRRuntimeException(e);
                }
            } else {
                throw new JRRuntimeException("export.common.properties.type.not.supported", type);
            }
        }
        return value;
    }

    class ParametersInvocationHandler
    implements InvocationHandler {
        private final Map<Method, Object> values = new ConcurrentHashMap<Method, Object>(16, 0.75f, 1);

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object cachedValue = this.values.get(method);
            if (cachedValue == null) {
                Object value = ParametersExporterConfigurationFactory.this.getPropertyValue(method);
                cachedValue = value == null ? NULL_VALUE_PLACEHOLDER : value;
                this.values.put(method, cachedValue);
            }
            return cachedValue == NULL_VALUE_PLACEHOLDER ? null : cachedValue;
        }
    }
}

