/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.ConstantExpressionEvaluation;
import net.sf.jasperreports.compilers.DirectExpressionEvaluation;
import net.sf.jasperreports.compilers.DirectExpressionEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluators;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.compilers.FieldEvaluation;
import net.sf.jasperreports.compilers.ParameterEvaluation;
import net.sf.jasperreports.compilers.ResourceEvaluation;
import net.sf.jasperreports.compilers.SimpleTextEvaluation;
import net.sf.jasperreports.compilers.UniformExpressionEvaluator;
import net.sf.jasperreports.compilers.VariableEvaluation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.ExpressionValues;
import net.sf.jasperreports.engine.fill.FillExpressionDefaultValues;
import net.sf.jasperreports.engine.fill.FillExpressionEstimatedValues;
import net.sf.jasperreports.engine.fill.FillExpressionOldValues;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.SimpleTextExpressionEvaluator;

public class StandardExpressionEvaluators
implements DirectExpressionEvaluators {
    private static DirectExpressionEvaluator NULL_PLACEHOLDER = new UniformExpressionEvaluator(){

        @Override
        protected Object defaultEvaluate() {
            throw new UnsupportedOperationException();
        }
    };
    private Map<Integer, DirectExpressionEvaluation> directEvaluations;
    private DirectExpressionValueFilter valueFilter;
    private Map<Integer, DirectExpressionEvaluator> evaluators;
    private JREvaluator evaluator;
    private Map<String, JRFillParameter> parametersMap;
    private Map<String, JRFillField> fieldsMap;
    private Map<String, JRFillVariable> variablesMap;
    private ExpressionValues defaultValues;
    private ExpressionValues oldValues;
    private ExpressionValues estimatedValues;

    public StandardExpressionEvaluators(Map<Integer, DirectExpressionEvaluation> directEvaluations, DirectExpressionValueFilter valueFilter) {
        this.directEvaluations = directEvaluations;
        this.valueFilter = valueFilter;
        this.evaluators = new HashMap<Integer, DirectExpressionEvaluator>();
    }

    @Override
    public void init(JREvaluator evaluator, Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        this.evaluator = evaluator;
        this.parametersMap = parametersMap;
        this.fieldsMap = fieldsMap;
        this.variablesMap = variablesMap;
        this.defaultValues = new FillExpressionDefaultValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.oldValues = new FillExpressionOldValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.estimatedValues = new FillExpressionEstimatedValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.evaluators.clear();
    }

    @Override
    public DirectExpressionEvaluator getEvaluator(JRExpression expression) {
        int expressionId = expression.getId();
        DirectExpressionEvaluator evaluator = this.evaluators.get(expressionId);
        if (evaluator == null) {
            DirectExpressionEvaluation directEvaluation = this.directEvaluation(expression.getId());
            evaluator = directEvaluation == null ? NULL_PLACEHOLDER : this.createDirectEvaluator(directEvaluation);
            this.evaluators.put(expressionId, evaluator);
        }
        return evaluator == NULL_PLACEHOLDER ? null : evaluator;
    }

    protected DirectExpressionEvaluation directEvaluation(int expressionId) {
        DirectExpressionEvaluation directEvaluation = this.directEvaluations == null ? null : this.directEvaluations.get(expressionId);
        return directEvaluation;
    }

    protected DirectExpressionEvaluator createDirectEvaluator(DirectExpressionEvaluation evaluation) {
        DirectExpressionEvaluator evaluator;
        switch (evaluation.getType()) {
            case CONSTANT: {
                evaluator = new ConstantEvaluator(((ConstantExpressionEvaluation)evaluation).getValue());
                break;
            }
            case SIMPLE_TEXT: {
                evaluator = new SimpleTextEvaluator(((SimpleTextEvaluation)evaluation).getChunks());
                break;
            }
            case PARAMETER: {
                String parameterName = ((ParameterEvaluation)evaluation).getName();
                JRFillParameter parameter = this.parametersMap.get(parameterName);
                if (parameter == null) {
                    throw new JRRuntimeException("Did not find parameter " + parameterName);
                }
                evaluator = new ParameterEvaluator(parameter);
                break;
            }
            case FIELD: {
                String fieldName = ((FieldEvaluation)evaluation).getName();
                JRFillField field = this.fieldsMap.get(fieldName);
                if (field == null) {
                    throw new JRRuntimeException("Did not find field " + fieldName);
                }
                evaluator = new FieldEvaluator(field);
                break;
            }
            case VARIABLE: {
                String variableName = ((VariableEvaluation)evaluation).getName();
                JRFillVariable variable = this.variablesMap.get(variableName);
                if (variable == null) {
                    throw new JRRuntimeException("Did not find variable " + variableName);
                }
                evaluator = new VariableEvaluator(variable);
                break;
            }
            case RESOURCE: {
                evaluator = new ResourceEvaluator(((ResourceEvaluation)evaluation).getMessageKey());
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown direct expression evaluation type " + (Object)((Object)evaluation.getType()));
            }
        }
        return evaluator;
    }

    protected Object filterValue(Object value, Class<?> expectedType) {
        return this.valueFilter == null ? value : this.valueFilter.filterValue(value, expectedType);
    }

    protected class ResourceEvaluator
    extends UniformExpressionEvaluator {
        private String messageKey;

        public ResourceEvaluator(String messageKey) {
            this.messageKey = messageKey;
        }

        @Override
        protected Object defaultEvaluate() {
            return StandardExpressionEvaluators.this.filterValue(StandardExpressionEvaluators.this.evaluator.str(this.messageKey), null);
        }
    }

    protected class VariableEvaluator
    implements DirectExpressionEvaluator {
        private JRFillVariable variable;

        public VariableEvaluator(JRFillVariable variable) {
            this.variable = variable;
        }

        @Override
        public Object evaluate() {
            return StandardExpressionEvaluators.this.filterValue(this.variable.getValue(), this.variable.getValueClass());
        }

        @Override
        public Object evaluateOld() {
            return StandardExpressionEvaluators.this.filterValue(this.variable.getOldValue(), this.variable.getValueClass());
        }

        @Override
        public Object evaluateEstimated() {
            return StandardExpressionEvaluators.this.filterValue(this.variable.getEstimatedValue(), this.variable.getValueClass());
        }
    }

    protected class FieldEvaluator
    implements DirectExpressionEvaluator {
        private JRFillField field;

        public FieldEvaluator(JRFillField field) {
            this.field = field;
        }

        @Override
        public Object evaluate() {
            return StandardExpressionEvaluators.this.filterValue(this.field.getValue(), this.field.getValueClass());
        }

        @Override
        public Object evaluateOld() {
            return StandardExpressionEvaluators.this.filterValue(this.field.getOldValue(), this.field.getValueClass());
        }

        @Override
        public Object evaluateEstimated() {
            return StandardExpressionEvaluators.this.filterValue(this.field.getValue(), this.field.getValueClass());
        }
    }

    protected class ParameterEvaluator
    extends UniformExpressionEvaluator {
        private JRFillParameter parameter;

        public ParameterEvaluator(JRFillParameter parameter) {
            this.parameter = parameter;
        }

        @Override
        protected Object defaultEvaluate() {
            return StandardExpressionEvaluators.this.filterValue(this.parameter.getValue(), this.parameter.getValueClass());
        }
    }

    protected class SimpleTextEvaluator
    implements DirectExpressionEvaluator {
        private JRExpressionChunk[] chunks;

        public SimpleTextEvaluator(JRExpressionChunk[] chunks) {
            this.chunks = chunks;
        }

        @Override
        public Object evaluate() {
            return SimpleTextExpressionEvaluator.evaluate(this.chunks, StandardExpressionEvaluators.this.defaultValues);
        }

        @Override
        public Object evaluateOld() {
            return SimpleTextExpressionEvaluator.evaluate(this.chunks, StandardExpressionEvaluators.this.oldValues);
        }

        @Override
        public Object evaluateEstimated() {
            return SimpleTextExpressionEvaluator.evaluate(this.chunks, StandardExpressionEvaluators.this.estimatedValues);
        }
    }

    protected class ConstantEvaluator
    extends UniformExpressionEvaluator {
        private Object value;

        public ConstantEvaluator(Object value) {
            this.value = value;
        }

        @Override
        protected Object defaultEvaluate() {
            return StandardExpressionEvaluators.this.filterValue(this.value, null);
        }
    }
}

