/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util.br;

import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.StringUtils;
import java.util.regex.Pattern;

public final class CpfCnpjUtils {
    private static final int DOIS = 2;
    private static final int TRES = 3;
    private static final int QUATRO = 4;
    private static final int CINCO = 5;
    private static final int SEIS = 6;
    private static final int SETE = 7;
    private static final int OITO = 8;
    private static final int NOVE = 9;
    private static final int DEZ = 10;
    private static final int ONZE = 11;
    private static final int DOZE = 12;
    private static final int TREZE = 13;
    private static final int QUATORZE = 14;
    private static final int QUARENTA_OITO = 48;
    public static final int UM = 1;
    public static final int ZERO = 0;

    private CpfCnpjUtils() {
    }

    public static String formataCpf(String cpf) {
        if (cpf == null) {
            return null;
        }
        String value = CharacterUtils.alignTextRigth(cpf, 11, "0");
        return CpfCnpjUtils.formataMascara(value, "###.###.###-##");
    }

    public static String formataCnpj(String cnpj) {
        if (cnpj == null) {
            return null;
        }
        String value = CharacterUtils.alignTextRigth(cnpj, 14, "0");
        return CpfCnpjUtils.formataMascara(value, "##.###.###/####-##");
    }

    public static String formata(String valor) {
        if (valor == null) {
            return null;
        }
        if (valor.isBlank()) {
            return "";
        }
        if ((valor = CharacterUtils.onlyNumber(valor)).length() <= 11) {
            return CpfCnpjUtils.formataCpf(valor);
        }
        return CpfCnpjUtils.formataCnpj(valor);
    }

    public static boolean valida(String cpfCnpj) {
        boolean result;
        if (StringUtils.isNullOrEmpty(cpfCnpj)) {
            return false;
        }
        String value = NumberUtils.onlyNumber(cpfCnpj);
        if (value.length() > 11 && value.length() < 14) {
            value = CharacterUtils.alignTextRigth(value, 14, "0");
        }
        if (!(result = value.length() == 14 ? CpfCnpjUtils.validaCnpj(value) : CpfCnpjUtils.validaCpf(value)) && value.length() > 3) {
            value = value.substring(3, Math.min(value.length(), 14));
            result = CpfCnpjUtils.validaCpf(value);
        }
        return result;
    }

    public static boolean validaCpf(String cpf) {
        int num;
        int i;
        String value = cpf.replace(".", "").replace("-", "");
        if (CpfCnpjUtils.validaTamanhoRepeticaoCpf(value)) {
            return false;
        }
        int sm = 0;
        int peso = 10;
        for (i = 0; i < 9; ++i) {
            num = value.charAt(i) - 48;
            sm += num * peso;
            --peso;
        }
        int r = 11 - sm % 11;
        char dig10 = r == 10 || r == 11 ? (char)'0' : (char)((char)(r + 48));
        sm = 0;
        peso = 11;
        for (i = 0; i < 10; ++i) {
            num = value.charAt(i) - 48;
            sm += num * peso;
            --peso;
        }
        r = 11 - sm % 11;
        char dig11 = r == 10 || r == 11 ? (char)'0' : (char)((char)(r + 48));
        return dig10 == value.charAt(9) && dig11 == value.charAt(10);
    }

    public static String formataCpfCnpj(String value) {
        String retorno;
        if (value == null) {
            return "";
        }
        value = CharacterUtils.onlyNumber(value);
        StringBuilder cpfCNPJ = new StringBuilder();
        if (value.length() <= 11) {
            for (int i = 0; i < 11 - value.length(); ++i) {
                cpfCNPJ.append("0");
            }
            cpfCNPJ.append(value);
            retorno = cpfCNPJ.substring(0, 3) + "." + cpfCNPJ.substring(3, 6) + "." + cpfCNPJ.substring(6, 9) + "-" + cpfCNPJ.substring(9, 11);
        } else {
            for (int i = 0; i < 14 - value.length(); ++i) {
                cpfCNPJ.append("0");
            }
            cpfCNPJ.append(value);
            retorno = cpfCNPJ.substring(0, 2) + "." + cpfCNPJ.substring(2, 5) + "." + cpfCNPJ.substring(5, 8) + "/" + cpfCNPJ.substring(8, 12) + "-" + cpfCNPJ.substring(12, 14);
        }
        return retorno;
    }

    public static String formataCnpjBase(String numero) {
        if (numero == null) {
            return "";
        }
        StringBuilder cpfCNPJ = new StringBuilder();
        for (int i = 0; i < 8 - numero.length(); ++i) {
            cpfCNPJ.append("0");
        }
        cpfCNPJ.append(numero);
        String retorno = cpfCNPJ.substring(0, 2) + "." + cpfCNPJ.substring(2, 5) + "." + cpfCNPJ.substring(5, 8);
        return retorno;
    }

    public static String cnpjBase(String cnpj) {
        return cnpj.substring(0, 8);
    }

    private static int parseCharToInt(char c) {
        return Integer.parseInt(Character.toString(c));
    }

    private static String formataMascara(String valor, String mascara) {
        Object dado = "";
        for (int i = 0; i < valor.length(); ++i) {
            char c = valor.charAt(i);
            if (!Character.isDigit(c)) continue;
            dado = (String)dado + Character.toString(c);
        }
        int indMascara = mascara.length();
        int indCampo = ((String)dado).length();
        while (indCampo > 0 && indMascara > 0) {
            if (mascara.charAt(--indMascara) != '#') continue;
            --indCampo;
        }
        Object saida = "";
        while (indMascara < mascara.length()) {
            if (mascara.charAt(indMascara) == '#') {
                saida = (String)saida + ((String)dado).charAt(indCampo);
                ++indCampo;
            } else {
                saida = (String)saida + mascara.charAt(indMascara);
            }
            ++indMascara;
        }
        return saida;
    }

    private static boolean validaTamanhoRepeticaoCpf(String value) {
        for (int i = 0; i < 10; ++i) {
            if (!CharacterUtils.replicate(Integer.toString(i), 11).equals(value)) continue;
            return true;
        }
        return value.length() != 11;
    }

    private static boolean validaTamanhoRepeticaoCnpj(String value) {
        for (int i = 0; i < 13; ++i) {
            if (!CharacterUtils.replicate(Integer.toString(i), 14).equals(value)) continue;
            return true;
        }
        return NumberUtils.onlyNumber(value).length() != 14;
    }

    public static boolean validaCnpj(String value) {
        if (CpfCnpjUtils.validaTamanhoRepeticaoCnpj(value)) {
            return false;
        }
        String cnpj = value;
        cnpj = cnpj.replaceAll(Pattern.compile("\\s").toString(), "");
        if ((cnpj = cnpj.replaceAll(Pattern.compile("\\D").toString(), "")).length() != 14) {
            return false;
        }
        char[] aCnpj = cnpj.toCharArray();
        int soma = CpfCnpjUtils.parseCharToInt(aCnpj[0]) * 5;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[1]) * 4;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[2]) * 3;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[3]) * 2;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[4]) * 9;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[5]) * 8;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[6]) * 7;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[7]) * 6;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[8]) * 5;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[9]) * 4;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[10]) * 3;
        int d1 = (soma += CpfCnpjUtils.parseCharToInt(aCnpj[11]) * 2) % 11;
        d1 = d1 < 2 ? 0 : 11 - d1;
        soma = 0;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[0]) * 6;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[1]) * 5;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[2]) * 4;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[3]) * 3;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[4]) * 2;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[5]) * 9;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[6]) * 8;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[7]) * 7;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[8]) * 6;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[9]) * 5;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[10]) * 4;
        soma += CpfCnpjUtils.parseCharToInt(aCnpj[11]) * 3;
        int d2 = (soma += CpfCnpjUtils.parseCharToInt(aCnpj[12]) * 2) % 11;
        d2 = d2 < 2 ? 0 : 11 - d2;
        return CpfCnpjUtils.parseCharToInt(aCnpj[12]) == d1 && CpfCnpjUtils.parseCharToInt(aCnpj[13]) == d2;
    }

    public static boolean isValidAndNotRequired(String cpfCnpj) {
        if (StringUtils.isNullOrEmpty(cpfCnpj)) {
            return true;
        }
        return CpfCnpjUtils.valida(cpfCnpj);
    }

    public static boolean isCpf(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        return CharacterUtils.onlyNumber(value).length() < 12;
    }

    public static boolean isCnpj(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        return CharacterUtils.onlyNumber(value).length() > 11;
    }

    public static void main(String[] args) {
        boolean valido = CpfCnpjUtils.valida("9317675000133");
        if (valido) {
            LogUtils.warning("OK");
        } else {
            LogUtils.warning("N\u00c3O OK");
        }
    }
}

