/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    public static String getValue(String xml, String atributo) {
        if (xml == null) {
            return "";
        }
        Pattern regexValue = Pattern.compile("<" + atributo + ">([^<]+)</" + atributo + ">");
        Matcher match = regexValue.matcher(xml);
        if (match.find()) {
            return match.group(1);
        }
        return "";
    }

    public static String format(String unformattedXml) throws IOException, ParserConfigurationException, SAXException {
        Document document = XmlUtils.parseXmlFile(unformattedXml);
        OutputFormat format = new OutputFormat(document);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        StringWriter out = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)out, format);
        serializer.serialize(document);
        return ((Object)out).toString();
    }

    private static Document parseXmlFile(String in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(in));
        return db.parse(is);
    }

    public static String generate(Collection<?> listData) throws IOException {
        if (listData.isEmpty()) {
            return "";
        }
        try {
            Database database = new Database();
            database.setRecords(listData);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Database.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)database, (Writer)sw);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> String marshal(Class<T> clazz, T instance) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller m = context.createMarshaller();
            CharArrayWriter writer = new CharArrayWriter();
            m.marshal(instance, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception ex) {
            LogUtils.generate("Erro na conversao para XML da instancia da CLASSE: " + clazz.getName());
            throw new RuntimeException(ex);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, String xml) {
        try {
            JAXBContext contextRetorno = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = contextRetorno.createUnmarshaller();
            CharArrayReader reader = new CharArrayReader(xml.toCharArray());
            Object unmarshalled = unmarshaller.unmarshal((Reader)reader);
            return (T)(unmarshalled instanceof JAXBElement ? ((JAXBElement)unmarshalled).getValue() : clazz.cast(unmarshalled));
        }
        catch (Exception ex) {
            LogUtils.generate("Erro na conversao do XML para instancia da CLASSE " + clazz.getSimpleName() + "  XML: " + xml);
            LogUtils.generate(ex);
            throw new RuntimeException(ex);
        }
    }

    public static String prettyPrintByTransformer(String xmlString, int indent, boolean ignoreDeclaration) {
        try {
            InputSource src = new InputSource(new StringReader(xmlString));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", ignoreDeclaration ? "yes" : "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurs when pretty-printing xml:\n" + xmlString, e);
        }
    }

    public static boolean validateXmlSchema(File xsd, File xml) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(xsd);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(xml));
            return true;
        }
        catch (IOException | SAXException e) {
            LogUtils.generate(e);
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        XmlUtils.validateXmlSchema(new File("/tmp/_xsd.xsd"), new File("/tmp/_xml.xml"));
    }

    @XmlRootElement
    public static class Database {
        Collection<?> records = new ArrayList();

        public Collection<?> getRecords() {
            return this.records;
        }

        public void setRecords(Collection<?> records) {
            this.records = records;
        }
    }
}

