/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class WavUtils {
    private WavUtils() {
    }

    public static boolean playUnique(InputStream arquivo) {
        return WavUtils.play(arquivo, 0);
    }

    public static boolean playRepeat(InputStream arquivo) {
        return WavUtils.play(arquivo, -1);
    }

    private static boolean play(InputStream arquivo, int count) {
        boolean bl;
        block15: {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(arquivo);
            try {
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info dataLineInfo = new DataLine.Info(Clip.class, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * audioFormat.getFrameSize());
                try (Clip clip = (Clip)AudioSystem.getLine(dataLineInfo);){
                    clip.addLineListener(e -> {
                        if (LineEvent.Type.STOP.equals(e.getType())) {
                            e.getLine().close();
                        }
                    });
                    clip.open(audioInputStream);
                    clip.loop(count);
                }
                bl = true;
                if (audioInputStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (audioInputStream != null) {
                        try {
                            audioInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | LineUnavailableException | UnsupportedAudioFileException e2) {
                    LogUtils.generate(e2);
                    return false;
                }
            }
            audioInputStream.close();
        }
        return bl;
    }
}

