/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public final class StringUtils {
    private StringUtils() {
    }

    public static String requireNonNullNonEmptyElse(String value, String valueDefault) {
        if (StringUtils.isNullOrEmpty(value)) {
            return valueDefault;
        }
        return value;
    }

    public static String replace(String assunto, String valorAntigo, String valorNovo, int ocorrencia) {
        int j = 0;
        StringBuilder stringbuffer = new StringBuilder(assunto);
        boolean flag1 = true;
        while (j >= 0 && flag1) {
            switch (ocorrencia) {
                case 0: {
                    j = stringbuffer.toString().indexOf(valorAntigo);
                    break;
                }
                case 1: {
                    j = stringbuffer.toString().indexOf(valorAntigo);
                    flag1 = false;
                    break;
                }
                case 2: {
                    j = stringbuffer.toString().lastIndexOf(valorAntigo);
                    flag1 = false;
                    break;
                }
                default: {
                    j = -1;
                }
            }
            if (j < 0) continue;
            int k = j + valorAntigo.length();
            stringbuffer.replace(j, k, valorNovo);
        }
        return stringbuffer.toString();
    }

    public static String replaceString(String str, String oldValue, String newValue) {
        return str.replace(oldValue, newValue);
    }

    public static String replace(String str, String[] oldValues, String[] newValues, int numberOcorrency) {
        String result = str;
        int max = Math.max(oldValues.length, newValues.length);
        for (int k = 0; k < max; ++k) {
            result = StringUtils.replace(result, oldValues[k], newValues[k], numberOcorrency);
        }
        return result;
    }

    public static String[] split(String str, String delimitador) {
        StringTokenizer stringtokenizer = new StringTokenizer(str, delimitador);
        Vector<String> vector = new Vector<String>();
        while (stringtokenizer.hasMoreTokens()) {
            vector.add(stringtokenizer.nextToken());
        }
        String[] as = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            as[i] = (String)vector.elementAt(i);
        }
        return as;
    }

    public static String nameOfClass(Class<?> clazz) {
        return StringUtils.nameOfClass(clazz.getName());
    }

    public static String nameOfClass(String nameOfClass) {
        int i = nameOfClass.lastIndexOf(46) + 1;
        return nameOfClass.substring(i);
    }

    public static String removeAccents(String s) {
        if (s == null) {
            return s;
        }
        char[] ac = s.toCharArray();
        block18: for (int i = 0; i < s.length(); ++i) {
            if (ac[i] <= 'z') continue;
            switch (ac[i]) {
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c2': 
                case '\u00c3': 
                case '\u00c4': 
                case '\u00c5': {
                    ac[i] = 65;
                    continue block18;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e3': 
                case '\u00e4': {
                    ac[i] = 97;
                    continue block18;
                }
                case '\u00c8': 
                case '\u00c9': 
                case '\u00ca': 
                case '\u00cb': {
                    ac[i] = 69;
                    continue block18;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': {
                    ac[i] = 101;
                    continue block18;
                }
                case '\u00cc': 
                case '\u00cd': 
                case '\u00ce': 
                case '\u00cf': {
                    ac[i] = 73;
                    continue block18;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': {
                    ac[i] = 105;
                    continue block18;
                }
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d4': 
                case '\u00d5': 
                case '\u00d6': {
                    ac[i] = 79;
                    continue block18;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f5': 
                case '\u00f6': {
                    ac[i] = 111;
                    continue block18;
                }
                case '\u00d9': 
                case '\u00da': 
                case '\u00db': 
                case '\u00dc': {
                    ac[i] = 85;
                    continue block18;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': {
                    ac[i] = 117;
                    continue block18;
                }
                case '\u00c7': {
                    ac[i] = 67;
                    continue block18;
                }
                case '\u00e7': {
                    ac[i] = 99;
                    continue block18;
                }
                case '\u00d1': {
                    ac[i] = 78;
                    continue block18;
                }
                case '\u00f1': {
                    ac[i] = 110;
                    continue block18;
                }
                case '\u00dd': {
                    ac[i] = 89;
                    continue block18;
                }
                case '\u00d0': {
                    ac[i] = 68;
                    continue block18;
                }
            }
        }
        return new String(ac);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isBlank();
    }

    public static boolean contains(String s, String s1) {
        return s != null && s1 != null && s.indexOf(s1) >= 0;
    }

    public static String removeMask(String valueWithMask) {
        String result = valueWithMask;
        if (!StringUtils.isNullOrEmpty(result)) {
            result = result.replaceAll("[^\\w]", "").replaceAll("[_]", "");
        }
        return result;
    }

    public static String removeZerosLeft(String value) {
        int i;
        if (StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value);
        for (i = 0; i < sb.length() && sb.charAt(i) == '0'; ++i) {
        }
        return sb.substring(i);
    }

    public static String onlyLetters(String value) {
        return value.replaceAll("(\\d+)", "");
    }

    public static String onlyLettersOrNumbers(String value) {
        return value.replaceAll("[^A-Za-z0-9]+", "");
    }

    public static String removeSequenceLetters(String value) {
        return value.replaceAll("(.)\\1{1,}", "$1");
    }

    public static String nullAsBlank(Object value) {
        return value == null ? "" : value.toString();
    }

    public static String replicate(String value, int quantity) {
        Object result = "";
        for (int i = 0; i < quantity; ++i) {
            result = (String)result + value;
        }
        return result;
    }

    public static int count(String str, String target) {
        int originalLength = str.length();
        int newLength = str.replace(target, "").length();
        return (originalLength - newLength) / target.length();
    }

    public static boolean isNotEmpty(String value) {
        return !StringUtils.isNullOrEmpty(value);
    }

    public static String gzipCompressToBase64(String content) throws IOException {
        if (StringUtils.isNullOrEmpty(content)) {
            throw new IllegalArgumentException("content is either null or blank");
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(content.length());){
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(content.getBytes(StandardCharsets.UTF_8));
            }
            String string = Base64.getEncoder().encodeToString(out.toByteArray());
            return string;
        }
    }

    public static String gzipDecompressFromBase64(String content) throws IOException {
        if (StringUtils.isNullOrEmpty(content)) {
            throw new IllegalArgumentException("content is either null or blank");
        }
        byte[] decode = Base64.getDecoder().decode(content.getBytes(StandardCharsets.UTF_8));
        try (ByteArrayInputStream bis = new ByteArrayInputStream(decode);){
            String string;
            try (GZIPInputStream gis = new GZIPInputStream(bis);){
                string = IOUtils.toString((InputStream)gis, (Charset)StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    public static void main(String[] args) throws IOException {
        LogUtils.generate(StringUtils.gzipDecompressFromBase64("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"));
    }

    public static boolean isOnlyNumber(String value) {
        if (value == null) {
            return false;
        }
        return value.matches("^[0-9]*$");
    }
}

