/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public final class SleepUtils {
    public static final long ONE_HUNDRED = 1000L;
    public static final int SIXTY = 60;

    private SleepUtils() {
    }

    public static void pauseMilliSeconds(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException ex) {
            LogUtils.generate(ex);
            Thread.currentThread().interrupt();
        }
    }

    public static void pauseSeconds(int segundos) {
        try {
            Thread.sleep((long)segundos * 1000L);
        }
        catch (InterruptedException ex) {
            LogUtils.generate(ex);
            Thread.currentThread().interrupt();
        }
    }

    public static void pauseMinutes(int minutes) {
        try {
            Thread.sleep((long)(minutes * 60) * 1000L);
        }
        catch (InterruptedException ex) {
            LogUtils.generate(ex);
            Thread.currentThread().interrupt();
        }
    }

    public static <T> void waitEndThreads(Collection<Future<T>> futures) {
        SleepUtils.waitEndThreadsNotifyEach(futures, 0L, null);
    }

    public static <T> void waitEndThreadsNotifyEach(Collection<Future<T>> futures, Consumer<Long> notifyInterval) {
        SleepUtils.waitEndThreadsNotifyEach(futures, 1L, notifyInterval);
    }

    public static <T> void waitEndThreadsNotifyEach(Collection<Future<T>> futures, long intervalLog, Consumer<Long> notifyInterval) {
        long before = 0L;
        long actual = 0L;
        long total = futures.size();
        while (actual < total) {
            LogUtils.generate("Waiting Process Threads " + actual + "/" + total);
            actual = futures.stream().filter(t -> t.isDone() || t.isCancelled()).count();
            if (actual > before) {
                before += intervalLog;
                if (notifyInterval != null) {
                    notifyInterval.accept(before);
                }
            }
            SleepUtils.pauseSeconds(1);
        }
        LogUtils.generate("Process Threads " + actual + "/" + total);
    }
}

