/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import br.com.jarch.util.OperationSystemUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class FileUtils {
    private FileUtils() {
    }

    public static String correctFolderFormat(String value) {
        Object newValue = value.trim();
        if (OperationSystemUtils.isWindows()) {
            if (((String)(newValue = ((String)newValue).replace("/", "\\"))).charAt(((String)newValue).length() - 1) != '\\') {
                newValue = (String)newValue + "\\";
            }
        } else if (((String)(newValue = ((String)newValue).replace("\\", "/"))).charAt(((String)newValue).length() - 1) != '/') {
            newValue = (String)newValue + "/";
        }
        return newValue;
    }

    public static File pathTemp() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static void copy(File arquivoOrigem, File arquivoDestino) throws IOException {
        FileUtils.copy(arquivoOrigem.getAbsolutePath(), arquivoDestino.getAbsolutePath());
    }

    public static void copy(String arquivoOrigem, String arquivoDestino) throws IOException {
        File origem = new File(arquivoOrigem);
        File destino = new File(arquivoDestino);
        try (FileOutputStream out = new FileOutputStream(destino);
             FileInputStream in = new FileInputStream(origem);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    public static void remove(Collection<File> files) {
        files.forEach(FileUtils::remove);
    }

    public static void remove(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File value : files = file.listFiles()) {
                FileUtils.remove(value);
            }
        }
        if (!file.delete()) {
            throw new RuntimeException("Erro deleting file " + file.getAbsolutePath());
        }
    }

    public static String nameFileWithouExtension(File fileName) {
        return FileUtils.nameFileWithouExtension(fileName.getAbsolutePath());
    }

    public static String nameFileWithouExtension(String fileName) {
        String extension = FileUtils.extension(fileName);
        return fileName.replace(extension, "");
    }

    public static String extension(String fileName) {
        return FileUtils.extension(new File(fileName));
    }

    public static String extension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase(Locale.forLanguageTag("pt-BR"));
        }
        if (ext == null) {
            return "";
        }
        return ext;
    }

    public static String content(File arquivo) throws IOException {
        FileReader fileReader = new FileReader(arquivo);
        try (BufferedReader lerArq = new BufferedReader(fileReader);){
            StringBuilder sb = new StringBuilder();
            String linha = lerArq.readLine();
            sb.append(linha + "\n");
            while (linha != null) {
                linha = lerArq.readLine();
                if (linha == null) continue;
                sb.append(linha + "\n");
            }
            fileReader.close();
            String string = sb.toString();
            return string;
        }
    }

    public static void save(File arquivo, String conteudo) throws IOException {
        PrintWriter pw = new PrintWriter(arquivo);
        pw.append(conteudo);
        pw.flush();
        pw.close();
    }

    public static void save(File arquivo, List<String> lista) throws IOException {
        PrintWriter pw = new PrintWriter(arquivo);
        for (String conteudo : lista) {
            pw.append(conteudo + "\n");
        }
        pw.flush();
        pw.close();
    }

    public static void save(File arquivo, InputStream is) {
        try (FileOutputStream os = new FileOutputStream(arquivo);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = is.read(bytes)) != -1) {
                ((OutputStream)os).write(bytes, 0, read);
            }
        }
        catch (IOException ex) {
            LogUtils.generate(ex);
        }
    }

    public static File createTemporary() throws IOException {
        return File.createTempFile("jarch", "jarch");
    }

    public static File createFolderTemporary() throws IOException {
        return Files.createTempDirectory("jarch", new FileAttribute[0]).toFile();
    }

    public static String removeExtension(File file) {
        int dot = file.getName().lastIndexOf(46);
        return file.getName().substring(0, dot);
    }

    public static void saveUtf8(File file, List<String> dados) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));){
            for (String linha : dados) {
                out.write(linha + "\n");
            }
        }
    }

    public static void saveUsAscIi(File file, List<String> dados) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.US_ASCII));){
            for (String linha : dados) {
                out.write(linha + "\n");
            }
        }
    }

    public static File getFile(byte[] bytes) throws IOException {
        File tempFile = File.createTempFile("file", "jarch");
        FileUtils.save(tempFile, bytes);
        return tempFile;
    }

    public static void save(File arquivo, byte[] bytes) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(arquivo);){
            fos.write(bytes);
            FileDescriptor fd = fos.getFD();
            fos.flush();
            fd.sync();
        }
    }

    public static List<String> readLines(byte[] contentFile) {
        try {
            File file = File.createTempFile("fileUtils", ".jarch");
            FileUtils.save(file, contentFile);
            try {
                return Files.lines(Paths.get(file.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8).collect(Collectors.toList());
            }
            catch (UncheckedIOException | MalformedInputException ex) {
                return Files.lines(Paths.get(file.getAbsolutePath(), new String[0]), StandardCharsets.ISO_8859_1).collect(Collectors.toList());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static InputStream convertInputStreamToOutputStream(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[8];
        bos.write(bytes);
        bos.writeTo(outputStream);
        File file = File.createTempFile("file", "jarchs");
        FileUtils.save(file, bos.toByteArray());
        return new FileInputStream(file);
    }

    public static File createTempFile(String prefix, String suffix) {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        try {
            return File.createTempFile(prefix, suffix, directory);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deleteRecursiveWithExtensionFile(Path startPath, final String extension) {
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(extension)) {
                        Files.delete(file);
                        LogUtils.generate("Deleted file: " + String.valueOf(file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    public void deleteRecursiveFile(Path startPath, final File fileDelete) {
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().equals(fileDelete.toString())) {
                        Files.delete(file);
                        LogUtils.generate("Deleted file: " + String.valueOf(file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    public static void move(File filePathOrigem, File filePathDestino) {
        try {
            Path origem = filePathOrigem.toPath();
            Path destino = filePathDestino.toPath();
            if (!filePathDestino.exists()) {
                boolean created = filePathDestino.mkdirs();
                if (!created) {
                    throw new IOException("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio de destino: " + String.valueOf(filePathDestino));
                }
                LogUtils.generate("Pastas de destino criado com sucesso: " + filePathDestino.getAbsolutePath());
            }
            Files.move(origem, destino, StandardCopyOption.REPLACE_EXISTING);
            LogUtils.generate("Pasta movida com sucesso!");
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
    }
}

