/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.BaseSvn;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

class CheckoutSvn
extends BaseSvn {
    private static final long serialVersionUID = -8759154546425267411L;

    public CheckoutSvn(List<String> log, String login, String senha, OutputStream outputStream) {
        super(log, login, senha, outputStream);
    }

    public void checkout(URL urlOrigem, File pastaTrabalho) throws SVNException {
        this.checkout(urlOrigem, pastaTrabalho, 0L);
    }

    public void checkout(URL urlOrigem, File pastaTrabalho, long revisaoDesejada) throws SVNException {
        System.out.println("CHECKOUT: " + urlOrigem.toString() + " em " + pastaTrabalho.getAbsolutePath());
        this.formatBegin(this.log, "CHECKOUT");
        this.formatMiddle(this.log, "FOLDER: " + pastaTrabalho.getAbsolutePath() + " URL: " + String.valueOf(urlOrigem));
        SVNUpdateClient updateClient = this.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        updateClient.setEventHandler(new ISVNEventHandler(){

            public void checkCancelled() {
            }

            public void handleEvent(SVNEvent svnEvent, double arg1) {
                String mensagem = "CHECKOUT: " + svnEvent.getFile().getPath();
                CheckoutSvn.this.formatMiddle(CheckoutSvn.this.log, mensagem);
            }
        });
        SVNRevision revisao = revisaoDesejada == 0L ? SVNRevision.HEAD : SVNRevision.create((long)revisaoDesejada);
        long revision = updateClient.doCheckout(SVNURL.parseURIEncoded((String)urlOrigem.toString()), pastaTrabalho, revisao, revisao, SVNDepth.INFINITY, false);
        this.formatMiddle("Revis\u00e3o: " + revision);
        this.formatEnd("CHECKOUT");
    }
}

