/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import java.io.File;

public class SvnUtils {
    public static boolean ignoraCommitArquivoOuPasta(String arquivo) {
        return SvnUtils.ignoraCommitArquivoOuPasta(new File(arquivo));
    }

    public static boolean ignoraCommitArquivoOuPasta(File arquivo) {
        if (SvnUtils.ignoraPastaArquivo(arquivo, "dist")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraPastaArquivo(arquivo, "bin")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraPastaArquivo(arquivo, "build")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraPastaArquivo(arquivo, "target")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraPastaArquivo(arquivo, "overlays")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraPastaArquivo(arquivo, "node_modules")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraArquivoPastaTerminadoEm(arquivo, ".iml")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraArquivoPastaTerminadoEm(arquivo, "yarn.lock")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        if (SvnUtils.ignoraArquivoPastaTerminadoEm(arquivo, "package-lock.json")) {
            SvnUtils.logIgnoreFileOrFolder(arquivo);
            return true;
        }
        return false;
    }

    private static void logIgnoreFileOrFolder(File arquivo) {
        System.out.println("# IGNORANDO " + arquivo.getAbsolutePath() + " " + "#".repeat(50));
    }

    private static boolean ignoraPastaArquivo(File arquivo, String nomePasta) {
        if (!(!arquivo.getAbsolutePath().endsWith("/" + nomePasta) && !arquivo.getAbsolutePath().contains("/" + nomePasta + "/") || arquivo.getAbsolutePath().contains("/resources/") && arquivo.getAbsolutePath().indexOf("/resources/") <= arquivo.getAbsolutePath().indexOf(nomePasta))) {
            return true;
        }
        return !(!arquivo.getAbsolutePath().endsWith("\\" + nomePasta) && !arquivo.getAbsolutePath().contains("\\" + nomePasta + "\\") || arquivo.getAbsolutePath().contains("\\resources\\") && arquivo.getAbsolutePath().indexOf("\\resources\\") <= arquivo.getAbsolutePath().indexOf(nomePasta));
    }

    private static boolean ignoraArquivoPastaTerminadoEm(File arquivo, String extensao) {
        return arquivo.getAbsolutePath().endsWith(extensao);
    }
}

