/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.util.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class LogSvn {
    public <T> void formatBeginMiddleEnd(List<String> log, Class<T> classe, String[] linhas, OutputStream outputStream) {
        this.formatBeginMiddleEnd(log, classe.getSimpleName(), linhas, outputStream);
    }

    public void formatBegin(List<String> log, String value, OutputStream outputStream) {
        String formattedValue = "# INICIO ".concat(value).concat(" ").concat("#".repeat(70));
        log.add(formattedValue);
        this.addLogOutputStream(formattedValue, outputStream);
    }

    public void formatMiddle(List<String> log, String value, OutputStream outputStream) {
        String formattedValue = "# ".concat(value);
        log.add(formattedValue);
        this.addLogOutputStream(formattedValue, outputStream);
    }

    public void formatEnd(List<String> log, String value, OutputStream outputStream) {
        String formattedValue = "# FIM ".concat(value).concat(" ").concat("#".repeat(70));
        log.add(formattedValue);
        this.addLogOutputStream(formattedValue, outputStream);
    }

    public void formatBeginMiddleEnd(List<String> log, String title, String[] values, OutputStream outputStream) {
        System.out.println(title);
        for (int i = 0; i < values.length; ++i) {
            System.out.println(values[i]);
        }
        String inicio = "# INICIO ".concat(title).concat(" ").concat(" ").concat("#".repeat(70));
        log.add(inicio);
        this.addLogOutputStream(inicio, outputStream);
        for (String linha : values) {
            String meio = "### ".concat(linha);
            log.add(meio);
            this.addLogOutputStream(meio, outputStream);
        }
        String fim = "# FIM ".concat(title).concat(" ").concat("#".repeat(70));
        log.add(fim);
        this.addLogOutputStream(fim, outputStream);
    }

    private void addLogOutputStream(String formattedValue, OutputStream outputStream) {
        try {
            outputStream.write(formattedValue.concat("\n").getBytes());
            LogUtils.generate((String)formattedValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

