/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.listener;

import br.com.jarch.core.crud.listener.VerifyRelationship;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;

public class RelationshipJpaListener {
    @PreUpdate
    public void preRemoveLogic(ICrudEntity entity) {
        if (entity.getDateHourLogicExclusion() != null) {
            this.valid(entity);
        }
    }

    @PreRemove
    public void preRemove(ICrudEntity entity) {
        this.valid(entity);
    }

    private void valid(ICrudEntity entity) {
        try {
            EntityManager entityManager = (EntityManager)CDI.current().select(EntityManager.class, new Annotation[0]).get();
            CDI.current().select(VerifyRelationship.class, new Annotation[0]).stream().findAny().ifPresent(v -> v.verify(entityManager, entity));
        }
        catch (IllegalStateException ex) {
            LogUtils.warning((String)("N\u00e3o foi poss\u00edvel verificar registro de exclusividade. Mensagem Original: " + ex.getMessage()));
        }
    }
}

