/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class DataDetailCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        DataDetailCodeGenerate.generate(element, generateCrud.master().name(), generateCrud.nameSubPackage());
    }

    public static void generate(Element element, String useCase, String nameSubPackage) {
        new DataDetailCodeGenerate(element, useCase, nameSubPackage).generate();
    }

    private DataDetailCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.WEB;
    }

    @Override
    public CodeType getType() {
        return CodeType.DATA_DETAIL;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameEntity() + ";");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.faces.controller.CrudDataDetail;");
        ProcessorUtils.addCode(sbListCode, "import jakarta.enterprise.context.Dependent;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@Dependent");
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " extends CrudDataDetail<" + this.getNameEntity() + "> {");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

