/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class PostgreSQLCastingIntervalSecondJdbcType
implements AdjustableJdbcType {
    public static final PostgreSQLCastingIntervalSecondJdbcType INSTANCE = new PostgreSQLCastingIntervalSecondJdbcType();

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        int scale = indicators.getColumnScale() == -1 ? domainJtd.getDefaultSqlScale(indicators.getTypeConfiguration().getServiceRegistry().getService(JdbcServices.class).getDialect(), this) : indicators.getColumnScale();
        if (scale > 6) {
            return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(2);
        }
        return this;
    }

    @Override
    public Expression wrapTopLevelSelectionExpression(final Expression expression) {
        return new SelfRenderingExpression(){

            @Override
            public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                sqlAppender.append("extract(epoch from ");
                expression.accept(walker);
                sqlAppender.append(')');
            }

            @Override
            public JdbcMappingContainer getExpressionType() {
                return expression.getExpressionType();
            }
        };
    }

    @Override
    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append('(');
        appender.append(writeExpression);
        appender.append("*interval'1 second)");
    }

    @Override
    public int getJdbcTypeCode() {
        return 2;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3100;
    }

    public String toString() {
        return "IntervalSecondJdbcType";
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setBigDecimal(index, this.getBigDecimalValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setBigDecimal(name, this.getBigDecimalValue(value, options));
            }

            private BigDecimal getBigDecimalValue(X value, WrapperOptions options) {
                return this.getJavaType().unwrap(value, BigDecimal.class, options).movePointLeft(9);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getBigDecimal(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getBigDecimal(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getBigDecimal(name), options);
            }

            private X getObject(BigDecimal bigDecimal, WrapperOptions options) throws SQLException {
                if (bigDecimal == null) {
                    return null;
                }
                return this.getJavaType().wrap(bigDecimal.movePointRight(9), options);
            }
        };
    }
}

